/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.projection;

import java.util.function.Function;
import javax.swing.JComponent;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.model.PresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.BaseProjection;

public abstract class Projection<T extends JComponent, C extends ContentModel, P extends PresentationModel>
extends BaseProjection<T, C, P> {
    private ComponentSupplier<T, C, P> componentSupplier;

    protected Projection(C contentModel, P presentationModel, ComponentSupplier<T, C, P> componentSupplier) {
        super(contentModel, presentationModel);
        this.componentSupplier = componentSupplier;
    }

    public void setComponentSupplier(ComponentSupplier<T, C, P> componentSupplier) {
        if (componentSupplier == null) {
            throw new IllegalArgumentException("Cannot pass null component creator");
        }
        this.componentSupplier = componentSupplier;
    }

    public final ComponentSupplier<T, C, P> getComponentSupplier() {
        return this.componentSupplier;
    }

    @Override
    public final T buildBaseComponent() {
        return (T)((JComponent)this.getComponentSupplier().getComponentSupplier(this).apply(this));
    }

    @FunctionalInterface
    public static interface ComponentSupplier<TC extends JComponent, CC extends ContentModel, PC extends PresentationModel> {
        public Function<Projection<TC, CC, PC>, TC> getComponentSupplier(Projection<TC, CC, PC> var1);
    }
}

