/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;

public class PopupPanelManager {
    private List<WeakPopupListener> listenerList = new ArrayList<WeakPopupListener>();
    private static final PopupPanelManager instance = new PopupPanelManager();
    private LinkedList<PopupInfo> shownPath = new LinkedList();
    private Map<JPopupPanel, RadiancePopupMenu> popupHosts = new HashMap<JPopupPanel, RadiancePopupMenu>();

    public static PopupPanelManager defaultManager() {
        return instance;
    }

    private PopupPanelManager() {
    }

    public void showPopup(JComponent popupOriginator, JPopupPanel popupContent, int xOnScreen, int yOnScreen) {
        BaseCommand.SecondaryLifecycle secondaryLifecycle = null;
        if (popupOriginator instanceof JCommandButton) {
            BaseCommand<? extends BaseCommandMenuContentModel> command = ((JCommandButton)popupOriginator).getContentModel();
            secondaryLifecycle = command.getSecondaryLifecycle();
        }
        RadiancePopupMenu popupMenu = new RadiancePopupMenu();
        popupMenu.add(popupContent);
        popupContent.setOriginator(popupOriginator);
        this.popupHosts.put(popupContent, popupMenu);
        this.shownPath.addLast(new PopupInfo(popupOriginator, popupContent));
        popupContent.invalidate();
        popupContent.revalidate();
        Point invokerLocOnScreen = popupOriginator.getLocationOnScreen();
        popupMenu.show(popupOriginator, xOnScreen - invokerLocOnScreen.x, yOnScreen - invokerLocOnScreen.y);
        if (popupOriginator instanceof JCommandButton) {
            ((JCommandButton)popupOriginator).getPopupModel().setPopupShowing(true);
        }
        this.firePopupShown(popupContent, popupOriginator);
        if (secondaryLifecycle != null) {
            secondaryLifecycle.onAfterActivateSecondary(popupContent);
        }
    }

    public void hideLastPopup() {
        if (this.shownPath.isEmpty()) {
            return;
        }
        PopupInfo last = this.shownPath.removeLast();
        BaseCommand.SecondaryLifecycle secondaryLifecycle = null;
        if (last.popupOriginator instanceof JCommandButton) {
            BaseCommand<? extends BaseCommandMenuContentModel> command = ((JCommandButton)last.popupOriginator).getContentModel();
            secondaryLifecycle = command.getSecondaryLifecycle();
        }
        if (secondaryLifecycle != null) {
            secondaryLifecycle.onBeforeDeactivateSecondary(last.popupPanel);
        }
        RadiancePopupMenu popup = this.popupHosts.get(last.popupPanel);
        popup.setVisible(false);
        this.popupHosts.remove(last.popupPanel);
        if (last.popupOriginator instanceof JCommandButton) {
            ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
        }
        last.popupPanel.setOriginator(null);
        this.firePopupHidden(last.popupPanel, last.popupOriginator);
        if (secondaryLifecycle != null) {
            secondaryLifecycle.onAfterDeactivateSecondary(last.popupPanel);
        }
    }

    public void hidePopups(Component comp) {
        RadiancePopupMenu popup;
        BaseCommand<? extends BaseCommandMenuContentModel> command;
        BaseCommand.SecondaryLifecycle secondaryLifecycle;
        PopupInfo last;
        boolean foundAndDismissed = false;
        if (comp != null) {
            for (Component c = comp; c != null; c = c.getParent()) {
                if (!(c instanceof JPopupPanel)) continue;
                foundAndDismissed = true;
                while (!this.shownPath.isEmpty()) {
                    if (this.shownPath.getLast().popupPanel == c) {
                        return;
                    }
                    last = this.shownPath.removeLast();
                    secondaryLifecycle = null;
                    if (last.popupOriginator instanceof JCommandButton) {
                        command = ((JCommandButton)last.popupOriginator).getContentModel();
                        secondaryLifecycle = command.getSecondaryLifecycle();
                    }
                    if (secondaryLifecycle != null) {
                        secondaryLifecycle.onBeforeDeactivateSecondary(last.popupPanel);
                    }
                    popup = this.popupHosts.get(last.popupPanel);
                    popup.setVisible(false);
                    if (last.popupOriginator instanceof JCommandButton) {
                        ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
                    }
                    last.popupPanel.setOriginator(null);
                    this.firePopupHidden(last.popupPanel, last.popupOriginator);
                    if (secondaryLifecycle != null) {
                        secondaryLifecycle.onAfterDeactivateSecondary(last.popupPanel);
                    }
                    this.popupHosts.remove(last.popupPanel);
                }
            }
        }
        if (!foundAndDismissed || comp == null) {
            Component lastOriginator = null;
            while (!this.shownPath.isEmpty()) {
                last = this.shownPath.removeLast();
                lastOriginator = last.popupOriginator;
                secondaryLifecycle = null;
                if (last.popupOriginator instanceof JCommandButton) {
                    command = ((JCommandButton)last.popupOriginator).getContentModel();
                    secondaryLifecycle = command.getSecondaryLifecycle();
                }
                if (secondaryLifecycle != null) {
                    secondaryLifecycle.onBeforeDeactivateSecondary(last.popupPanel);
                }
                popup = this.popupHosts.get(last.popupPanel);
                popup.setVisible(false);
                if (last.popupOriginator instanceof JCommandButton) {
                    ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
                }
                last.popupPanel.setOriginator(null);
                this.firePopupHidden(last.popupPanel, last.popupOriginator);
                if (secondaryLifecycle != null) {
                    secondaryLifecycle.onAfterDeactivateSecondary(last.popupPanel);
                }
                this.popupHosts.remove(last.popupPanel);
            }
            if (lastOriginator != null && lastOriginator.isFocusable()) {
                lastOriginator.requestFocus();
            }
        }
    }

    public List<PopupInfo> getShownPath() {
        return Collections.unmodifiableList(this.shownPath);
    }

    public void addPopupListener(PopupListener l) {
        if (l instanceof WeakPopupListener) {
            throw new IllegalArgumentException("Don't pass an explicitly wrapped listener");
        }
        this.listenerList.add(new WeakPopupListener(l));
    }

    public void removePopupListener(PopupListener l) {
        if (l instanceof WeakPopupListener) {
            throw new IllegalArgumentException("Don't pass an explicitly wrapped listener");
        }
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            WeakPopupListener current = this.listenerList.get(i);
            PopupListener original = (PopupListener)current.listenerRef.get();
            if (original != l) continue;
            this.listenerList.remove(i);
        }
    }

    protected void firePopupShown(JPopupPanel panel, JComponent popupOriginator) {
        PopupListener original;
        WeakPopupListener current;
        int i;
        PopupEvent popupEvent = new PopupEvent(panel, 104, popupOriginator);
        for (i = this.listenerList.size() - 1; i >= 0; --i) {
            current = this.listenerList.get(i);
            original = (PopupListener)current.listenerRef.get();
            if (original == null) continue;
            original.popupShown(popupEvent);
        }
        for (i = this.listenerList.size() - 1; i >= 0; --i) {
            current = this.listenerList.get(i);
            original = (PopupListener)current.listenerRef.get();
            if (original != null) continue;
            this.listenerList.remove(i);
        }
    }

    protected void firePopupHidden(JPopupPanel panel, JComponent popupOriginator) {
        PopupListener original;
        WeakPopupListener current;
        int i;
        PopupEvent popupEvent = new PopupEvent(panel, 105, popupOriginator);
        for (i = this.listenerList.size() - 1; i >= 0; --i) {
            current = this.listenerList.get(i);
            original = (PopupListener)current.listenerRef.get();
            if (original == null) continue;
            original.popupHidden(popupEvent);
        }
        for (i = this.listenerList.size() - 1; i >= 0; --i) {
            current = this.listenerList.get(i);
            original = (PopupListener)current.listenerRef.get();
            if (original != null) continue;
            this.listenerList.remove(i);
        }
    }

    public static class RadiancePopupMenu
    extends JPopupMenu {
        public RadiancePopupMenu() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.addPropertyChangeListener(evt -> {
                if ("JPopupMenu.firePopupMenuCanceled".equals(evt.getPropertyName()) && evt.getNewValue() instanceof Boolean) {
                    PopupPanelManager.defaultManager().hidePopups(null);
                }
            });
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }
    }

    public static class PopupInfo {
        private JPopupPanel popupPanel;
        private JComponent popupOriginator;

        public PopupInfo(JComponent popupOriginator, JPopupPanel popupPanel) {
            this.popupOriginator = popupOriginator;
            this.popupPanel = popupPanel;
        }

        public JPopupPanel getPopupPanel() {
            return this.popupPanel;
        }

        public JComponent getPopupOriginator() {
            return this.popupOriginator;
        }
    }

    public static class PopupEvent
    extends ComponentEvent {
        public static final int POPUP_SHOWN = 104;
        public static final int POPUP_HIDDEN = 105;
        private JComponent popupOriginator;

        public PopupEvent(JPopupPanel source, int id, JComponent popupOriginator) {
            super(source, id);
            this.popupOriginator = popupOriginator;
        }

        public JComponent getPopupOriginator() {
            return this.popupOriginator;
        }
    }

    private static class WeakPopupListener
    implements PopupListener {
        private WeakReference<PopupListener> listenerRef;

        public WeakPopupListener(PopupListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Cannot wrap a null listener");
            }
            this.listenerRef = new WeakReference<PopupListener>(listener);
        }

        @Override
        public void popupShown(PopupEvent event) {
            PopupListener originalListener = (PopupListener)this.listenerRef.get();
            if (originalListener != null) {
                originalListener.popupShown(event);
            } else {
                PopupPanelManager.defaultManager().listenerList.remove(this);
                this.listenerRef = null;
            }
        }

        @Override
        public void popupHidden(PopupEvent event) {
            PopupListener originalListener = (PopupListener)this.listenerRef.get();
            if (originalListener != null) {
                originalListener.popupHidden(event);
            } else {
                PopupPanelManager.defaultManager().listenerList.remove(this);
                this.listenerRef = null;
            }
        }
    }

    public static interface PopupListener
    extends EventListener {
        public void popupShown(PopupEvent var1);

        public void popupHidden(PopupEvent var1);
    }
}

