/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.awt.Dimension;
import java.awt.Insets;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.common.model.ImmutablePresentationModel;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;

public class SwitchPresentationModel
implements ImmutablePresentationModel {
    public static final Insets DEFAULT_SWITCH_CONTENT_PADDING = new Insets(4, 6, 4, 4);
    public static final int SWITCH_TRACK_WIDTH = 36;
    public static final int SWITCH_TRACK_HEIGHT = 18;
    public static final int SWITCH_THUMB_SIZE_ON = 12;
    public static final int SWITCH_THUMB_SIZE_OFF = 10;
    private Insets contentPadding;
    private Dimension trackSize;
    private int thumbSizeOn;
    private int thumbSizeOff;
    private HorizontalAlignment horizontalAlignment;
    private RichTooltipPresentationModel richTooltipPresentationModel;

    private SwitchPresentationModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Insets getContentPadding() {
        return this.contentPadding;
    }

    public Dimension getTrackSize() {
        return this.trackSize;
    }

    public int getThumbSizeOn() {
        return this.thumbSizeOn;
    }

    public int getThumbSizeOff() {
        return this.thumbSizeOff;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public RichTooltipPresentationModel getRichTooltipPresentationModel() {
        return this.richTooltipPresentationModel;
    }

    public static class Builder {
        private Insets contentPadding = DEFAULT_SWITCH_CONTENT_PADDING;
        private Dimension trackSize = new Dimension(36, 18);
        private int thumbSizeOn = 12;
        private int thumbSizeOff = 10;
        private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEADING;
        private RichTooltipPresentationModel richTooltipPresentationModel = RichTooltipPresentationModel.builder().build();

        public Builder setContentPadding(Insets contentPadding) {
            if (contentPadding == null) {
                throw new IllegalArgumentException("Cannot pass null content padding");
            }
            this.contentPadding = contentPadding;
            return this;
        }

        public Builder setTrackSize(Dimension trackSize) {
            if (trackSize == null) {
                throw new IllegalArgumentException("Cannot pass null track size");
            }
            this.trackSize = trackSize;
            return this;
        }

        public Builder setThumbSizes(int thumbSizeOn, int thumbSizeOff) {
            this.thumbSizeOn = thumbSizeOn;
            this.thumbSizeOff = thumbSizeOff;
            return this;
        }

        public Builder setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            if (horizontalAlignment == null) {
                throw new IllegalArgumentException("Cannot pass null horizontal alignment");
            }
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setRichTooltipPresentationModel(RichTooltipPresentationModel richTooltipPresentationModel) {
            if (richTooltipPresentationModel == null) {
                throw new IllegalArgumentException("Cannot pass null tooltip presentation model");
            }
            this.richTooltipPresentationModel = richTooltipPresentationModel;
            return this;
        }

        public SwitchPresentationModel build() {
            SwitchPresentationModel presentationModel = new SwitchPresentationModel();
            presentationModel.contentPadding = this.contentPadding;
            presentationModel.trackSize = this.trackSize;
            presentationModel.thumbSizeOn = this.thumbSizeOn;
            presentationModel.thumbSizeOff = this.thumbSizeOff;
            presentationModel.horizontalAlignment = this.horizontalAlignment;
            presentationModel.richTooltipPresentationModel = this.richTooltipPresentationModel;
            return presentationModel;
        }
    }
}

