/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;

public class SwitchContentModel
implements ContentModel {
    private boolean isEnabled;
    private boolean isSelected;
    private RichTooltip richTooltip;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private SwitchContentModel() {
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            this.pcs.firePropertyChange("selected", !this.isSelected, this.isSelected);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public ItemListener getItemListener() {
        return this.itemListener;
    }

    public static class Builder {
        private boolean isEnabled = true;
        private boolean isSelected = false;
        private RichTooltip richTooltip;
        private ActionListener actionListener;
        private ItemListener itemListener;

        public Builder setSelected(boolean selected) {
            this.isSelected = selected;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public Builder setActionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
            return this;
        }

        public Builder setItemListener(ItemListener itemListener) {
            this.itemListener = itemListener;
            return this;
        }

        public SwitchContentModel build() {
            SwitchContentModel model = new SwitchContentModel();
            model.isSelected = this.isSelected;
            model.actionListener = this.actionListener;
            if (this.itemListener != null) {
                model.itemListener = new ItemListener(){
                    private boolean lastIsSelected;
                    {
                        this.lastIsSelected = isSelected;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean newIsSelected;
                        boolean bl = newIsSelected = e.getStateChange() == 1;
                        if (this.lastIsSelected == newIsSelected) {
                            return;
                        }
                        itemListener.itemStateChanged(e);
                        this.lastIsSelected = newIsSelected;
                    }
                };
            }
            model.isEnabled = this.isEnabled;
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

