/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.model.PropertyChangeAware;
import org.pushingpixels.radiance.component.internal.utils.WeakPropertyChangeSupport;

public class LabelContentModel
implements ContentModel,
PropertyChangeAware {
    private String text;
    private boolean isEnabled;
    private RadianceIcon.Factory iconFactory;
    private final WeakPropertyChangeSupport weakPropertyChangeSupport = new WeakPropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private LabelContentModel() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.weakPropertyChangeSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.weakPropertyChangeSupport.removePropertyChangeListener(pcl);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.weakPropertyChangeSupport.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            String old = this.text;
            this.text = text;
            this.weakPropertyChangeSupport.firePropertyChange("text", old, this.text);
        }
    }

    public RadianceIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    public void setIconFactory(RadianceIcon.Factory iconFactory) {
        if (this.iconFactory != iconFactory) {
            RadianceIcon.Factory old = this.iconFactory;
            this.iconFactory = iconFactory;
            this.weakPropertyChangeSupport.firePropertyChange("iconFactory", old, this.iconFactory);
        }
    }

    public static class Builder {
        private String text = "";
        private boolean isEnabled = true;
        private RadianceIcon.Factory iconFactory;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setIconFactory(RadianceIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return this;
        }

        public LabelContentModel build() {
            LabelContentModel model = new LabelContentModel();
            model.text = this.text;
            model.isEnabled = this.isEnabled;
            model.iconFactory = this.iconFactory;
            return model;
        }
    }
}

