/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.ChangeAware;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.internal.utils.WeakChangeSupport;

public class CommandPanelContentModel
implements ContentModel,
ChangeAware {
    private List<CommandGroup> commandGroups;
    private boolean isSingleSelectionMode;
    private BaseCommand.CommandActionPreview commandPreviewListener;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);
    private CommandGroup.CommandGroupListener commandGroupListener;
    private PropertyChangeListener commandGroupPropertyChangeListener;
    private PropertyChangeListener commandPropertyChangeListener;
    private Command selectedCommand;

    public CommandPanelContentModel(List<CommandGroup> commands) {
        this.commandGroups = new ArrayList<CommandGroup>(commands);
        this.commandPropertyChangeListener = evt -> {
            if (evt.getPropertyName().equals("isToggleSelected")) {
                SwingUtilities.invokeLater(this::syncSelectedCommand);
            }
        };
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            @Override
            public void onCommandAdded(Command command) {
                command.addPropertyChangeListener(CommandPanelContentModel.this.commandPropertyChangeListener);
                CommandPanelContentModel.this.fireStateChanged();
            }

            @Override
            public void onCommandRemoved(Command command) {
                command.removePropertyChangeListener(CommandPanelContentModel.this.commandPropertyChangeListener);
                CommandPanelContentModel.this.fireStateChanged();
            }

            @Override
            public void onAllCommandsRemoved(List<Command> commands) {
                for (Command command : commands) {
                    command.removePropertyChangeListener(CommandPanelContentModel.this.commandPropertyChangeListener);
                }
                CommandPanelContentModel.this.fireStateChanged();
            }
        };
        this.commandGroupPropertyChangeListener = propertyChangeEvent -> this.fireStateChanged();
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.addCommandGroupListener(this.commandGroupListener);
            commandGroupModel.addPropertyChangeListener(this.commandGroupPropertyChangeListener);
            for (Command command : commandGroupModel.getCommands()) {
                command.addPropertyChangeListener(this.commandPropertyChangeListener);
            }
        }
    }

    public void addCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.add(commandGroupModel);
        commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        commandGroupModel.addPropertyChangeListener(this.commandGroupPropertyChangeListener);
        for (Command command : commandGroupModel.getCommands()) {
            command.addPropertyChangeListener(this.commandPropertyChangeListener);
        }
        boolean firedStateChange = this.syncSelectedCommand();
        if (!firedStateChange) {
            this.fireStateChanged();
        }
    }

    public void removeCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.remove(commandGroupModel);
        commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
        commandGroupModel.removePropertyChangeListener(this.commandGroupPropertyChangeListener);
        for (Command command : commandGroupModel.getCommands()) {
            command.removePropertyChangeListener(this.commandPropertyChangeListener);
        }
        boolean firedStateChange = this.syncSelectedCommand();
        if (!firedStateChange) {
            this.fireStateChanged();
        }
    }

    public void removeAllCommandGroups() {
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
            commandGroupModel.removePropertyChangeListener(this.commandGroupPropertyChangeListener);
            for (Command command : commandGroupModel.getCommands()) {
                command.removePropertyChangeListener(this.commandPropertyChangeListener);
            }
        }
        this.commandGroups.clear();
        boolean firedStateChange = this.syncSelectedCommand();
        if (!firedStateChange) {
            this.fireStateChanged();
        }
    }

    public List<CommandGroup> getCommandGroups() {
        return Collections.unmodifiableList(this.commandGroups);
    }

    public int getCommandCount() {
        int result = 0;
        for (CommandGroup commandGroupModel : this.getCommandGroups()) {
            result += commandGroupModel.getCommands().size();
        }
        return result;
    }

    public Command findFirstMatch(CommandGroup.CommandFilter commandFilter) {
        for (CommandGroup commandGroup : this.commandGroups) {
            Command result = commandGroup.findFirstMatch(commandFilter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setSingleSelectionMode(boolean isSingleSelectionMode) {
        if (this.isSingleSelectionMode == isSingleSelectionMode) {
            return;
        }
        this.isSingleSelectionMode = isSingleSelectionMode;
        this.syncSelectedCommand();
        this.fireStateChanged();
    }

    public Command getSelectedCommand() {
        return this.selectedCommand;
    }

    public boolean isSingleSelectionMode() {
        return this.isSingleSelectionMode;
    }

    public void setCommandPreviewListener(BaseCommand.CommandActionPreview commandPreviewListener) {
        this.commandPreviewListener = commandPreviewListener;
    }

    public BaseCommand.CommandActionPreview getCommandPreviewListener() {
        return this.commandPreviewListener;
    }

    private boolean syncSelectedCommand() {
        Command previouslySelectedCommand = this.selectedCommand;
        if (!this.isSingleSelectionMode) {
            this.selectedCommand = null;
            if (previouslySelectedCommand != null) {
                this.fireStateChanged();
                return true;
            }
            return false;
        }
        for (CommandGroup commandGroup : this.commandGroups) {
            for (Command command : commandGroup.getCommands()) {
                if (!command.isToggleSelected()) continue;
                this.selectedCommand = command;
                if (previouslySelectedCommand != this.selectedCommand) {
                    this.fireStateChanged();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }
}

