/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.common.icon.CommandButtonDefaultPopupIcon;
import org.pushingpixels.radiance.component.api.common.model.ImmutablePresentationModel;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public abstract class BaseCommandButtonPresentationModel<MPM extends BaseCommandPopupMenuPresentationModel, PM extends BaseCommandButtonPresentationModel<MPM, PM>>
implements ImmutablePresentationModel {
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.CENTER;
    public static final double DEFAULT_GAP_SCALE_FACTOR = 1.0;
    public static final int DEFAULT_AUTO_REPEAT_INITIAL_INTERVAL_MS = 500;
    public static final int DEFAULT_AUTO_REPEAT_SUBSEQUENT_INTERVAL_MS = 100;
    public static final Insets WIDE_BUTTON_CONTENT_PADDING = new Insets(3, 10, 2, 10);
    public static final Insets COMPACT_BUTTON_CONTENT_PADDING = new Insets(3, 5, 2, 5);
    protected CommandButtonPresentationState presentationState;
    protected Dimension iconDimension;
    protected RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy;
    protected RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy;
    protected RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy;
    protected boolean forceAllocateSpaceForIcon;
    protected RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy;
    protected boolean isFocusable;
    protected HorizontalAlignment horizontalAlignment;
    protected Insets contentPadding;
    protected double horizontalGapScaleFactor;
    protected double verticalGapScaleFactor;
    protected SelectedStateHighlight selectedStateHighlight;
    protected Font font;
    protected RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy;
    protected String actionKeyTip;
    protected String popupKeyTip;
    protected boolean toDismissPopupsOnActivation;
    protected boolean showPopupIcon;
    protected PopupAnchorBoundsProvider popupAnchorBoundsProvider;
    protected RadianceIcon popupIcon;
    protected MPM popupMenuPresentationModel;
    protected TextClick textClick;
    protected boolean isAutoRepeatAction;
    protected boolean hasAutoRepeatIntervalsSet;
    protected int autoRepeatInitialInterval;
    protected int autoRepeatSubsequentInterval;
    protected ActionFireTrigger actionFireTrigger;
    protected PopupFireTrigger popupFireTrigger;
    protected RichTooltipPresentationModel actionRichTooltipPresentationModel;
    protected RichTooltipPresentationModel popupRichTooltipPresentationModel;
    protected RadianceThemingSlices.Sides sides;

    protected BaseCommandButtonPresentationModel() {
    }

    public abstract PM overlayWith(Overlay var1);

    public static Overlay overlay() {
        return new Overlay();
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public RadianceThemingSlices.BackgroundAppearanceStrategy getBackgroundAppearanceStrategy() {
        return this.backgroundAppearanceStrategy;
    }

    public boolean isFocusable() {
        return this.isFocusable;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Insets getContentPadding() {
        return this.contentPadding;
    }

    public double getHorizontalGapScaleFactor() {
        return this.horizontalGapScaleFactor;
    }

    public double getVerticalGapScaleFactor() {
        return this.verticalGapScaleFactor;
    }

    public Dimension getIconDimension() {
        return this.iconDimension;
    }

    public RadianceThemingSlices.IconFilterStrategy getActiveIconFilterStrategy() {
        return this.activeIconFilterStrategy;
    }

    public RadianceThemingSlices.IconFilterStrategy getEnabledIconFilterStrategy() {
        return this.enabledIconFilterStrategy;
    }

    public RadianceThemingSlices.IconFilterStrategy getDisabledIconFilterStrategy() {
        return this.disabledIconFilterStrategy;
    }

    public boolean isForceAllocateSpaceForIcon() {
        return this.forceAllocateSpaceForIcon;
    }

    public Font getFont() {
        return this.font;
    }

    public RadianceThemingSlices.PopupPlacementStrategy getPopupPlacementStrategy() {
        return this.popupPlacementStrategy;
    }

    public boolean isShowPopupIcon() {
        return this.showPopupIcon;
    }

    public RadianceIcon getPopupIcon() {
        return this.popupIcon;
    }

    public PopupAnchorBoundsProvider getPopupAnchorBoundsProvider() {
        return this.popupAnchorBoundsProvider;
    }

    public SelectedStateHighlight getSelectedStateHighlight() {
        return this.selectedStateHighlight;
    }

    public boolean isToDismissPopupsOnActivation() {
        return this.toDismissPopupsOnActivation;
    }

    public MPM getPopupMenuPresentationModel() {
        return this.popupMenuPresentationModel;
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public TextClick getTextClick() {
        return this.textClick;
    }

    public ActionFireTrigger getActionFireTrigger() {
        return this.actionFireTrigger;
    }

    public PopupFireTrigger getPopupFireTrigger() {
        return this.popupFireTrigger;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public boolean hasAutoRepeatIntervalsSet() {
        return this.hasAutoRepeatIntervalsSet;
    }

    public int getAutoRepeatInitialInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatInitialInterval : -1;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatSubsequentInterval : -1;
    }

    public RichTooltipPresentationModel getActionRichTooltipPresentationModel() {
        return this.actionRichTooltipPresentationModel;
    }

    public RichTooltipPresentationModel getPopupRichTooltipPresentationModel() {
        return this.popupRichTooltipPresentationModel;
    }

    public RadianceThemingSlices.Sides getSides() {
        return this.sides;
    }

    public static abstract class BaseBuilder<MPM extends BaseCommandPopupMenuPresentationModel, PM extends BaseCommandButtonPresentationModel<MPM, PM>, B extends BaseBuilder<MPM, PM, B>> {
        private CommandButtonPresentationState presentationState = CommandButtonPresentationState.BIG_FIT_TO_ICON;
        private RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy = RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT;
        private boolean isFocusable = true;
        private HorizontalAlignment horizontalAlignment = DEFAULT_HORIZONTAL_ALIGNMENT;
        private Insets contentPadding = COMPACT_BUTTON_CONTENT_PADDING;
        private double horizontalGapScaleFactor = 1.0;
        private double verticalGapScaleFactor = 1.0;
        private Dimension iconDimension = null;
        private RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        private RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        private RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy = RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
        private boolean forceAllocateSpaceForIcon = false;
        private SelectedStateHighlight selectedStateHighlight = SelectedStateHighlight.FULL_SIZE;
        private Font font = null;
        private RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy = RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_START;
        private boolean showPopupIcon = true;
        private RadianceIcon popupIcon = new CommandButtonDefaultPopupIcon();
        private PopupAnchorBoundsProvider popupAnchorBoundsProvider;
        private String actionKeyTip;
        private String popupKeyTip;
        private boolean toDismissPopupsOnActivation = true;
        private MPM popupMenuPresentationModel;
        private TextClick textClick = TextClick.ACTION;
        private boolean isAutoRepeatAction;
        private boolean hasAutoRepeatIntervalsSet;
        private int autoRepeatInitialInterval = 500;
        private int autoRepeatSubsequentInterval = 100;
        private ActionFireTrigger actionFireTrigger = ActionFireTrigger.ON_PRESS_RELEASED;
        private PopupFireTrigger popupFireTrigger = PopupFireTrigger.ON_PRESSED;
        private RichTooltipPresentationModel actionRichTooltipPresentationModel = RichTooltipPresentationModel.builder().build();
        private RichTooltipPresentationModel popupRichTooltipPresentationModel = RichTooltipPresentationModel.builder().build();
        private RadianceThemingSlices.Sides sides = null;

        public B setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            this.backgroundAppearanceStrategy = backgroundAppearanceStrategy;
            return (B)this;
        }

        public B setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return (B)this;
        }

        public B setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return (B)this;
        }

        public B setContentPadding(Insets contentPadding) {
            this.contentPadding = contentPadding;
            return (B)this;
        }

        public B setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return (B)this;
        }

        public B setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return (B)this;
        }

        public B setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return (B)this;
        }

        public B setIconDimension(Dimension iconDimension) {
            this.iconDimension = iconDimension;
            return (B)this;
        }

        public B setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            this.activeIconFilterStrategy = activeIconFilterStrategy;
            this.enabledIconFilterStrategy = enabledIconFilterStrategy;
            this.disabledIconFilterStrategy = disabledIconFilterStrategy;
            return (B)this;
        }

        public B setForceAllocateSpaceForIcon(boolean forceAllocateSpaceForIcon) {
            this.forceAllocateSpaceForIcon = forceAllocateSpaceForIcon;
            return (B)this;
        }

        public B setFont(Font font) {
            this.font = font;
            return (B)this;
        }

        public B setPopupPlacementStrategy(RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy) {
            this.popupPlacementStrategy = popupPlacementStrategy;
            return (B)this;
        }

        public B setShowPopupIcon(boolean showPopupIcon) {
            this.showPopupIcon = showPopupIcon;
            return (B)this;
        }

        public B setPopupAnchorBoundsProvider(PopupAnchorBoundsProvider popupAnchorBoundsProvider) {
            this.popupAnchorBoundsProvider = popupAnchorBoundsProvider;
            return (B)this;
        }

        public B setPopupIcon(RadianceIcon popupIcon) {
            if (popupIcon == null) {
                throw new IllegalArgumentException("Cannot pass null popup icon");
            }
            this.popupIcon = popupIcon;
            return (B)this;
        }

        public B setSelectedStateHighlight(SelectedStateHighlight selectedStateHighlight) {
            this.selectedStateHighlight = selectedStateHighlight;
            return (B)this;
        }

        public B setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return (B)this;
        }

        public B setPopupMenuPresentationModel(MPM popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return (B)this;
        }

        public B setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return (B)this;
        }

        public B setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return (B)this;
        }

        public B setTextClick(TextClick textClick) {
            this.textClick = textClick;
            return (B)this;
        }

        public B setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return (B)this;
        }

        public B setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return (B)this;
        }

        public B setActionFireTrigger(ActionFireTrigger actionFireTrigger) {
            this.actionFireTrigger = actionFireTrigger;
            return (B)this;
        }

        public B setPopupFireTrigger(PopupFireTrigger popupFireTrigger) {
            this.popupFireTrigger = popupFireTrigger;
            return (B)this;
        }

        public B setActionRichTooltipPresentationModel(RichTooltipPresentationModel actionRichTooltipPresentationModel) {
            if (actionRichTooltipPresentationModel == null) {
                throw new IllegalArgumentException("Cannot pass null presentation model");
            }
            this.actionRichTooltipPresentationModel = actionRichTooltipPresentationModel;
            return (B)this;
        }

        public B setPopupRichTooltipPresentationModel(RichTooltipPresentationModel popupRichTooltipPresentationModel) {
            if (popupRichTooltipPresentationModel == null) {
                throw new IllegalArgumentException("Cannot pass null presentation model");
            }
            this.popupRichTooltipPresentationModel = popupRichTooltipPresentationModel;
            return (B)this;
        }

        public B setSides(RadianceThemingSlices.Sides sides) {
            this.sides = sides;
            return (B)this;
        }

        protected void configureBaseCommandButtonPresentationModel(BaseCommandButtonPresentationModel<MPM, PM> presentationModel) {
            presentationModel.presentationState = this.presentationState;
            presentationModel.horizontalAlignment = this.horizontalAlignment;
            presentationModel.contentPadding = this.contentPadding;
            presentationModel.horizontalGapScaleFactor = this.horizontalGapScaleFactor;
            presentationModel.verticalGapScaleFactor = this.verticalGapScaleFactor;
            presentationModel.backgroundAppearanceStrategy = this.backgroundAppearanceStrategy;
            presentationModel.isFocusable = this.isFocusable;
            presentationModel.iconDimension = this.iconDimension;
            presentationModel.activeIconFilterStrategy = this.activeIconFilterStrategy;
            presentationModel.enabledIconFilterStrategy = this.enabledIconFilterStrategy;
            presentationModel.disabledIconFilterStrategy = this.disabledIconFilterStrategy;
            presentationModel.forceAllocateSpaceForIcon = this.forceAllocateSpaceForIcon;
            presentationModel.selectedStateHighlight = this.selectedStateHighlight;
            presentationModel.font = this.font;
            presentationModel.popupPlacementStrategy = this.popupPlacementStrategy;
            presentationModel.showPopupIcon = this.showPopupIcon;
            presentationModel.popupIcon = this.popupIcon;
            presentationModel.popupAnchorBoundsProvider = this.popupAnchorBoundsProvider;
            presentationModel.actionKeyTip = this.actionKeyTip;
            presentationModel.popupKeyTip = this.popupKeyTip;
            presentationModel.toDismissPopupsOnActivation = this.toDismissPopupsOnActivation;
            presentationModel.popupMenuPresentationModel = this.popupMenuPresentationModel;
            presentationModel.textClick = this.textClick;
            presentationModel.isAutoRepeatAction = this.isAutoRepeatAction;
            presentationModel.hasAutoRepeatIntervalsSet = this.hasAutoRepeatIntervalsSet;
            presentationModel.autoRepeatInitialInterval = this.autoRepeatInitialInterval;
            presentationModel.autoRepeatSubsequentInterval = this.autoRepeatSubsequentInterval;
            presentationModel.actionFireTrigger = this.actionFireTrigger;
            presentationModel.popupFireTrigger = this.popupFireTrigger;
            presentationModel.actionRichTooltipPresentationModel = this.actionRichTooltipPresentationModel;
            presentationModel.popupRichTooltipPresentationModel = this.popupRichTooltipPresentationModel;
            presentationModel.sides = this.sides;
        }
    }

    public static class Overlay {
        private CommandButtonPresentationState presentationState;
        private RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy;
        private Boolean isFocusable;
        private HorizontalAlignment horizontalAlignment;
        private Insets contentPadding;
        private Double horizontalGapScaleFactor;
        private Double verticalGapScaleFactor;
        private Dimension iconDimension;
        private RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy;
        private RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy;
        private RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy;
        private boolean forceAllocateSpaceForIcon;
        private SelectedStateHighlight selectedStateHighlight;
        private Font font;
        private RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy;
        private Boolean showPopupIcon;
        private RadianceIcon popupIcon;
        private PopupAnchorBoundsProvider popupAnchorBoundsProvider;
        private Boolean toDismissPopupsOnActivation;
        private String actionKeyTip;
        private String popupKeyTip;
        private BaseCommandPopupMenuPresentationModel popupMenuPresentationModel;
        private TextClick textClick;
        private Boolean isAutoRepeatAction;
        private Boolean hasAutoRepeatIntervalsSet;
        private Integer autoRepeatInitialInterval;
        private Integer autoRepeatSubsequentInterval;
        private ActionFireTrigger actionFireTrigger;
        private PopupFireTrigger popupFireTrigger;
        private RichTooltipPresentationModel actionRichTooltipPresentationModel;
        private RichTooltipPresentationModel popupRichTooltipPresentationModel;
        private RadianceThemingSlices.Sides sides;

        public Overlay setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            this.backgroundAppearanceStrategy = backgroundAppearanceStrategy;
            return this;
        }

        public Overlay setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Overlay setContentPadding(Insets contentPadding) {
            this.contentPadding = contentPadding;
            return this;
        }

        public Overlay setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Overlay setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return this;
        }

        public Overlay setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return this;
        }

        public Overlay setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return this;
        }

        public Overlay setIconDimension(Dimension iconDimension) {
            this.iconDimension = iconDimension;
            return this;
        }

        public Overlay setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            this.activeIconFilterStrategy = activeIconFilterStrategy;
            this.enabledIconFilterStrategy = enabledIconFilterStrategy;
            this.disabledIconFilterStrategy = disabledIconFilterStrategy;
            return this;
        }

        public Overlay setForceAllocateSpaceForIcon(boolean forceAllocateSpaceForIcon) {
            this.forceAllocateSpaceForIcon = forceAllocateSpaceForIcon;
            return this;
        }

        public Overlay setFont(Font font) {
            this.font = font;
            return this;
        }

        public Overlay setPopupPlacementStrategy(RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy) {
            this.popupPlacementStrategy = popupPlacementStrategy;
            return this;
        }

        public Overlay setShowPopupIcon(boolean showPopupIcon) {
            this.showPopupIcon = showPopupIcon;
            return this;
        }

        public Overlay setPopupIcon(RadianceIcon popupIcon) {
            this.popupIcon = popupIcon;
            return this;
        }

        public Overlay setPopupAnchorBoundsProvider(PopupAnchorBoundsProvider popupAnchorBoundsProvider) {
            this.popupAnchorBoundsProvider = popupAnchorBoundsProvider;
            return this;
        }

        public Overlay setSelectedStateHighlight(SelectedStateHighlight selectedStateHighlight) {
            this.selectedStateHighlight = selectedStateHighlight;
            return this;
        }

        public Overlay setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public Overlay setPopupMenuPresentationModel(BaseCommandPopupMenuPresentationModel popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return this;
        }

        public Overlay setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return this;
        }

        public Overlay setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return this;
        }

        public Overlay setTextClick(TextClick textClick) {
            this.textClick = textClick;
            return this;
        }

        public Overlay setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return this;
        }

        public Overlay setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return this;
        }

        public Overlay setActionFireTrigger(ActionFireTrigger actionFireTrigger) {
            this.actionFireTrigger = actionFireTrigger;
            return this;
        }

        public Overlay setPopupFireTrigger(PopupFireTrigger popupFireTrigger) {
            this.popupFireTrigger = popupFireTrigger;
            return this;
        }

        public Overlay setActionRichTooltipPresentationModel(RichTooltipPresentationModel actionRichTooltipPresentationModel) {
            this.actionRichTooltipPresentationModel = actionRichTooltipPresentationModel;
            return this;
        }

        public Overlay setPopupRichTooltipPresentationModel(RichTooltipPresentationModel popupRichTooltipPresentationModel) {
            this.popupRichTooltipPresentationModel = popupRichTooltipPresentationModel;
            return this;
        }

        public Overlay setSides(RadianceThemingSlices.Sides sides) {
            this.sides = sides;
            return this;
        }

        public CommandButtonPresentationState getPresentationState() {
            return this.presentationState;
        }

        public RadianceThemingSlices.BackgroundAppearanceStrategy getBackgroundAppearanceStrategy() {
            return this.backgroundAppearanceStrategy;
        }

        public Boolean getFocusable() {
            return this.isFocusable;
        }

        public HorizontalAlignment getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public Insets getContentPadding() {
            return this.contentPadding;
        }

        public Double getHorizontalGapScaleFactor() {
            return this.horizontalGapScaleFactor;
        }

        public Double getVerticalGapScaleFactor() {
            return this.verticalGapScaleFactor;
        }

        public Dimension getIconDimension() {
            return this.iconDimension;
        }

        public RadianceThemingSlices.IconFilterStrategy getActiveIconFilterStrategy() {
            return this.activeIconFilterStrategy;
        }

        public RadianceThemingSlices.IconFilterStrategy getEnabledIconFilterStrategy() {
            return this.enabledIconFilterStrategy;
        }

        public RadianceThemingSlices.IconFilterStrategy getDisabledIconFilterStrategy() {
            return this.disabledIconFilterStrategy;
        }

        public Boolean isForceAllocateSpaceForIcon() {
            return this.forceAllocateSpaceForIcon;
        }

        public SelectedStateHighlight getSelectedStateHighlight() {
            return this.selectedStateHighlight;
        }

        public Font getFont() {
            return this.font;
        }

        public RadianceThemingSlices.PopupPlacementStrategy getPopupPlacementStrategy() {
            return this.popupPlacementStrategy;
        }

        public Boolean getToDismissPopupsOnActivation() {
            return this.toDismissPopupsOnActivation;
        }

        public Boolean isShowPopupIcon() {
            return this.showPopupIcon;
        }

        public RadianceIcon getPopupIcon() {
            return this.popupIcon;
        }

        public PopupAnchorBoundsProvider getPopupAnchorBoundsProvider() {
            return this.popupAnchorBoundsProvider;
        }

        public String getActionKeyTip() {
            return this.actionKeyTip;
        }

        public String getPopupKeyTip() {
            return this.popupKeyTip;
        }

        public BaseCommandPopupMenuPresentationModel getPopupMenuPresentationModel() {
            return this.popupMenuPresentationModel;
        }

        public TextClick getTextClick() {
            return this.textClick;
        }

        public Boolean getAutoRepeatAction() {
            return this.isAutoRepeatAction;
        }

        public Boolean getHasAutoRepeatIntervalsSet() {
            return this.hasAutoRepeatIntervalsSet;
        }

        public Integer getAutoRepeatInitialInterval() {
            return this.autoRepeatInitialInterval;
        }

        public Integer getAutoRepeatSubsequentInterval() {
            return this.autoRepeatSubsequentInterval;
        }

        public ActionFireTrigger getActionFireTrigger() {
            return this.actionFireTrigger;
        }

        public PopupFireTrigger getPopupFireTrigger() {
            return this.popupFireTrigger;
        }

        public RichTooltipPresentationModel getActionRichTooltipPresentationModel() {
            return this.actionRichTooltipPresentationModel;
        }

        public RichTooltipPresentationModel getPopupRichTooltipPresentationModel() {
            return this.popupRichTooltipPresentationModel;
        }

        public RadianceThemingSlices.Sides getSides() {
            return this.sides;
        }
    }

    public static interface PopupAnchorBoundsProvider {
        public Rectangle getPopupAnchorBoundsOnScreen();
    }

    public static enum TextClick {
        ACTION,
        POPUP;

    }

    public static enum SelectedStateHighlight {
        ICON_ONLY,
        FULL_SIZE;

    }

    public static enum PopupFireTrigger {
        ON_ROLLOVER,
        ON_PRESSED;

    }

    public static enum ActionFireTrigger {
        ON_ROLLOVER,
        ON_PRESSED,
        ON_PRESS_RELEASED;

    }
}

