/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;
import org.pushingpixels.radiance.component.api.common.CommandActionEvent;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.ActionButtonModel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;

public class ActionRepeatableButtonModel
extends DefaultButtonModel
implements ActionButtonModel {
    private JCommandButton commandButton;
    private Timer autoRepeatTimer;
    private boolean toFireActionOnPress;

    public ActionRepeatableButtonModel(JCommandButton commandButton) {
        this.commandButton = commandButton;
        this.toFireActionOnPress = false;
        this.setEnabled(commandButton.isEnabled());
    }

    @Override
    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    @Override
    public void setSelected(boolean b) {
        BaseCommand<? extends BaseCommandMenuContentModel> command = this.commandButton.getContentModel();
        CommandToggleGroupModel groupModel = command.getToggleGroupModel();
        if (groupModel != null) {
            groupModel.setSelected(command, b);
            b = groupModel.getSelected() == command;
        } else if (command.isToggle()) {
            command.setToggleSelected(b);
        }
        if (this.isSelected() == b) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        BaseCommand<? extends BaseCommandMenuContentModel> command = this.commandButton.getContentModel();
        BaseCommandButtonPresentationModel<BaseCommandPopupMenuPresentationModel, BaseCommandButtonPresentationModel<?, ?>> presentationModel = this.commandButton.getPresentationModel();
        if (command.isToggle() && this.isArmed()) {
            if (!this.isFireActionOnPress()) {
                if (!b) {
                    this.setSelected(!this.isSelected());
                }
            } else if (b) {
                this.setSelected(!this.isSelected());
            }
        }
        boolean toFireFirstAction = this.isArmed();
        if (presentationModel.isAutoRepeatAction() || this.isFireActionOnPress()) {
            toFireFirstAction = this.isPressed() && toFireFirstAction;
        } else {
            boolean bl = toFireFirstAction = !this.isPressed() && toFireFirstAction;
        }
        if (this.commandButton.getContentModel().getAction() == null && this.commandButton.getContentModel().hasSecondaryContent()) {
            toFireFirstAction = false;
        }
        if (presentationModel.getActionFireTrigger() == BaseCommandButtonPresentationModel.ActionFireTrigger.ON_ROLLOVER) {
            toFireFirstAction = false;
        }
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiersEx();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        if (toFireFirstAction) {
            this.commandButton.getUI().setInnerFocusOnAction(true);
            this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, command, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            if (presentationModel.isAutoRepeatAction()) {
                this.startActionTimer(modifiers);
            }
        }
        if (presentationModel.getActionFireTrigger() != BaseCommandButtonPresentationModel.ActionFireTrigger.ON_ROLLOVER && presentationModel.isAutoRepeatAction() && !b) {
            this.stopActionTimer();
        }
        this.fireStateChanged();
    }

    @Override
    public void setRollover(boolean b) {
        if (this.isRollover() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        BaseCommandButtonPresentationModel<BaseCommandPopupMenuPresentationModel, BaseCommandButtonPresentationModel<?, ?>> presentationModel = this.commandButton.getPresentationModel();
        if (presentationModel.getActionFireTrigger() == BaseCommandButtonPresentationModel.ActionFireTrigger.ON_ROLLOVER) {
            if (b && !this.isActionTimerRunning() && this.commandButton.getContentModel().getAction() != null) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.commandButton.getUI().setInnerFocusOnAction(true);
                this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, this.commandButton.getContentModel(), this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                if (presentationModel.isAutoRepeatAction()) {
                    this.startActionTimer(modifiers);
                }
            }
            if (!b) {
                this.stopActionTimer();
            }
        }
        this.fireStateChanged();
    }

    private void stopActionTimer() {
        if (this.autoRepeatTimer != null) {
            this.autoRepeatTimer.stop();
        }
    }

    private boolean isActionTimerRunning() {
        if (this.autoRepeatTimer == null) {
            return false;
        }
        return this.autoRepeatTimer.isRunning();
    }

    private void startActionTimer(int modifiers) {
        BaseCommandButtonPresentationModel<BaseCommandPopupMenuPresentationModel, BaseCommandButtonPresentationModel<?, ?>> presentationModel = this.commandButton.getPresentationModel();
        this.autoRepeatTimer = new Timer(presentationModel.getAutoRepeatSubsequentInterval(), actionEvent -> {
            if (!(this.isEnabled() && this.commandButton.isVisible() && this.commandButton.isDisplayable())) {
                this.autoRepeatTimer.stop();
                return;
            }
            this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, this.commandButton.getContentModel(), this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
        });
        this.autoRepeatTimer.setInitialDelay(presentationModel.getAutoRepeatInitialInterval());
        this.autoRepeatTimer.start();
    }

    @Override
    public boolean isFireActionOnPress() {
        return this.toFireActionOnPress;
    }

    @Override
    public void setFireActionOnPress(boolean toFireActionOnPress) {
        this.toFireActionOnPress = toFireActionOnPress;
    }
}

