/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class CommandButtonFollowColorSchemeIcon
implements RadianceIcon {
    private int width;
    private int height;
    private RadianceThemingSlices.ColorSchemeAssociationKind colorSchemeAssociationKind;
    private Delegate delegate;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();

    public CommandButtonFollowColorSchemeIcon(Delegate delegate, Dimension initialDim) {
        this(RadianceThemingSlices.ColorSchemeAssociationKind.MARK, delegate, initialDim);
    }

    public CommandButtonFollowColorSchemeIcon(RadianceThemingSlices.ColorSchemeAssociationKind colorSchemeAssociationKind, Delegate delegate, Dimension initialDim) {
        this.colorSchemeAssociationKind = colorSchemeAssociationKind;
        this.delegate = delegate;
        this.width = initialDim.width;
        this.height = initialDim.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        float alpha = 1.0f;
        if (!(c instanceof JCommandButton)) {
            BladeUtils.populateColorScheme((BladeColorScheme)this.mutableColorScheme, null, null, (ComponentState)(c == null || !c.isEnabled() ? ComponentState.DISABLED_UNSELECTED : ComponentState.ENABLED), (RadianceThemingSlices.ColorSchemeAssociationKind)this.colorSchemeAssociationKind, (boolean)false);
            if (c == null || !c.isEnabled()) {
                alpha = RadianceColorSchemeUtilities.getAlpha((Component)c, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            }
        } else {
            JCommandButton commandButton = (JCommandButton)c;
            StateTransitionTracker stateTransitionTracker = ((ActionPopupTransitionAwareUI)((Object)commandButton.getUI())).getActionTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            ComponentState currState = modelStateInfo.getCurrModelState();
            BladeUtils.populateColorScheme((BladeColorScheme)this.mutableColorScheme, (Component)commandButton, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)this.colorSchemeAssociationKind, (boolean)false);
            alpha = RadianceColorSchemeUtilities.getAlpha((Component)c, (ComponentState)currState);
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        if (alpha < 1.0f) {
            graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, (float)alpha, (Graphics)g));
        }
        this.delegate.drawColorSchemeIcon(graphics, (RadianceColorScheme)this.mutableColorScheme, this.width, this.height);
        graphics.dispose();
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    @FunctionalInterface
    public static interface Delegate {
        public void drawColorSchemeIcon(Graphics2D var1, RadianceColorScheme var2, int var3, int var4);
    }
}

