/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;

public interface CommandButtonLayoutManager
extends PropertyChangeListener {
    default public CommandButtonKind getCommandButtonKind(JCommandButton commandButton) {
        boolean hasAction = commandButton.getContentModel().getAction() != null;
        boolean hasSecondary = commandButton.getContentModel().hasSecondaryContent();
        if (!hasAction && !hasSecondary) {
            return CommandButtonKind.ACTION_ONLY;
        }
        if (!hasSecondary) {
            return CommandButtonKind.ACTION_ONLY;
        }
        if (!hasAction) {
            return CommandButtonKind.POPUP_ONLY;
        }
        return commandButton.getPresentationModel().getTextClick() == BaseCommandButtonPresentationModel.TextClick.ACTION ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP;
    }

    default public CommandButtonKind getCommandButtonKind(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        boolean hasAction = command.getAction() != null;
        boolean hasSecondary = command.hasSecondaryContent();
        if (!hasAction && !hasSecondary) {
            return CommandButtonKind.ACTION_ONLY;
        }
        if (!hasSecondary) {
            return CommandButtonKind.ACTION_ONLY;
        }
        if (!hasAction) {
            return CommandButtonKind.POPUP_ONLY;
        }
        return presentationModel.getTextClick() == BaseCommandButtonPresentationModel.TextClick.ACTION ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP;
    }

    public Dimension getPreferredIconSize(BaseCommand var1, BaseCommandButtonPresentationModel var2);

    public Dimension getPreferredSize(BaseCommand var1, BaseCommandButtonPresentationModel var2);

    public Point getActionKeyTipAnchorCenterPoint(JCommandButton var1);

    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton var1);

    public CommandButtonLayoutInfo getLayoutInfo(JCommandButton var1);

    @Override
    default public void propertyChange(PropertyChangeEvent evt) {
    }

    public static class CommandButtonLayoutInfo {
        public Rectangle actionClickArea;
        public Rectangle popupClickArea;
        public Rectangle separatorArea;
        public CommandButtonSeparatorOrientation separatorOrientation;
        public Rectangle iconRect;
        public List<TextLayoutInfo> textLayoutInfoList;
        public List<TextLayoutInfo> extraTextLayoutInfoList;
        public Rectangle popupActionRect;
        public boolean isTextInActionArea;
    }

    public static class TextLayoutInfo {
        public String text;
        public Rectangle textRect;
    }

    public static enum CommandButtonKind {
        ACTION_ONLY(true, false),
        POPUP_ONLY(false, true),
        ACTION_AND_POPUP_MAIN_ACTION(true, true),
        ACTION_AND_POPUP_MAIN_POPUP(true, true);

        private final boolean hasAction;
        private final boolean hasPopup;

        private CommandButtonKind(boolean hasAction, boolean hasPopup) {
            this.hasAction = hasAction;
            this.hasPopup = hasPopup;
        }

        public boolean hasAction() {
            return this.hasAction;
        }

        public boolean hasPopup() {
            return this.hasPopup;
        }
    }

    public static enum CommandButtonSeparatorOrientation {
        VERTICAL,
        HORIZONTAL;

    }
}

