/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.bcb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbItem;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbPathListener;

public class BreadcrumbBarContentModel<T> {
    private LinkedList<BreadcrumbItem<T>> items = new LinkedList();
    private List<BreadcrumbPathListener<T>> listenerList = new ArrayList<BreadcrumbPathListener<T>>();
    private boolean isCumulative = false;
    private int smallestCumulativeIndex = -1;

    public int indexOf(BreadcrumbItem<T> item) {
        return this.items.indexOf(item);
    }

    public void removeLast() {
        this.items.removeLast();
        this.firePathChanged(this.items.size());
    }

    public void reset() {
        this.items.clear();
        this.firePathChanged(0);
    }

    public List<BreadcrumbItem<T>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public BreadcrumbItem<T> getItem(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getItemCount()) {
            return null;
        }
        return this.items.get(index);
    }

    public void replace(List<BreadcrumbItem<T>> items) {
        this.items.clear();
        for (BreadcrumbItem<T> item : items) {
            this.items.addLast(item);
        }
        this.firePathChanged(0);
    }

    public void addLast(BreadcrumbItem<T> item) {
        this.items.addLast(item);
        this.firePathChanged(this.items.size() - 1);
    }

    public void setCumulative(boolean isCumulative) {
        boolean toFire = this.isCumulative && !isCumulative;
        this.isCumulative = isCumulative;
        if (toFire) {
            this.firePathChanged(Math.max(0, this.smallestCumulativeIndex));
            this.smallestCumulativeIndex = -1;
        }
    }

    public void addPathListener(BreadcrumbPathListener<T> l) {
        this.listenerList.add(l);
    }

    public void removePathListener(BreadcrumbPathListener<T> l) {
        this.listenerList.remove(l);
    }

    private void firePathChanged(int indexOfFirstChange) {
        if (this.isCumulative) {
            this.smallestCumulativeIndex = this.smallestCumulativeIndex == -1 ? indexOfFirstChange : Math.min(this.smallestCumulativeIndex, indexOfFirstChange);
            return;
        }
        BreadcrumbPathEvent event = new BreadcrumbPathEvent(this, indexOfFirstChange);
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).breadcrumbPathEvent(event);
        }
    }
}

