/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.radiance.component.api.common.model.PropertyChangeAware;

public class WeakPropertyChangeSupport {
    private final List<WeakPropertyChangeListener> listenerList = new ArrayList<WeakPropertyChangeListener>();
    private final PropertyChangeAware source;

    public WeakPropertyChangeSupport(PropertyChangeAware source) {
        this.source = source;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof WeakPropertyChangeListener) {
            throw new IllegalArgumentException("Don't pass an explicitly wrapped listener");
        }
        this.listenerList.add(new WeakPropertyChangeListener(this.source, l));
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof WeakPropertyChangeListener) {
            this.listenerList.remove(l);
            return;
        }
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            WeakPropertyChangeListener current = this.listenerList.get(i);
            PropertyChangeListener original = current.getOriginalPropertyChangeListener();
            if (original != null && original != l) continue;
            this.listenerList.remove(i);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).propertyChange(event);
        }
    }

    private static class WeakPropertyChangeListener
    implements PropertyChangeListener {
        private WeakReference<PropertyChangeAware> sourceRef;
        private WeakReference<PropertyChangeListener> listenerRef;

        public WeakPropertyChangeListener(PropertyChangeAware source, PropertyChangeListener listener) {
            if (source == null) {
                throw new IllegalArgumentException("Cannot wrap a null source");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Cannot wrap a null listener");
            }
            this.sourceRef = new WeakReference<PropertyChangeAware>(source);
            this.listenerRef = new WeakReference<PropertyChangeListener>(listener);
        }

        public PropertyChangeListener getOriginalPropertyChangeListener() {
            if (this.listenerRef == null) {
                return null;
            }
            return (PropertyChangeListener)this.listenerRef.get();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener originalListener = (PropertyChangeListener)this.listenerRef.get();
            if (originalListener != null) {
                originalListener.propertyChange(evt);
            } else {
                PropertyChangeAware source = (PropertyChangeAware)this.sourceRef.get();
                if (source != null) {
                    source.removePropertyChangeListener(this);
                }
                this.listenerRef = null;
                this.sourceRef = null;
            }
        }
    }
}

