/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.utils;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonFrame;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTask;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonFrameTitlePane;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonRootPaneUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;

public class KeyTipManager {
    private List<KeyTipChain> keyTipChains = new ArrayList<KeyTipChain>();
    private List<KeyTipListener> listenerList = new ArrayList<KeyTipListener>();
    private BlockingQueue<Character> processingQueue = new LinkedBlockingQueue<Character>();
    private JRibbonFrame rootOwner;
    private Component focusOwner;
    private static final KeyTipManager instance = new KeyTipManager();

    public static KeyTipManager defaultManager() {
        return instance;
    }

    private KeyTipManager() {
        ProcessingThread processingThread = new ProcessingThread();
        processingThread.start();
    }

    public boolean isShowingKeyTips() {
        return !this.keyTipChains.isEmpty();
    }

    public void hideAllKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.clear();
        this.fireKeyTipsHidden(this.rootOwner);
        this.repaintWindows();
        this.tryRestoringFocusOwner();
    }

    private void tryRestoringFocusOwner() {
        if (this.focusOwner != null && this.focusOwner.isDisplayable() && this.focusOwner.isShowing()) {
            this.focusOwner.requestFocus();
        }
    }

    public void showRootKeyTipChain(JRibbonFrame ribbonFrame) {
        RibbonUI ui;
        RadianceRibbonFrameTitlePane titlePane;
        if (!this.keyTipChains.isEmpty()) {
            throw new IllegalStateException("Can't call this method when key tip chains are present");
        }
        this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        ribbonFrame.requestFocus();
        this.rootOwner = ribbonFrame;
        JRibbon ribbon = ribbonFrame.getRibbon();
        KeyTipChain root = new KeyTipChain(ribbon);
        JCommandButton appMenuButton = ribbon.getUI().getApplicationMenuButton();
        if (appMenuButton != null && ((CommandButtonPresentationModel)ribbon.getApplicationMenuCommandProjection().getPresentationModel()).getPopupKeyTip() != null) {
            KeyTipLink appMenuButtonLink = new KeyTipLink();
            appMenuButtonLink.comp = appMenuButton;
            appMenuButtonLink.keyTipString = ((CommandButtonPresentationModel)ribbon.getApplicationMenuCommandProjection().getPresentationModel()).getPopupKeyTip();
            appMenuButtonLink.prefAnchorPoint = appMenuButton.getUI().getPopupKeyTipAnchorCenterPoint();
            appMenuButtonLink.onActivated = actionEvent -> appMenuButton.doPopupClick();
            appMenuButtonLink.enabled = true;
            appMenuButtonLink.traversal = () -> {
                PopupPanelManager.PopupInfo last;
                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                if (!popups.isEmpty() && (last = popups.get(popups.size() - 1)).getPopupOriginator() == appMenuButton) {
                    JPopupPanel popupPanel = last.getPopupPanel();
                    KeyTipChain chain = new KeyTipChain(popupPanel);
                    chain.parent = appMenuButtonLink.traversal;
                    this.populateChain(last.getPopupPanel(), chain);
                    return chain;
                }
                return null;
            };
            root.addLink(appMenuButtonLink);
        }
        if ((titlePane = (RadianceRibbonFrameTitlePane)((Object)((RadianceRibbonRootPaneUI)((Object)ribbonFrame.getRootPane().getUI())).getTitlePane())) != null) {
            for (Component taskbarComp : titlePane.getTaskbarPanel().getComponents()) {
                JRibbonComponent rc;
                KeyTipLink link;
                if (taskbarComp instanceof JCommandButton) {
                    KeyTipLink popupLink;
                    JCommandButton cb = (JCommandButton)taskbarComp;
                    KeyTipLink actionLink = this.getCommandButtonActionLink(cb);
                    if (actionLink != null) {
                        if ("radiance.internal.ribbon.taskbarOverflowButton".equals(cb.getContentModel().getTag())) {
                            actionLink.traversal = () -> {
                                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                                if (!popups.isEmpty()) {
                                    PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                                    JPopupPanel popupPanel = last.getPopupPanel();
                                    KeyTipChain chain = new KeyTipChain(popupPanel);
                                    this.populateChain(last.getPopupPanel(), chain);
                                    chain.parent = actionLink.traversal;
                                    return chain;
                                }
                                return null;
                            };
                        }
                        root.addLink(actionLink);
                    }
                    if ((popupLink = this.getCommandButtonPopupLink(cb)) == null) continue;
                    root.addLink(popupLink);
                    continue;
                }
                if (!(taskbarComp instanceof JRibbonComponent) || (link = this.getRibbonComponentLink(rc = (JRibbonComponent)taskbarComp)) == null) continue;
                root.addLink(link);
            }
        }
        if ((ui = ribbon.getUI()) instanceof BasicRibbonUI) {
            BasicRibbonUI brui = (BasicRibbonUI)ui;
            for (Map.Entry<RibbonTask, JCommandButton> ttbEntry : brui.getTaskToggleButtons().entrySet()) {
                RibbonTask task = ttbEntry.getKey();
                JCommandButton taskToggleButton = ttbEntry.getValue();
                String keyTip = task.getKeyTip();
                if (keyTip == null) continue;
                KeyTipLink taskToggleButtonLink = new KeyTipLink();
                taskToggleButtonLink.comp = taskToggleButton;
                taskToggleButtonLink.keyTipString = keyTip;
                taskToggleButtonLink.prefAnchorPoint = new Point(taskToggleButton.getWidth() / 2, taskToggleButton.getHeight());
                taskToggleButtonLink.onActivated = actionEvent -> taskToggleButton.doActionClick();
                taskToggleButtonLink.enabled = true;
                taskToggleButtonLink.traversal = () -> {
                    KeyTipChain taskChain = new KeyTipChain(taskToggleButton);
                    for (AbstractRibbonBand band : task.getBands()) {
                        this.populateChain(band, taskChain);
                    }
                    taskChain.parent = taskToggleButtonLink.traversal;
                    return taskChain;
                };
                root.addLink(taskToggleButtonLink);
            }
            for (JCommandButton anchored : brui.getAnchoredCommandButtons()) {
                KeyTipLink popupLink;
                KeyTipLink actionLink = this.getCommandButtonActionLink(anchored);
                if (actionLink != null) {
                    root.addLink(actionLink);
                }
                if ((popupLink = this.getCommandButtonPopupLink(anchored)) == null) continue;
                root.addLink(popupLink);
            }
        }
        this.keyTipChains.add(root);
        this.fireKeyTipsShown(ribbonFrame);
        ribbonFrame.repaint();
    }

    public Collection<KeyTipLink> getCurrentlyShownKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.keyTipChains.get(this.keyTipChains.size() - 1).links);
    }

    public KeyTipChain getCurrentlyShownKeyTipChain() {
        if (this.keyTipChains.isEmpty()) {
            return null;
        }
        return this.keyTipChains.get(this.keyTipChains.size() - 1);
    }

    public void showPreviousChain() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        if (!this.isShowingKeyTips()) {
            this.tryRestoringFocusOwner();
        }
        this.repaintWindows();
    }

    private void addCommandButtonLinks(JCommandButton commandButton, KeyTipChain chain) {
        KeyTipLink popupLink;
        KeyTipLink actionLink = this.getCommandButtonActionLink(commandButton);
        if (actionLink != null) {
            chain.addLink(actionLink);
        }
        if ((popupLink = this.getCommandButtonPopupLink(commandButton)) != null) {
            chain.addLink(popupLink);
        }
    }

    private void populateChain(Component c, KeyTipChain chain) {
        JRibbonComponent rc;
        KeyTipLink link;
        if (c instanceof JCommandButton) {
            Rectangle compBounds = c.getBounds();
            if (c.isVisible() && c.isShowing()) {
                if (compBounds.height > 0 && compBounds.width > 0) {
                    this.addCommandButtonLinks((JCommandButton)c, chain);
                } else {
                    SwingUtilities.invokeLater(() -> {
                        Rectangle compBoundsNew = c.getBounds();
                        if (compBoundsNew.height > 0 && compBoundsNew.width > 0) {
                            this.addCommandButtonLinks((JCommandButton)c, chain);
                        }
                    });
                }
            }
        }
        if (c instanceof JRibbonComponent && (link = this.getRibbonComponentLink(rc = (JRibbonComponent)c)) != null) {
            chain.addLink(link);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.populateChain(cont.getComponent(i), chain);
            }
        }
    }

    private KeyTipLink getCommandButtonActionLink(JCommandButton cb) {
        if (cb.getContentModel().getAction() != null && cb.getPresentationModel().getActionKeyTip() != null) {
            KeyTipLink link = new KeyTipLink();
            link.comp = cb;
            link.keyTipString = cb.getPresentationModel().getActionKeyTip();
            link.prefAnchorPoint = cb.getUI().getActionKeyTipAnchorCenterPoint();
            link.onActivated = actionEvent -> cb.doActionClick();
            link.enabled = cb.getActionModel().isEnabled();
            if ("radiance.internal.ribbon.galleryExpandButton".equals(cb.getContentModel().getTag())) {
                link.traversal = () -> {
                    List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                    if (!popups.isEmpty()) {
                        PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                        JPopupPanel popupPanel = last.getPopupPanel();
                        KeyTipChain chain = new KeyTipChain(popupPanel);
                        this.populateChain(last.getPopupPanel(), chain);
                        chain.parent = link.traversal;
                        return chain;
                    }
                    return null;
                };
            } else {
                link.traversal = null;
            }
            return link;
        }
        return null;
    }

    private KeyTipLink getRibbonComponentLink(JRibbonComponent rc) {
        if (rc.getKeyTip() != null) {
            KeyTipLink link = new KeyTipLink();
            link.comp = rc;
            link.keyTipString = rc.getKeyTip();
            link.prefAnchorPoint = rc.getUI().getKeyTipAnchorCenterPoint();
            link.onActivated = actionEvent -> {
                JComponent mainComponent = rc.getMainComponent();
                int mainComponentWidth = mainComponent.getWidth();
                int mainComponentHeight = mainComponent.getHeight();
                Point mainComponentCenter = new Point(mainComponentWidth / 2, mainComponentHeight / 2);
                SwingUtilities.convertPointToScreen(mainComponentCenter, mainComponent);
                Component toClick = SwingUtilities.getDeepestComponentAt(mainComponent, mainComponentWidth / 2, mainComponentHeight / 2);
                long currentTimeMillis = System.currentTimeMillis();
                MouseEvent pressEvent = new MouseEvent(toClick, 501, currentTimeMillis, 0, mainComponentWidth / 2, mainComponentHeight / 2, mainComponentCenter.x, mainComponentCenter.y, 1, false, 1);
                MouseEvent releaseEvent = new MouseEvent(toClick, 502, currentTimeMillis, 0, mainComponentWidth / 2, mainComponentHeight / 2, mainComponentCenter.x, mainComponentCenter.y, 1, false, 1);
                toClick.dispatchEvent(pressEvent);
                toClick.dispatchEvent(releaseEvent);
            };
            link.enabled = rc.getMainComponent().isEnabled();
            link.traversal = null;
            return link;
        }
        return null;
    }

    private KeyTipLink getCommandButtonPopupLink(JCommandButton cb) {
        if (cb.getContentModel().hasSecondaryContent() && cb.getPresentationModel().getPopupKeyTip() != null) {
            KeyTipLink link = new KeyTipLink();
            link.comp = cb;
            link.keyTipString = cb.getPresentationModel().getPopupKeyTip();
            link.prefAnchorPoint = cb.getUI().getPopupKeyTipAnchorCenterPoint();
            link.onActivated = actionEvent -> {
                cb.doActionRollover();
                cb.doPopupClick();
            };
            link.enabled = cb.getPopupModel().isEnabled();
            link.traversal = () -> {
                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                if (!popups.isEmpty()) {
                    PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                    JPopupPanel popupPanel = last.getPopupPanel();
                    if (popupPanel instanceof JRibbonApplicationMenuPopupPanel) {
                        JRibbonApplicationMenuPopupPanel appMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)popupPanel;
                        JPanel footerPanel = appMenuPopupPanel.getFooterPanel();
                        JPanel level1 = appMenuPopupPanel.getPanelLevel1();
                        JPanel level2 = appMenuPopupPanel.getPanelLevel2();
                        if (level2.getComponentCount() > 0) {
                            KeyTipChain chain = new KeyTipChain(level2);
                            this.populateChain(footerPanel, chain);
                            this.populateChain(level2, chain);
                            chain.parent = link.traversal;
                            return chain;
                        }
                        KeyTipChain chain = new KeyTipChain(level1);
                        this.populateChain(footerPanel, chain);
                        this.populateChain(level1, chain);
                        chain.parent = link.traversal;
                        return chain;
                    }
                    KeyTipChain chain = new KeyTipChain(popupPanel);
                    this.populateChain(last.getPopupPanel(), chain);
                    chain.parent = link.traversal;
                    return chain;
                }
                return null;
            };
            return link;
        }
        return null;
    }

    public void handleKeyPress(char keyChar) {
        this.processingQueue.add(Character.valueOf(keyChar));
    }

    private void processNextKeyPress(char keyChar) {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        KeyTipChain currChain = this.keyTipChains.get(this.keyTipChains.size() - 1);
        for (KeyTipLink link : currChain.links) {
            String keyTipString = link.keyTipString;
            if (Character.toLowerCase(keyTipString.charAt(currChain.keyTipLookupIndex)) != Character.toLowerCase(keyChar) || keyTipString.length() != currChain.keyTipLookupIndex + 1) continue;
            if (link.enabled) {
                link.onActivated.actionPerformed(new ActionEvent(link.comp, 1001, "keyTipActivated"));
                if (link.traversal != null) {
                    SwingUtilities.invokeLater(() -> {
                        KeyTipChain next = link.traversal.getNextChain();
                        if (next != null) {
                            KeyTipChain prev = this.keyTipChains.isEmpty() ? null : this.keyTipChains.get(this.keyTipChains.size() - 1);
                            this.keyTipChains.add(next);
                            this.repaintWindows();
                            if (prev != null) {
                                for (KeyTipLink link2 : prev.links) {
                                    if (!(link2.comp instanceof JCommandButton)) continue;
                                    link2.comp.repaint();
                                }
                            }
                        }
                    });
                } else {
                    this.hideAllKeyTips();
                    PopupPanelManager.defaultManager().hidePopups(null);
                }
            }
            return;
        }
        if (currChain.keyTipLookupIndex == 0) {
            KeyTipChain secondary = new KeyTipChain(currChain.chainParentComponent);
            secondary.keyTipLookupIndex = 1;
            for (KeyTipLink link : currChain.links) {
                String keyTipString = link.keyTipString;
                if (Character.toLowerCase(keyTipString.charAt(currChain.keyTipLookupIndex)) != Character.toLowerCase(keyChar) || keyTipString.length() != 2) continue;
                KeyTipLink secondaryLink = new KeyTipLink();
                secondaryLink.comp = link.comp;
                secondaryLink.enabled = link.enabled;
                secondaryLink.keyTipString = link.keyTipString;
                secondaryLink.onActivated = link.onActivated;
                secondaryLink.prefAnchorPoint = link.prefAnchorPoint;
                secondaryLink.traversal = link.traversal;
                secondary.addLink(secondaryLink);
            }
            if (!secondary.links.isEmpty()) {
                this.keyTipChains.add(secondary);
            }
            this.repaintWindows();
        }
    }

    private void repaintWindows() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        for (PopupPanelManager.PopupInfo popup : popups) {
            JPopupPanel popupPanel = popup.getPopupPanel();
            popupPanel.paintImmediately(new Rectangle(0, 0, popupPanel.getWidth(), popupPanel.getHeight()));
        }
    }

    public void addKeyTipListener(KeyTipListener keyTipListener) {
        if (this.listenerList.contains(keyTipListener)) {
            return;
        }
        this.listenerList.add(keyTipListener);
    }

    public void removeKeyTipListener(KeyTipListener keyTipListener) {
        this.listenerList.remove(keyTipListener);
    }

    private void fireKeyTipsShown(JRibbonFrame ribbonFrame) {
        KeyTipEvent e = new KeyTipEvent(ribbonFrame, 0);
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).keyTipsShown(e);
        }
    }

    private void fireKeyTipsHidden(JRibbonFrame ribbonFrame) {
        KeyTipEvent e = new KeyTipEvent(ribbonFrame, 0);
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).keyTipsHidden(e);
        }
    }

    public void refreshCurrentChain() {
        KeyTipChain curr = this.keyTipChains.get(this.keyTipChains.size() - 1);
        if (curr.parent == null) {
            return;
        }
        KeyTipChain refreshed = curr.parent.getNextChain();
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        this.keyTipChains.add(refreshed);
        this.repaintWindows();
    }

    private class ProcessingThread
    extends Thread {
        private ProcessingThread() {
            this.setName("KeyTipManager processing thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        char keyChar = ((Character)KeyTipManager.this.processingQueue.take()).charValue();
                        SwingUtilities.invokeAndWait(() -> KeyTipManager.this.processNextKeyPress(keyChar));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class KeyTipChain {
        private List<KeyTipLink> links;
        private int keyTipLookupIndex;
        public JComponent chainParentComponent;
        private KeyTipLinkTraversal parent;

        public KeyTipChain(JComponent chainParentComponent) {
            this.chainParentComponent = chainParentComponent;
            this.links = new ArrayList<KeyTipLink>();
            this.keyTipLookupIndex = 0;
        }

        public void addLink(KeyTipLink link) {
            this.links.add(link);
        }
    }

    public static class KeyTipLink {
        public String keyTipString;
        public JComponent comp;
        public Point prefAnchorPoint;
        private ActionListener onActivated;
        private KeyTipLinkTraversal traversal;
        public boolean enabled;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface HasNextKeyTipChain {
    }

    public static class KeyTipEvent
    extends AWTEvent {
        public KeyTipEvent(Object source, int id) {
            super(source, id);
        }
    }

    public static interface KeyTipListener
    extends EventListener {
        public void keyTipsShown(KeyTipEvent var1);

        public void keyTipsHidden(KeyTipEvent var1);
    }

    @FunctionalInterface
    public static interface KeyTipLinkTraversal {
        public KeyTipChain getNextChain();
    }
}

