/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerMenuTileLevel2
implements CommandButtonLayoutManager {
    @Override
    public Dimension getPreferredIconSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int size = ComponentUtilities.getScaledSize(32, presentationFont.getSize(), 2.0, 4);
        return new Dimension(size, size);
    }

    @Override
    public Dimension getPreferredSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Insets borderInsets = presentationModel.getContentPadding();
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor(null), (Font)presentationFont);
        JSeparator jsep = new JSeparator(1);
        int titleWidth = fm.stringWidth(command.getText());
        int layoutHGap = 2 * ComponentUtilities.getHLayoutGap(presentationModel);
        int layoutVGap = 2 * ComponentUtilities.getVLayoutGap(presentationModel);
        int widthMed = this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).width + 2 * layoutHGap + jsep.getPreferredSize().width + titleWidth + (command.hasSecondaryContent() ? presentationModel.getPopupIcon().getIconWidth() + 4 * layoutHGap + jsep.getPreferredSize().width : 0);
        int fontHeight = fm.getAscent() + fm.getDescent();
        int textHeight = fontHeight + layoutVGap;
        String extraText = command.getExtraText();
        if (extraText != null && extraText.length() > 0) {
            textHeight += 2 * fontHeight;
        }
        return new Dimension(bx + widthMed, by + Math.max(this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).height, textHeight));
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.iconRect.x + layoutInfo.iconRect.width, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
        }
        return new Point(layoutInfo.iconRect.x, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.popupActionRect.x, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
        }
        return new Point(layoutInfo.popupActionRect.x + layoutInfo.popupActionRect.width, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        BaseCommandButtonPresentationModel<BaseCommandPopupMenuPresentationModel, BaseCommandButtonPresentationModel<?, ?>> presentationModel = commandButton.getPresentationModel();
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        CommandButtonLayoutManager.CommandButtonKind buttonKind = this.getCommandButtonKind(commandButton);
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
            result.isTextInActionArea = false;
        }
        JSeparator jsep = new JSeparator(1);
        int layoutHGap = 2 * ComponentUtilities.getHLayoutGap(commandButton);
        int layoutVGap = 2 * ComponentUtilities.getVLayoutGap(commandButton);
        String buttonText = commandButton.getContentModel().getText();
        Dimension iconSize = this.getPreferredIconSize(commandButton.getContentModel(), commandButton.getPresentationModel());
        int iconWidth = iconSize.width;
        int iconHeight = iconSize.height;
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        if (ltr) {
            int x;
            result.iconRect.x = x = ins.left;
            result.iconRect.y = ins.top + layoutVGap;
            result.iconRect.width = iconWidth;
            result.iconRect.height = iconHeight;
            x += iconWidth;
            if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = x + layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = x + layoutHGap;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = width - x - layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = buttonText;
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.x = x += 2 * layoutHGap + jsep.getPreferredSize().width;
            lineLayoutInfo.textRect.y = ins.top + layoutVGap / 2;
            lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            String extraText = commandButton.getContentModel().getExtraText();
            if (extraText == null || extraText.length() == 0) {
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            } else {
                AttributedString attributedDescription = new AttributedString(extraText);
                attributedDescription.addAttribute(TextAttribute.FONT, commandButton.getFont());
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), RadianceMetricsUtilities.getFontRenderContext((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont()));
                int maxFirstExtraLineWidth = width - x - ins.right - layoutHGap - labelHeight;
                int breakIndex = lineBreakMeasurer.nextOffset(maxFirstExtraLineWidth);
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo1 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo1.text = extraText.substring(0, breakIndex);
                extraLineLayoutInfo1.textRect = new Rectangle();
                extraLineLayoutInfo1.textRect.x = x;
                extraLineLayoutInfo1.textRect.y = ins.top + layoutVGap + labelHeight;
                extraLineLayoutInfo1.textRect.width = fm.stringWidth(extraLineLayoutInfo1.text);
                extraLineLayoutInfo1.textRect.height = labelHeight;
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo2 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo2.text = extraText.substring(breakIndex);
                extraLineLayoutInfo2.textRect = new Rectangle();
                extraLineLayoutInfo2.textRect.x = x;
                extraLineLayoutInfo2.textRect.y = ins.top + layoutVGap + 2 * labelHeight;
                extraLineLayoutInfo2.textRect.width = fm.stringWidth(extraLineLayoutInfo2.text);
                extraLineLayoutInfo2.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo1);
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo2);
            }
            x += fm.stringWidth(buttonText);
            if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = width - ins.right - labelHeight;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = labelHeight + ins.right;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = width - ins.right - labelHeight;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (commandButton.getContentModel().hasSecondaryContent()) {
                int popupIconWidth = presentationModel.getPopupIcon().getIconWidth();
                int popupIconHeight = presentationModel.getPopupIcon().getIconHeight();
                result.popupActionRect.x = width - ins.right - popupIconWidth;
                result.popupActionRect.y = (height - popupIconHeight) / 2;
                result.popupActionRect.width = popupIconWidth;
                result.popupActionRect.height = popupIconHeight;
            }
        } else {
            int x = commandButton.getWidth() - ins.right;
            result.iconRect.x = x - iconWidth;
            result.iconRect.y = ins.top + layoutVGap;
            result.iconRect.width = iconWidth;
            result.iconRect.height = iconHeight;
            x -= iconWidth;
            if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = x + layoutHGap;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - x - layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = x + layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = buttonText;
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
            lineLayoutInfo.textRect.x = (x -= 2 * layoutHGap + jsep.getPreferredSize().width) - lineLayoutInfo.textRect.width;
            lineLayoutInfo.textRect.y = ins.top + layoutVGap / 2;
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            String extraText = commandButton.getContentModel().getExtraText();
            if (extraText == null || extraText.length() == 0) {
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            } else {
                AttributedString attributedDescription = new AttributedString(extraText);
                attributedDescription.addAttribute(TextAttribute.FONT, commandButton.getFont());
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), RadianceMetricsUtilities.getFontRenderContext((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont()));
                int maxFirstExtraLineWidth = x - ins.left - layoutHGap - labelHeight;
                int breakIndex = lineBreakMeasurer.nextOffset(maxFirstExtraLineWidth);
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo1 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo1.text = extraText.substring(0, breakIndex);
                extraLineLayoutInfo1.textRect = new Rectangle();
                extraLineLayoutInfo1.textRect.width = fm.stringWidth(extraLineLayoutInfo1.text);
                extraLineLayoutInfo1.textRect.x = x - extraLineLayoutInfo1.textRect.width;
                extraLineLayoutInfo1.textRect.y = ins.top + layoutVGap + labelHeight;
                extraLineLayoutInfo1.textRect.height = labelHeight;
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo2 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo2.text = extraText.substring(breakIndex);
                extraLineLayoutInfo2.textRect = new Rectangle();
                extraLineLayoutInfo2.textRect.width = fm.stringWidth(extraLineLayoutInfo2.text);
                extraLineLayoutInfo2.textRect.x = x - extraLineLayoutInfo2.textRect.width;
                extraLineLayoutInfo2.textRect.y = ins.top + layoutVGap + 2 * labelHeight;
                extraLineLayoutInfo2.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo1);
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo2);
            }
            if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = labelHeight + ins.left;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = ins.left + labelHeight;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = labelHeight + ins.left;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (commandButton.getContentModel().hasSecondaryContent()) {
                int popupIconWidth = presentationModel.getPopupIcon().getIconWidth();
                int popupIconHeight = presentationModel.getPopupIcon().getIconHeight();
                result.popupActionRect.x = ins.left;
                result.popupActionRect.y = (height - popupIconHeight) / 2;
                result.popupActionRect.width = popupIconWidth;
                result.popupActionRect.height = popupIconHeight;
            }
        }
        return result;
    }
}

