/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPopupMenuPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandPopupMenuPanelProjection;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonGalleryPresentationModel;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonGalleryUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonGalleryUI;

public class JRibbonGallery
extends JComponent {
    private RibbonGalleryProjection galleryProjection;
    private RibbonGalleryContentModel galleryContentModel;
    private RibbonGalleryPresentationModel galleryPresentationModel;
    private Map<Command, BaseCommandButtonPresentationModel.Overlay> galleryCommandOverlays;
    private ChangeListener galleryContentChangeListener;
    protected List<JCommandButton> buttons;
    protected List<BaseCommand> commands;
    private CommandToggleGroupModel commandToggleGroupModel;
    private JRibbonBand.PresentationPriority presentationPriority;
    public static final String uiClassID = "RibbonGalleryUI";

    public JRibbonGallery(RibbonGalleryProjection galleryProjection) {
        this.galleryProjection = galleryProjection;
        this.galleryContentModel = (RibbonGalleryContentModel)galleryProjection.getContentModel();
        this.galleryPresentationModel = (RibbonGalleryPresentationModel)galleryProjection.getPresentationModel();
        this.galleryCommandOverlays = galleryProjection.getCommandOverlays() == null ? Collections.emptyMap() : galleryProjection.getCommandOverlays();
        this.buttons = new ArrayList<JCommandButton>();
        this.commands = new ArrayList<BaseCommand>();
        this.commandToggleGroupModel = new CommandToggleGroupModel();
        this.validateCommandPresentationState(this.galleryPresentationModel.getCommandPresentationState());
        this.populateContent();
        this.galleryContentModel.addCommandActivationListener(activated -> this.commandToggleGroupModel.setSelected(activated, true));
        this.galleryContentChangeListener = changeEvent -> {
            this.buttons.clear();
            this.commandToggleGroupModel.removeAll();
            this.commands.clear();
            this.removeAll();
            this.populateContent();
            this.updateUI();
        };
        this.galleryContentModel.addChangeListener(this.galleryContentChangeListener);
        this.updateUI();
    }

    private void populateContent() {
        this.setGroupMapping(this.galleryContentModel.getCommandGroups());
    }

    public void setUI(RibbonGalleryUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceRibbonGalleryUI.createUI(this));
    }

    @Override
    public RibbonGalleryUI getUI() {
        return (RibbonGalleryUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void addGalleryCommand(final Command command) {
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.withDefaults();
        BaseCommandButtonPresentationModel.Overlay overlay = this.galleryCommandOverlays.get(command);
        if (overlay != null) {
            presentation = presentation.overlayWith(overlay);
        }
        presentation = presentation.overlayWith(new BaseCommandButtonPresentationModel.Overlay().setPresentationState(this.galleryPresentationModel.getCommandPresentationState()));
        final JCommandButton button = (JCommandButton)command.project(presentation).buildComponent();
        button.getActionModel().addChangeListener(new ChangeListener(){
            boolean wasRollover = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isRollover = button.getActionModel().isRollover();
                if (this.wasRollover && !isRollover && JRibbonGallery.this.galleryContentModel != null) {
                    JRibbonGallery.this.galleryContentModel.cancelPreview(command);
                }
                if (!this.wasRollover && isRollover && JRibbonGallery.this.galleryContentModel != null) {
                    JRibbonGallery.this.galleryContentModel.activatePreview(command);
                }
                this.wasRollover = isRollover;
            }
        });
        button.getActionModel().addActionListener(actionEvent -> this.galleryContentModel.setSelectedCommand(command));
        this.buttons.add(button);
        this.commandToggleGroupModel.add(command);
        this.commands.add(command);
        super.add(button);
    }

    public int getPreferredWidth(JRibbonBand.PresentationPriority state, int availableHeight) {
        int preferredVisibleButtonCount = this.galleryPresentationModel.getPreferredVisibleCommandCounts().get((Object)state);
        BasicRibbonGalleryUI ui = (BasicRibbonGalleryUI)this.getUI();
        return ui.getPreferredWidth(preferredVisibleButtonCount, availableHeight);
    }

    public void setPresentationPriority(JRibbonBand.PresentationPriority presentationPriority) {
        this.presentationPriority = presentationPriority;
    }

    public JRibbonBand.PresentationPriority getPresentationPriority() {
        return this.presentationPriority;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public JCommandButton getButtonAt(int index) {
        return this.buttons.get(index);
    }

    public JCommandButton getSelectedButton() {
        BaseCommand selectedCommand = this.commandToggleGroupModel.getSelected();
        if (selectedCommand == null) {
            return null;
        }
        int buttonIndex = this.commands.indexOf(selectedCommand);
        return this.buttons.get(buttonIndex);
    }

    public RibbonGalleryProjection getProjection() {
        return this.galleryProjection;
    }

    private void setGroupMapping(List<CommandGroup> commandGroups) {
        for (CommandGroup commandGroupModel : commandGroups) {
            for (Command command : commandGroupModel.getCommands()) {
                if (!command.isToggle()) {
                    throw new IllegalStateException("Gallery command must be toggle");
                }
                if (command.getToggleGroupModel() == null) continue;
                throw new IllegalStateException("Gallery toggle command should not be associated with a toggle group");
            }
        }
        boolean hasGroupWithNullTitle = false;
        for (CommandGroup commandGroupModel : commandGroups) {
            if (commandGroupModel.getTitle() == null) {
                if (hasGroupWithNullTitle) {
                    throw new IllegalArgumentException("Can't have more than one ribbon gallery group with null name");
                }
                hasGroupWithNullTitle = true;
            }
            for (Command command : commandGroupModel.getCommands()) {
                this.addGalleryCommand(command);
            }
        }
    }

    private void validateCommandPresentationState(CommandButtonPresentationState commandPresentationState) {
        boolean isSupported;
        boolean bl = isSupported = commandPresentationState == JRibbonBand.BIG_FIXED || commandPresentationState == CommandButtonPresentationState.SMALL || commandPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE;
        if (!isSupported) {
            throw new IllegalArgumentException("Presentation state " + commandPresentationState.getDisplayName() + " is not supported in ribbon galleries");
        }
    }

    public static CommandPopupMenuPanelProjection getExpandPopupMenuPanelProjection(RibbonGalleryProjection galleryProjection) {
        CommandMenuContentModel galleryPopupMenuContentModel = JRibbonGallery.getExpandPopupMenuContentModel(galleryProjection);
        CommandPopupMenuPresentationModel galleryPopupMenuPresentationModel = JRibbonGallery.getExpandPopupMenuPresentationModel(galleryProjection);
        CommandPopupMenuPanelProjection commandPopupMenuPanelProjection = new CommandPopupMenuPanelProjection(galleryPopupMenuContentModel, galleryPopupMenuPresentationModel);
        if (galleryProjection.getCommandOverlays() != null) {
            commandPopupMenuPanelProjection.setCommandOverlays(galleryProjection.getCommandOverlays());
        }
        return commandPopupMenuPanelProjection;
    }

    public static CommandMenuContentModel getExpandPopupMenuContentModel(final RibbonGalleryProjection galleryProjection) {
        CommandPanelContentModel galleryPopupMenuPanelContentModel = new CommandPanelContentModel(((RibbonGalleryContentModel)galleryProjection.getContentModel()).getCommandGroups());
        galleryPopupMenuPanelContentModel.setSingleSelectionMode(true);
        galleryPopupMenuPanelContentModel.setCommandPreviewListener(new BaseCommand.CommandActionPreview(){

            @Override
            public void onCommandPreviewActivated(BaseCommand command) {
                ((RibbonGalleryContentModel)galleryProjection.getContentModel()).activatePreview(command);
            }

            @Override
            public void onCommandPreviewCanceled(BaseCommand command) {
                ((RibbonGalleryContentModel)galleryProjection.getContentModel()).cancelPreview(command);
            }
        });
        return new CommandMenuContentModel(galleryPopupMenuPanelContentModel, ((RibbonGalleryContentModel)galleryProjection.getContentModel()).getExtraPopupCommandGroups());
    }

    public static CommandPopupMenuPresentationModel getExpandPopupMenuPresentationModel(RibbonGalleryProjection galleryProjection) {
        boolean allGroupsHaveTitles = true;
        for (CommandGroup commandGroupModel : ((RibbonGalleryContentModel)galleryProjection.getContentModel()).getCommandGroups()) {
            String groupTitle = commandGroupModel.getTitle();
            if (groupTitle != null) continue;
            allGroupsHaveTitles = false;
            break;
        }
        RibbonGalleryPresentationModel galleryPresentationModel = (RibbonGalleryPresentationModel)galleryProjection.getPresentationModel();
        return CommandPopupMenuPresentationModel.builder().setPanelPresentationModel(CommandPopupMenuPanelPresentationModel.builder().setLayoutSpec(galleryPresentationModel.getPopupLayoutSpec()).setToShowGroupLabels(allGroupsHaveTitles).setCommandPresentationState(galleryPresentationModel.getCommandPresentationState()).build()).build();
    }
}

