/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JCommandButtonStrip;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonStripUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class BasicCommandButtonStripUI
extends CommandButtonStripUI {
    private JCommandButtonStrip buttonStrip;
    private CommandGroup.CommandGroupListener commandGroupListener;
    private Map<Command, JCommandButton> commandButtonMap = new HashMap<Command, JCommandButton>();

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonStripUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonStrip = (JCommandButtonStrip)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.buttonStrip = null;
    }

    protected void installListeners() {
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            private void resync() {
                BasicCommandButtonStripUI.this.buttonStrip.removeAll();
                BasicCommandButtonStripUI.this.commandButtonMap.clear();
                BasicCommandButtonStripUI.this.syncButtons();
            }

            @Override
            public void onCommandAdded(Command command) {
                this.resync();
            }

            @Override
            public void onCommandRemoved(Command command) {
                this.resync();
            }

            @Override
            public void onAllCommandsRemoved(List<Command> commands) {
                this.resync();
            }
        };
        ((CommandGroup)this.buttonStrip.getProjection().getContentModel()).addCommandGroupListener(this.commandGroupListener);
    }

    protected void uninstallListeners() {
        ((CommandGroup)this.buttonStrip.getProjection().getContentModel()).removeCommandGroupListener(this.commandGroupListener);
        this.commandGroupListener = null;
    }

    protected void installDefaults() {
        this.buttonStrip.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.buttonStrip.setLayout(this.createLayoutManager());
        this.syncButtons();
    }

    protected void uninstallComponents() {
        CommandGroup commandGroupModel = (CommandGroup)this.buttonStrip.getProjection().getContentModel();
        for (Command command : commandGroupModel.getCommands()) {
            JCommandButton commandButton = this.commandButtonMap.get(command);
            CommandAction commandListener = command.getAction();
            if (commandListener != null) {
                commandButton.removeCommandListener(commandListener);
            }
            this.buttonStrip.remove(commandButton);
        }
        this.commandButtonMap.clear();
    }

    private void syncButtons() {
        CommandStripPresentationModel stripPresentationModel = (CommandStripPresentationModel)this.buttonStrip.getProjection().getPresentationModel();
        boolean isHorizontal = ((CommandStripPresentationModel)this.buttonStrip.getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.HORIZONTAL;
        RadianceThemingSlices.Side leadingSide = isHorizontal ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TOP;
        RadianceThemingSlices.Side trailingSide = isHorizontal ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.BOTTOM;
        CommandGroup commandGroupModel = (CommandGroup)this.buttonStrip.getProjection().getContentModel();
        List<Command> commands = commandGroupModel.getCommands();
        int commandCount = commands.size();
        for (int i = 0; i < commandCount; ++i) {
            Command command = commands.get(i);
            HashSet<RadianceThemingSlices.Side> straightSides = new HashSet<RadianceThemingSlices.Side>();
            if (commandCount > 1) {
                if (i == 0) {
                    straightSides.add(trailingSide);
                } else if (i == commandCount - 1) {
                    straightSides.add(leadingSide);
                } else {
                    straightSides.add(leadingSide);
                    straightSides.add(trailingSide);
                }
            }
            HashSet<RadianceThemingSlices.Side> openSides = new HashSet<RadianceThemingSlices.Side>();
            if (commandCount > 1 && i > 0) {
                openSides.add(leadingSide);
            }
            CommandButtonPresentationModel presentation = ((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(stripPresentationModel.getCommandPresentationState())).setContentPadding(stripPresentationModel.getCommandContentPadding())).setSides(RadianceThemingSlices.Sides.builder().setOpenSides(openSides).setStraightSides(straightSides).build())).setIconFilterStrategies(stripPresentationModel.getActiveIconFilterStrategy(), stripPresentationModel.getEnabledIconFilterStrategy(), stripPresentationModel.getDisabledIconFilterStrategy())).setHorizontalGapScaleFactor(stripPresentationModel.getHorizontalGapScaleFactor())).setVerticalGapScaleFactor(stripPresentationModel.getVerticalGapScaleFactor())).setBackgroundAppearanceStrategy(stripPresentationModel.getBackgroundAppearanceStrategy())).setFocusable(stripPresentationModel.isFocusable())).setToDismissPopupsOnActivation(stripPresentationModel.isToDismissPopupsOnActivation())).build();
            BaseCommandButtonPresentationModel.Overlay extraOverlay = this.buttonStrip.getProjection().getCommandOverlays().get(command);
            if (extraOverlay != null) {
                presentation = presentation.overlayWith(extraOverlay);
            }
            CommandButtonProjection<Command> commandProjection = command.project(presentation);
            JCommandButton button = (JCommandButton)commandProjection.buildComponent();
            button.setComponentOrientation(this.buttonStrip.getComponentOrientation());
            this.buttonStrip.add(button);
            this.commandButtonMap.put(command, button);
        }
    }

    @Override
    public List<JComponent> getFocusSequence() {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (int i = 0; i < this.buttonStrip.getComponentCount(); ++i) {
            result.add((JCommandButton)this.buttonStrip.getComponent(i));
        }
        return result;
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int i;
            int width = 0;
            int height = 0;
            if (((CommandStripPresentationModel)BasicCommandButtonStripUI.this.buttonStrip.getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.HORIZONTAL) {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getComponentCount(); ++i) {
                    width += ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getComponent((int)i).getPreferredSize().width;
                    height = Math.max(height, ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getComponent((int)i).getPreferredSize().height);
                }
            } else {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getComponentCount(); ++i) {
                    height += ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getComponent((int)i).getPreferredSize().height;
                    width = Math.max(width, ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getComponent((int)i).getPreferredSize().width);
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonCount = BasicCommandButtonStripUI.this.buttonStrip.getComponentCount();
            if (buttonCount == 0) {
                return;
            }
            Insets ins = c.getInsets();
            int height = c.getHeight() - ins.top - ins.bottom;
            int width = c.getWidth() - ins.left - ins.right;
            if (((CommandStripPresentationModel)BasicCommandButtonStripUI.this.buttonStrip.getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.HORIZONTAL) {
                int totalPreferredWidth = 0;
                for (int i = 0; i < buttonCount; ++i) {
                    Component currButton = BasicCommandButtonStripUI.this.buttonStrip.getComponent(i);
                    totalPreferredWidth += currButton.getPreferredSize().width;
                }
                int deltaX = (width - totalPreferredWidth) / buttonCount;
                if (BasicCommandButtonStripUI.this.buttonStrip.getComponentOrientation().isLeftToRight()) {
                    int x = ins.left;
                    for (int i = 0; i < buttonCount; ++i) {
                        Component currButton = BasicCommandButtonStripUI.this.buttonStrip.getComponent(i);
                        currButton.setBounds(x, ins.top, currButton.getPreferredSize().width + deltaX, height);
                        x += currButton.getPreferredSize().width + deltaX;
                    }
                } else {
                    int x = c.getWidth() - ins.right;
                    for (int i = 0; i < buttonCount; ++i) {
                        Component currButton = BasicCommandButtonStripUI.this.buttonStrip.getComponent(i);
                        int buttonWidth = currButton.getPreferredSize().width + deltaX;
                        currButton.setBounds(x - buttonWidth, ins.top, buttonWidth, height);
                        x -= buttonWidth;
                    }
                }
            } else {
                int totalPreferredHeight = 0;
                for (int i = 0; i < buttonCount; ++i) {
                    Component currButton = BasicCommandButtonStripUI.this.buttonStrip.getComponent(i);
                    totalPreferredHeight += currButton.getPreferredSize().height;
                }
                float deltaY = (float)(height - totalPreferredHeight) / (float)buttonCount;
                float y = ins.top;
                for (int i = 0; i < buttonCount; ++i) {
                    Component currButton = BasicCommandButtonStripUI.this.buttonStrip.getComponent(i);
                    float buttonHeight = (float)currButton.getPreferredSize().height + deltaY;
                    currButton.setBounds(ins.left, (int)y, width, (int)Math.ceil(buttonHeight));
                    y += buttonHeight;
                }
            }
        }
    }
}

