/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RibbonTaskToggleButtonBackgroundDelegate {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public void updateTaskToggleButtonBackground(Graphics2D g, final JRibbonTaskToggleButton button) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        ComponentState currState = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)true);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableFillColorScheme, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (BladeUtils.ColorSchemeDelegate)new BladeUtils.ColorSchemeDelegate(){

            public RadianceColorScheme getColorSchemeForCurrentState(ComponentState state) {
                if (state == ComponentState.ENABLED) {
                    RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)button);
                    RadianceThemingSlices.DecorationAreaType buttonDecorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType((Component)button);
                    return skin.getBackgroundColorScheme(buttonDecorationAreaType);
                }
                return RadianceColorSchemeUtilities.getColorScheme((Component)button, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.FILL, (ComponentState)state);
            }

            public RadianceColorScheme getColorSchemeForActiveState(ComponentState state) {
                return RadianceColorSchemeUtilities.getColorScheme((Component)button, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.FILL, (ComponentState)state);
            }
        }, (boolean)true);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableBorderColorScheme, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (BladeUtils.ColorSchemeDelegate)BladeUtils.getDefaultColorSchemeDelegate((Component)button, state -> RadianceThemingSlices.ColorSchemeAssociationKind.BORDER), (boolean)true);
        Color contextualGroupHueColor = button.getContextualGroupHueColor();
        BladeColorScheme finalFillColorScheme = contextualGroupHueColor != null ? RadianceColorSchemeUtilities.getShiftedScheme((RadianceColorScheme)this.mutableFillColorScheme, (Color)contextualGroupHueColor, (double)0.25, null, (double)0.0) : this.mutableFillColorScheme;
        float alpha = 0.0f;
        for (Map.Entry activeEntry : stateTransitionTracker.getModelStateInfo().getStateContributionMap().entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
            alpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
        }
        if (alpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)button, (float)alpha, (Graphics)g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)button);
            RibbonTaskToggleButtonBackgroundDelegate.drawFullAlphaBackgroundImage(graphics, button, (RadianceColorScheme)finalFillColorScheme, (RadianceColorScheme)this.mutableBorderColorScheme, borderPainter);
            graphics.dispose();
        }
    }

    public static float getTaskToggleButtonCornerRadius(JRibbonTaskToggleButton button) {
        return RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)button), (float)3.0f, (int)6, (float)1.0f);
    }

    private static void drawFullAlphaBackgroundImage(Graphics2D g, JRibbonTaskToggleButton button, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, RadianceBorderPainter borderPainter) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)button.getWidth(), (int)button.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceThemingSlices.DecorationAreaType buttonDecorationAreaType;
            EnumSet<RadianceThemingSlices.Side> bottom = EnumSet.of(RadianceThemingSlices.Side.BOTTOM);
            float radius = (float)scaleFactor * RibbonTaskToggleButtonBackgroundDelegate.getTaskToggleButtonCornerRadius(button);
            Shape contour = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)button.getComponentOrientation(), (float)scaledWidth, (float)((float)scaledHeight + 3.0f), (float)radius, bottom, (float)1.0f);
            RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)button);
            if (skin.isRegisteredAsDecorationArea(buttonDecorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType((Component)button))) {
                DecorationPainterUtils.paintDecorationArea((Graphics)graphics1X, (Component)button, (Shape)contour, (RadianceThemingSlices.DecorationAreaType)buttonDecorationAreaType, (RadianceColorScheme)fillScheme, (boolean)false);
            } else {
                graphics1X.setColor(fillScheme.getBackgroundFillColor());
                graphics1X.fill(contour);
            }
            Shape contourInner = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)button.getComponentOrientation(), (float)scaledWidth, (float)((float)scaledHeight + 4.0f), (float)radius, bottom, (float)2.0f);
            borderPainter.paintBorder((Graphics)graphics1X, (Component)button, (float)scaledWidth, (float)scaledHeight + 2.0f, contour, contourInner, borderScheme);
        });
        graphics.dispose();
    }
}

