/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.utils;

import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;

public class CommandButtonVisualStateTracker {
    private PropertyChangeListener radiancePropertyListener;
    private StateTransitionTracker actionStateTransitionTracker;
    private StateTransitionTracker popupStateTransitionTracker;

    public void installListeners(JCommandButton b) {
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("actionModel".equals(propertyChangeEvent.getPropertyName())) {
                this.actionStateTransitionTracker.setModel((ButtonModel)b.getActionModel());
            }
            if ("popupModel".equals(propertyChangeEvent.getPropertyName())) {
                this.popupStateTransitionTracker.setModel((ButtonModel)b.getPopupModel());
            }
        };
        b.addPropertyChangeListener(this.radiancePropertyListener);
        this.actionStateTransitionTracker = new StateTransitionTracker((JComponent)b, (ButtonModel)b.getActionModel());
        this.actionStateTransitionTracker.registerModelListeners();
        this.popupStateTransitionTracker = new StateTransitionTracker((JComponent)b, (ButtonModel)b.getPopupModel());
        this.popupStateTransitionTracker.registerModelListeners();
    }

    public void uninstallListeners(JCommandButton b) {
        b.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.actionStateTransitionTracker.unregisterModelListeners();
        this.actionStateTransitionTracker = null;
        if (this.popupStateTransitionTracker != null) {
            this.popupStateTransitionTracker.unregisterModelListeners();
            this.popupStateTransitionTracker = null;
        }
    }

    public StateTransitionTracker getActionStateTransitionTracker() {
        return this.actionStateTransitionTracker;
    }

    public StateTransitionTracker getPopupStateTransitionTracker() {
        return this.popupStateTransitionTracker;
    }
}

