/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.PopupButtonModel;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class BreadcrumbCommandButtonPopupIcon
implements RadianceIcon {
    private int baseWidth;
    private int baseHeight;
    private int dimension;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();

    public BreadcrumbCommandButtonPopupIcon() {
        int fontSize = RadianceSizeUtils.getComponentFontSize(null);
        this.baseWidth = (int)RadianceSizeUtils.getArrowIconWidth((int)fontSize);
        this.baseHeight = (int)RadianceSizeUtils.getArrowIconHeight((int)fontSize);
        this.dimension = Math.max(this.baseWidth, this.baseHeight);
    }

    public void setDimension(Dimension newDimension) {
        this.baseWidth = newDimension.width;
        this.baseHeight = newDimension.height;
        this.dimension = Math.max(this.baseWidth, this.baseHeight);
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.dimension;
    }

    public int getIconWidth() {
        return this.dimension;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean displayDownwards;
        JCommandButton commandButton = (JCommandButton)c;
        StateTransitionTracker stateTransitionTracker = ((ActionPopupTransitionAwareUI)((Object)commandButton.getUI())).getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableColorScheme, (Component)c, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK, (boolean)false);
        PopupButtonModel model = commandButton.getPopupModel();
        boolean bl = displayDownwards = model.isRollover() || model.isPopupShowing();
        int direction = displayDownwards ? 5 : (commandButton.getComponentOrientation().isLeftToRight() ? 3 : 7);
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)c);
        int widthNudge = Math.round((float)(this.dimension - this.baseWidth) / 2.0f);
        int heightNudge = Math.round((float)(this.dimension - this.baseHeight) / 2.0f);
        int dx = displayDownwards ? widthNudge : heightNudge;
        int dy = displayDownwards ? heightNudge : widthNudge;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x + dx, y + dy);
        BladeArrowIconUtils.drawArrow((Graphics2D)graphics, (float)this.baseWidth, (float)this.baseHeight, (float)(RadianceSizeUtils.getArrowStrokeWidth((int)fontSize) - 0.5f), (int)direction, (RadianceColorScheme)this.mutableColorScheme);
        graphics.dispose();
    }
}

