/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class BladeTransitionAwareRadianceIcon
implements RadianceIcon {
    protected int width;
    protected int height;
    private JComponent comp;
    private StateTransitionTrackerDelegate stateTransitionTrackerDelegate;
    private Delegate delegate;
    private BladeColorScheme mutableColorScheme = new BladeColorScheme();

    public BladeTransitionAwareRadianceIcon(JCommandButton button, StateTransitionTrackerDelegate stateTransitionTrackerDelegate, Delegate delegate, Dimension initialDim) {
        this.comp = button;
        this.stateTransitionTrackerDelegate = stateTransitionTrackerDelegate;
        this.delegate = delegate;
        this.width = initialDim.width;
        this.height = initialDim.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionTrackerDelegate.getStateTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableColorScheme, (Component)this.comp, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK, (boolean)false);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        this.delegate.drawColorSchemeIcon(graphics, (RadianceColorScheme)this.mutableColorScheme, this.width, this.height);
        graphics.dispose();
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public boolean supportsColorFilter() {
        return false;
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public static interface StateTransitionTrackerDelegate {
        public StateTransitionTracker getStateTransitionTracker();
    }

    @FunctionalInterface
    public static interface Delegate {
        public void drawColorSchemeIcon(Graphics2D var1, RadianceColorScheme var2, int var3, int var4);
    }
}

