/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon.synapse.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.RibbonRadioButtonContentModel;

public class RibbonRadioButtonGroupModel {
    private Vector<RibbonRadioButtonContentModel> radioButtonModels = new Vector();
    private Map<RibbonRadioButtonContentModel, ChangeListener> modelChangeListeners = new HashMap<RibbonRadioButtonContentModel, ChangeListener>();
    private RibbonRadioButtonContentModel selection;
    private boolean allowsClearingSelection = true;

    public Collection<RibbonRadioButtonContentModel> getRadioButtonModels() {
        return Collections.unmodifiableCollection(this.radioButtonModels);
    }

    public void setAllowsClearingSelection(boolean allowsClearingSelection) {
        this.allowsClearingSelection = allowsClearingSelection;
    }

    public boolean isAllowsClearingSelection() {
        return this.allowsClearingSelection;
    }

    public void add(final RibbonRadioButtonContentModel radioButtonContentModel) {
        boolean wasSelectionNull;
        if (radioButtonContentModel == null) {
            return;
        }
        this.radioButtonModels.addElement(radioButtonContentModel);
        boolean bl = wasSelectionNull = this.selection == null;
        if (radioButtonContentModel.isSelected()) {
            if (wasSelectionNull) {
                this.selection = radioButtonContentModel;
            } else {
                radioButtonContentModel.setSelected(false);
            }
        }
        ChangeListener cl = new ChangeListener(){
            boolean wasSelected;
            {
                this.wasSelected = radioButtonContentModel.isSelected();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = radioButtonContentModel.isSelected();
                if (this.wasSelected != isSelected) {
                    RibbonRadioButtonGroupModel.this.setSelected(radioButtonContentModel, isSelected);
                }
                this.wasSelected = isSelected;
            }
        };
        radioButtonContentModel.addChangeListener(cl);
        this.modelChangeListeners.put(radioButtonContentModel, cl);
    }

    public void remove(RibbonRadioButtonContentModel radioButtonContentModel) {
        boolean wasSelected;
        if (radioButtonContentModel == null) {
            return;
        }
        this.radioButtonModels.removeElement(radioButtonContentModel);
        boolean bl = wasSelected = radioButtonContentModel == this.selection;
        if (wasSelected) {
            this.selection = null;
        }
        radioButtonContentModel.removeChangeListener(this.modelChangeListeners.get(radioButtonContentModel));
        this.modelChangeListeners.remove(radioButtonContentModel);
    }

    public void removeAll() {
        this.radioButtonModels.clear();
        this.selection = null;
    }

    public void setSelected(RibbonRadioButtonContentModel radioButtonContentModel, boolean isSelected) {
        if (isSelected && radioButtonContentModel != null && radioButtonContentModel != this.selection) {
            RibbonRadioButtonContentModel oldSelection = this.selection;
            this.selection = radioButtonContentModel;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            radioButtonContentModel.setSelected(true);
        }
        if (!isSelected && radioButtonContentModel != null && radioButtonContentModel == this.selection) {
            if (this.allowsClearingSelection) {
                this.selection = null;
                radioButtonContentModel.setSelected(false);
            } else {
                radioButtonContentModel.setSelected(true);
            }
        }
    }

    public RibbonRadioButtonContentModel getSelected() {
        return this.selection;
    }

    public void clearSelection() {
        if (this.allowsClearingSelection && this.selection != null) {
            this.selection.setSelected(false);
        }
    }
}

