/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon.synapse.model;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.ChangeAware;
import org.pushingpixels.radiance.component.api.common.model.PropertyChangeAware;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.RibbonRadioButtonGroupModel;
import org.pushingpixels.radiance.component.internal.utils.WeakChangeSupport;

public class RibbonRadioButtonContentModel
implements ComponentContentModel,
ChangeAware,
PropertyChangeAware {
    private boolean isEnabled;
    private RadianceIcon.Factory iconFactory;
    private String caption;
    private RichTooltip richTooltip;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private String text;
    private boolean isSelected;
    private RibbonRadioButtonGroupModel toggleGroupModel;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private RibbonRadioButtonContentModel() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }

    public String getText() {
        return this.text;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            this.pcs.firePropertyChange("selected", !this.isSelected, this.isSelected);
            this.fireStateChanged();
        }
    }

    public RibbonRadioButtonGroupModel getToggleGroupModel() {
        return this.toggleGroupModel;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    @Override
    public RadianceIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public ItemListener getItemListener() {
        return this.itemListener;
    }

    public static class Builder {
        private boolean isEnabled = true;
        private RadianceIcon.Factory iconFactory;
        private String caption;
        private RichTooltip richTooltip;
        private String text;
        private boolean isSelected;
        protected RibbonRadioButtonGroupModel toggleGroupModel;
        private ActionListener actionListener;
        private ItemListener itemListener;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setSelected(boolean selected) {
            this.isSelected = selected;
            return this;
        }

        public Builder setToggleGroupModel(RibbonRadioButtonGroupModel toggleGroupModel) {
            this.toggleGroupModel = toggleGroupModel;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setIconFactory(RadianceIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return this;
        }

        public Builder setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public Builder setActionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
            return this;
        }

        public Builder setItemListener(ItemListener itemListener) {
            this.itemListener = itemListener;
            return this;
        }

        public RibbonRadioButtonContentModel build() {
            RibbonRadioButtonContentModel model = new RibbonRadioButtonContentModel();
            model.text = this.text;
            model.isSelected = this.isSelected;
            model.toggleGroupModel = this.toggleGroupModel;
            if (model.toggleGroupModel != null) {
                model.toggleGroupModel.add(model);
            }
            model.actionListener = this.actionListener;
            if (this.itemListener != null) {
                model.itemListener = new ItemListener(){
                    private boolean lastIsSelected;
                    {
                        this.lastIsSelected = isSelected;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean newIsSelected;
                        boolean bl = newIsSelected = e.getStateChange() == 1;
                        if (this.lastIsSelected == newIsSelected) {
                            return;
                        }
                        itemListener.itemStateChanged(e);
                        this.lastIsSelected = newIsSelected;
                    }
                };
            }
            model.isEnabled = this.isEnabled;
            model.iconFactory = this.iconFactory;
            model.caption = this.caption;
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

