/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon;

import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTask;
import org.pushingpixels.radiance.component.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonBandUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;

public abstract class AbstractRibbonBand
extends JComponent {
    public static final String uiClassID = "RibbonBandUI";
    private RibbonTask ribbonTask;
    private String title;
    private CommandAction expandCommandListener;
    private AbstractBandControlPanel controlPanel;
    private AbstractRibbonBand popupRibbonBand;
    private RadianceIcon.Factory iconFactory;
    private RibbonBandResizePolicy currResizePolicy;
    protected List<RibbonBandResizePolicy> resizePolicies;
    private String expandButtonKeyTip;
    private RichTooltip expandButtonRichTooltip;
    private String collapsedStateKeyTip;

    public AbstractRibbonBand(String title, RadianceIcon.Factory iconFactory, CommandAction expandCommandListener, AbstractBandControlPanel controlPanel) {
        this.title = title;
        this.iconFactory = iconFactory;
        this.expandCommandListener = expandCommandListener;
        this.controlPanel = controlPanel;
        this.controlPanel.setRibbonBand(this);
        this.add(this.controlPanel);
        this.updateUI();
    }

    public abstract AbstractRibbonBand cloneBand();

    @Override
    public RibbonBandUI getUI() {
        return (RibbonBandUI)this.ui;
    }

    public void setUI(RibbonBandUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceRibbonBandUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public RadianceIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange("title", old, this.title);
    }

    public CommandAction getExpandCommandListener() {
        return this.expandCommandListener;
    }

    public void setExpandCommandListener(CommandAction expandCommandListener) {
        CommandAction old = this.expandCommandListener;
        this.expandCommandListener = expandCommandListener;
        this.firePropertyChange("expandCommandListener", old, this.expandCommandListener);
    }

    public AbstractBandControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void setControlPanel(AbstractBandControlPanel controlPanel) {
        if (controlPanel == null) {
            this.remove(this.controlPanel);
        } else {
            this.add(controlPanel);
            controlPanel.applyComponentOrientation(this.getComponentOrientation());
        }
        this.controlPanel = controlPanel;
    }

    public AbstractRibbonBand getPopupRibbonBand() {
        return this.popupRibbonBand;
    }

    public void setPopupRibbonBand(AbstractRibbonBand popupRibbonBand) {
        this.popupRibbonBand = popupRibbonBand;
        if (this.popupRibbonBand != null) {
            popupRibbonBand.applyComponentOrientation(this.getComponentOrientation());
        }
    }

    public RibbonBandResizePolicy getCurrentResizePolicy() {
        return this.currResizePolicy;
    }

    public void setCurrentResizePolicy(RibbonBandResizePolicy resizePolicy) {
        this.currResizePolicy = resizePolicy;
    }

    public List<RibbonBandResizePolicy> getResizePolicies() {
        return Collections.unmodifiableList(this.resizePolicies);
    }

    public void setResizePolicies(List<RibbonBandResizePolicy> resizePolicies) {
        this.resizePolicies = Collections.unmodifiableList(resizePolicies);
        if (this.ribbonTask != null) {
            ComponentUtilities.checkResizePoliciesConsistency(this);
        }
    }

    public String getExpandButtonKeyTip() {
        return this.expandButtonKeyTip;
    }

    public void setExpandButtonKeyTip(String expandButtonKeyTip) {
        String old = this.expandButtonKeyTip;
        this.expandButtonKeyTip = expandButtonKeyTip;
        this.firePropertyChange("expandButtonKeyTip", old, this.expandButtonKeyTip);
    }

    public RichTooltip getExpandButtonRichTooltip() {
        return this.expandButtonRichTooltip;
    }

    public void setExpandButtonRichTooltip(RichTooltip expandButtonRichTooltip) {
        RichTooltip old = this.expandButtonRichTooltip;
        this.expandButtonRichTooltip = expandButtonRichTooltip;
        this.firePropertyChange("expandButtonRichTooltip", old, this.expandButtonRichTooltip);
    }

    public String getCollapsedStateKeyTip() {
        return this.collapsedStateKeyTip;
    }

    public void setCollapsedStateKeyTip(String collapsedStateKeyTip) {
        String old = this.collapsedStateKeyTip;
        this.collapsedStateKeyTip = collapsedStateKeyTip;
        this.firePropertyChange("collapsedStateKeyTip", old, this.collapsedStateKeyTip);
    }

    void setRibbonTask(RibbonTask ribbonTask) {
        if (this.ribbonTask != null) {
            throw new IllegalArgumentException("Ribbon band cannot be added to more than one ribbon task");
        }
        this.ribbonTask = ribbonTask;
        ComponentUtilities.checkResizePoliciesConsistency(this);
    }
}

