/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.popup.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.KeyValuePair;
import org.pushingpixels.radiance.component.api.common.model.ChangeAware;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.internal.utils.WeakChangeSupport;

public class ColorSelectorPopupMenuGroupModel
implements ChangeAware {
    private List<KeyValuePair<GroupEntryKind, Object>> groupContent;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private ColorSelectorPopupMenuGroupModel() {
    }

    public List<KeyValuePair<GroupEntryKind, Object>> getGroupContent() {
        return Collections.unmodifiableList(this.groupContent);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }

    public static class Builder {
        private List<KeyValuePair<GroupEntryKind, Object>> groupContent = new ArrayList<KeyValuePair<GroupEntryKind, Object>>();

        public Builder addCommand(Command command) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, Command>(GroupEntryKind.COMMAND, command));
            return this;
        }

        public Builder addColorSection(ColorSectionModel colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModel>(GroupEntryKind.COLOR_SECTION, colorSectionModel));
            return this;
        }

        public Builder addColorSectionWithDerived(ColorSectionModelWithDerived colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModelWithDerived>(GroupEntryKind.COLOR_SECTION_WITH_DERIVED, colorSectionModel));
            return this;
        }

        public Builder addRecentsSection(ColorSectionModel colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModel>(GroupEntryKind.RECENTS_SECTION, colorSectionModel));
            return this;
        }

        public ColorSelectorPopupMenuGroupModel build() {
            ColorSelectorPopupMenuGroupModel menuGroupModel = new ColorSelectorPopupMenuGroupModel();
            menuGroupModel.groupContent = Collections.unmodifiableList(this.groupContent);
            return menuGroupModel;
        }
    }

    public static class ColorSectionModelWithDerived {
        private String title;
        private Color[] colors;
        private int derivedCount;

        public ColorSectionModelWithDerived(String title, Color[] colors, int derivedCount) {
            this.title = title;
            this.colors = colors;
            this.derivedCount = derivedCount;
        }

        public final String getTitle() {
            return this.title;
        }

        public final Color[] getColors() {
            return Arrays.copyOf(this.colors, this.colors.length);
        }

        public int getDerivedCount() {
            return this.derivedCount;
        }
    }

    public static class ColorSectionModel {
        private String title;
        private Color[] colors;

        public ColorSectionModel(String title) {
            this.title = title;
        }

        public ColorSectionModel(String title, Color[] colors) {
            this.title = title;
            this.colors = colors;
        }

        public final String getTitle() {
            return this.title;
        }

        public final Color[] getColors() {
            return Arrays.copyOf(this.colors, this.colors.length);
        }
    }

    public static enum GroupEntryKind {
        COMMAND,
        COLOR_SECTION,
        COLOR_SECTION_WITH_DERIVED,
        RECENTS_SECTION;

    }
}

