/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.popup;

import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JCommandButtonPanel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPopupMenuPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelLayoutSpec;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelRowFillSpec;
import org.pushingpixels.radiance.component.api.common.popup.AbstractPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.CommandPanelProjection;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceCommandPopupMenuPanelUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.ScrollableHost;

public class JCommandPopupMenuPanel
extends AbstractPopupMenuPanel
implements ScrollableHost {
    public static final String uiClassID = "CommandPopupMenuPanelUI";
    private Projection<JCommandPopupMenuPanel, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection;
    private CommandMenuContentModel popupMenuContentModel;
    private CommandPopupMenuPresentationModel popupMenuPresentationModel;
    private CommandPanelContentModel popupMenuPanelContentModel;
    private ChangeListener popupMenuPanelContentChangeListener;
    private JCommandButtonPanel mainButtonPanel;

    public JCommandPopupMenuPanel(Projection<JCommandPopupMenuPanel, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.popupMenuContentModel = (CommandMenuContentModel)projection.getContentModel();
        this.popupMenuPresentationModel = (CommandPopupMenuPresentationModel)projection.getPresentationModel();
        this.popupMenuPanelContentModel = this.popupMenuContentModel != null ? this.popupMenuContentModel.getPanelContentModel() : null;
        this.syncContent();
        this.popupMenuPanelContentChangeListener = event -> this.syncContent();
        this.popupMenuContentModel.addChangeListener(this.popupMenuPanelContentChangeListener);
        this.updateUI();
        SwingUtilities.invokeLater(() -> {
            if (this.mainButtonPanel != null) {
                this.mainButtonPanel.scrollToSelectedCommand();
            }
        });
    }

    private void syncContent() {
        if (this.popupMenuPanelContentModel != null) {
            CommandPopupMenuPanelPresentationModel commandPopupMenuPanelPresentationModel = this.popupMenuPresentationModel.getPanelPresentationModel();
            this.mainButtonPanel = (JCommandButtonPanel)new CommandPanelProjection(this.popupMenuPanelContentModel, CommandPanelPresentationModel.builder().setLayoutSpec(new PanelLayoutSpec.RowFill(new PanelRowFillSpec.Fixed(commandPopupMenuPanelPresentationModel.getLayoutSpec().getColumnCount()))).setContentPadding(commandPopupMenuPanelPresentationModel.getContentPadding()).setContentGap(commandPopupMenuPanelPresentationModel.getContentGap()).setCommandPresentationState(commandPopupMenuPanelPresentationModel.getCommandPresentationState()).setCommandContentPadding(commandPopupMenuPanelPresentationModel.getCommandContentPadding()).setCommandHorizontalAlignment(commandPopupMenuPanelPresentationModel.getCommandHorizontalAlignment()).setCommandIconDimension(commandPopupMenuPanelPresentationModel.getCommandIconDimension()).setToShowGroupLabels(commandPopupMenuPanelPresentationModel.isToShowGroupLabels()).setCommandHorizontalGapScaleFactor(commandPopupMenuPanelPresentationModel.getCommandHorizontalGapScaleFactor()).setCommandVerticalGapScaleFactor(commandPopupMenuPanelPresentationModel.getCommandVerticalGapScaleFactor()).setBackgroundAppearanceStrategy(commandPopupMenuPanelPresentationModel.getBackgroundAppearanceStrategy()).setIconFilterStrategies(commandPopupMenuPanelPresentationModel.getActiveIconFilterStrategy(), commandPopupMenuPanelPresentationModel.getEnabledIconFilterStrategy(), commandPopupMenuPanelPresentationModel.getDisabledIconFilterStrategy()).build()).buildComponent();
        }
        List<CommandGroup> commandGroups = this.popupMenuContentModel.getCommandGroups();
        boolean atLeastOneButtonHasIcon = false;
        block0: for (CommandGroup commandGroup : commandGroups) {
            for (Command command : commandGroup.getCommands()) {
                if (command.getIconFactory() == null && !command.isToggle()) continue;
                atLeastOneButtonHasIcon = true;
                continue block0;
            }
        }
        CommandButtonPresentationModel presentation = ((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(this.popupMenuPresentationModel.getItemPresentationState())).setIconFilterStrategies(this.popupMenuPresentationModel.getItemActiveIconFilterStrategy(), this.popupMenuPresentationModel.getItemEnabledIconFilterStrategy(), this.popupMenuPresentationModel.getItemDisabledIconFilterStrategy())).setContentPadding(this.popupMenuPresentationModel.getItemContentPadding())).setSides(this.popupMenuPresentationModel.getItemSides())).setHorizontalAlignment(this.popupMenuPresentationModel.getItemHorizontalAlignment())).setPopupFireTrigger(this.popupMenuPresentationModel.getItemPopupFireTrigger())).setSelectedStateHighlight(this.popupMenuPresentationModel.getItemSelectedStateHighlight())).setPopupPlacementStrategy(this.popupMenuPresentationModel.getPopupPlacementStrategy())).setForceAllocateSpaceForIcon(atLeastOneButtonHasIcon)).build();
        for (int i = 0; i < commandGroups.size(); ++i) {
            for (Command command : commandGroups.get(i).getCommands()) {
                BaseCommandButtonPresentationModel.Overlay overlay = this.projection.getCommandOverlays().get(command);
                CommandButtonPresentationModel combinedPresentationModel = overlay != null ? presentation.overlayWith(overlay) : presentation;
                CommandButtonProjection<Command> commandProjection = command.project(combinedPresentationModel);
                JCommandButton commandButton = (JCommandButton)commandProjection.buildComponent();
                Command highlightedCommand = this.popupMenuContentModel.getHighlightedCommand();
                if (command == highlightedCommand) {
                    commandButton.setFont(commandButton.getFont().deriveFont(1));
                }
                this.addMenuButton(commandButton);
            }
            if (i >= commandGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    public Projection<JCommandPopupMenuPanel, CommandMenuContentModel, CommandPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    public boolean hasCommandButtonPanel() {
        return this.mainButtonPanel != null;
    }

    public JCommandButtonPanel getMainButtonPanel() {
        return this.mainButtonPanel;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceCommandPopupMenuPanelUI.createUI(this));
    }
}

