/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.popup;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.KeyValuePair;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.AbstractPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.radiance.component.api.common.popup.model.ColorSelectorPopupMenuGroupModel;
import org.pushingpixels.radiance.component.api.common.popup.model.ColorSelectorPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceColorSelectorPopupMenuPanelUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.ColorSelectorPopupMenuMultiRowSelector;
import org.pushingpixels.radiance.component.internal.ui.common.popup.ColorSelectorPopupMenuSingleRowSelector;
import org.pushingpixels.radiance.component.internal.ui.common.popup.JColorSelectorPanel;

public class JColorSelectorPopupMenuPanel
extends AbstractPopupMenuPanel {
    public static final String uiClassID = "ColorSelectorPopupMenuPanelUI";
    private Projection<JColorSelectorPopupMenuPanel, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection;
    private ColorSelectorPopupMenuContentModel contentModel;
    private ColorSelectorPopupMenuPresentationModel presentationModel;
    private int colorColumns;
    private JColorSelectorPanel lastColorSelectorPanel;
    private ChangeListener contentChangeListener;
    private static LinkedList<Color> recentlySelected = new LinkedList();

    public JColorSelectorPopupMenuPanel(Projection<JColorSelectorPopupMenuPanel, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.contentModel = (ColorSelectorPopupMenuContentModel)projection.getContentModel();
        this.presentationModel = (ColorSelectorPopupMenuPresentationModel)projection.getPresentationModel();
        this.colorColumns = this.presentationModel.getColorColumns();
        this.syncContent();
        this.contentChangeListener = event -> this.syncContent();
        this.contentModel.addChangeListener(this.contentChangeListener);
        this.updateUI();
    }

    public Projection<JColorSelectorPopupMenuPanel, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    private void syncContent() {
        List<ColorSelectorPopupMenuGroupModel> menuGroups = this.contentModel.getMenuGroups();
        boolean atLeastOneButtonHasIcon = false;
        block6: for (int i = 0; i < menuGroups.size(); ++i) {
            ColorSelectorPopupMenuGroupModel menuGroup = menuGroups.get(i);
            for (KeyValuePair<ColorSelectorPopupMenuGroupModel.GroupEntryKind, Object> groupEntry : menuGroup.getGroupContent()) {
                Command command;
                if (groupEntry.getKey() != ColorSelectorPopupMenuGroupModel.GroupEntryKind.COMMAND || (command = (Command)groupEntry.getValue()).getIconFactory() == null && !command.isToggle()) continue;
                atLeastOneButtonHasIcon = true;
                continue block6;
            }
        }
        CommandButtonPresentationModel presentation = ((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(this.presentationModel.getMenuPresentationState())).setPopupFireTrigger(this.presentationModel.getMenuPopupFireTrigger())).setSelectedStateHighlight(this.presentationModel.getSelectedStateHighlight())).setForceAllocateSpaceForIcon(atLeastOneButtonHasIcon)).build();
        for (int i = 0; i < menuGroups.size(); ++i) {
            ColorSelectorPopupMenuGroupModel menuGroup = menuGroups.get(i);
            for (KeyValuePair<ColorSelectorPopupMenuGroupModel.GroupEntryKind, Object> groupEntry : menuGroup.getGroupContent()) {
                switch (groupEntry.getKey()) {
                    case COMMAND: {
                        Command command = (Command)groupEntry.getValue();
                        JCommandButton commandButton = (JCommandButton)command.project(presentation).buildComponent();
                        this.addMenuButton(commandButton);
                        break;
                    }
                    case COLOR_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel colorSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addColorSection(colorSectionModel.getTitle(), colorSectionModel.getColors());
                        break;
                    }
                    case COLOR_SECTION_WITH_DERIVED: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModelWithDerived colorSectionWithDerivedModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModelWithDerived)groupEntry.getValue();
                        this.addColorSectionWithDerived(colorSectionWithDerivedModel.getTitle(), colorSectionWithDerivedModel.getColors(), colorSectionWithDerivedModel.getDerivedCount());
                        break;
                    }
                    case RECENTS_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel recentsSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addRecentSection(recentsSectionModel.getTitle());
                    }
                }
            }
            if (i >= menuGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceColorSelectorPopupMenuPanelUI.createUI(this));
    }

    private void addColorSectionWithDerived(String label, Color[] primaryColors, int derivedCount) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        if (derivedCount < 1) {
            throw new IllegalArgumentException("Needs to pass a non-trivial number of derived colors");
        }
        ColorSelectorPopupMenuMultiRowSelector selectorContainer = new ColorSelectorPopupMenuMultiRowSelector(this, derivedCount, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addColorSection(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        ColorSelectorPopupMenuSingleRowSelector selectorContainer = new ColorSelectorPopupMenuSingleRowSelector(this, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addRecentSection(String label) {
        int colorCount = Math.min(recentlySelected.size(), this.colorColumns);
        Color[] toDisplay = Arrays.copyOfRange(recentlySelected.toArray(new Color[0]), 0, colorCount);
        ColorSelectorPopupMenuSingleRowSelector recent = new ColorSelectorPopupMenuSingleRowSelector(this, toDisplay);
        JColorSelectorPanel recentPanel = new JColorSelectorPanel(label, recent);
        recentPanel.setLastPanel(true);
        this.addMenuPanel(recentPanel);
        this.lastColorSelectorPanel = recentPanel;
    }

    @Override
    protected void addMenuButton(JCommandButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    protected void addMenuSeparator() {
        super.addMenuSeparator();
        this.updateLastColorSelectorPanel();
    }

    private void updateLastColorSelectorPanel() {
        if (this.lastColorSelectorPanel != null) {
            this.lastColorSelectorPanel.setLastPanel(true);
            this.lastColorSelectorPanel = null;
        }
    }

    public static synchronized List<Color> getRecentlyUsedColors() {
        return Collections.unmodifiableList(recentlySelected);
    }

    public static synchronized void addColorToRecentlyUsed(Color color) {
        if (recentlySelected.contains(color)) {
            recentlySelected.remove(color);
            recentlySelected.addFirst(color);
            return;
        }
        if (recentlySelected.size() == 100) {
            recentlySelected.removeLast();
        }
        recentlySelected.addFirst(color);
    }
}

