/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.ChangeAware;
import org.pushingpixels.radiance.component.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.model.PropertyChangeAware;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.internal.utils.WeakChangeSupport;
import org.pushingpixels.radiance.component.internal.utils.WeakPropertyChangeSupport;

public abstract class BaseCommand<MCM extends BaseCommandMenuContentModel>
implements ContentModel,
ChangeAware,
PropertyChangeAware {
    private String text;
    private String extraText;
    private RadianceIcon.Factory iconFactory;
    private CommandAction action;
    private CommandActionPreview actionPreview;
    private boolean isActionEnabled;
    private boolean isToggle;
    private boolean isToggleSelected;
    private RichTooltip actionRichTooltip;
    private MCM secondaryContentModel;
    private SecondaryLifecycle secondaryLifecycle;
    private RichTooltip secondaryRichTooltip;
    private boolean isSecondaryEnabled;
    private CommandToggleGroupModel toggleGroupModel;
    private Object tag;
    private final WeakChangeSupport weakChangeSupport = new WeakChangeSupport(this);
    private final WeakPropertyChangeSupport weakPropertyChangeSupport = new WeakPropertyChangeSupport(this);

    protected BaseCommand() {
    }

    protected void checkConsistency() {
        if (this.action == null && this.actionRichTooltip != null) {
            throw new IllegalStateException("Configured action rich tooltip with no action");
        }
        if (this.secondaryContentModel == null && this.secondaryRichTooltip != null) {
            throw new IllegalStateException("Configured secondary rich tooltip with no callback");
        }
        if (this.isToggleSelected && !this.isToggle) {
            throw new IllegalStateException("Command configured to not be a toggle but is selected");
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            String old = this.text;
            this.text = text;
            this.weakPropertyChangeSupport.firePropertyChange("text", old, this.text);
        }
    }

    public RadianceIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    public void setIconFactory(RadianceIcon.Factory iconFactory) {
        if (this.iconFactory != iconFactory) {
            RadianceIcon.Factory old = this.iconFactory;
            this.iconFactory = iconFactory;
            this.weakPropertyChangeSupport.firePropertyChange("iconFactory", old, this.iconFactory);
        }
    }

    public String getExtraText() {
        return this.extraText;
    }

    public void setExtraText(String extraText) {
        String old = this.extraText;
        this.extraText = extraText;
        this.weakPropertyChangeSupport.firePropertyChange("extraText", old, this.extraText);
    }

    public CommandAction getAction() {
        return this.action;
    }

    public void setAction(CommandAction actionListener) {
        CommandAction old = this.action;
        this.action = actionListener;
        this.weakPropertyChangeSupport.firePropertyChange("action", old, this.action);
    }

    public RichTooltip getActionRichTooltip() {
        return this.actionRichTooltip;
    }

    public void setActionRichTooltip(RichTooltip actionRichTooltip) {
        if (this.actionRichTooltip != actionRichTooltip) {
            RichTooltip old = this.actionRichTooltip;
            this.actionRichTooltip = actionRichTooltip;
            this.weakPropertyChangeSupport.firePropertyChange("actionRichTooltip", old, this.actionRichTooltip);
        }
    }

    public boolean hasSecondaryContent() {
        return this.getSecondaryContentModel() != null && !this.getSecondaryContentModel().isEmpty();
    }

    public MCM getSecondaryContentModel() {
        return this.secondaryContentModel;
    }

    public SecondaryLifecycle getSecondaryLifecycle() {
        return this.secondaryLifecycle;
    }

    public RichTooltip getSecondaryRichTooltip() {
        return this.secondaryRichTooltip;
    }

    public void setSecondaryRichTooltip(RichTooltip secondaryRichTooltip) {
        if (this.secondaryRichTooltip != secondaryRichTooltip) {
            RichTooltip old = this.secondaryRichTooltip;
            this.secondaryRichTooltip = secondaryRichTooltip;
            this.weakPropertyChangeSupport.firePropertyChange("secondaryRichTooltip", old, this.secondaryRichTooltip);
        }
    }

    public boolean isActionEnabled() {
        return this.isActionEnabled;
    }

    public void setActionEnabled(boolean actionEnabled) {
        if (this.isActionEnabled != actionEnabled) {
            this.isActionEnabled = actionEnabled;
            this.weakPropertyChangeSupport.firePropertyChange("actionEnabled", !this.isActionEnabled, this.isActionEnabled);
        }
    }

    public boolean isSecondaryEnabled() {
        return this.isSecondaryEnabled;
    }

    public void setSecondaryEnabled(boolean secondaryEnabled) {
        if (this.isSecondaryEnabled != secondaryEnabled) {
            this.isSecondaryEnabled = secondaryEnabled;
            this.weakPropertyChangeSupport.firePropertyChange("secondaryEnabled", !this.isSecondaryEnabled, this.isSecondaryEnabled);
        }
    }

    public boolean isToggle() {
        return this.isToggle;
    }

    public boolean isToggleSelected() {
        return this.isToggleSelected;
    }

    public void setToggleSelected(boolean isToggleSelected) {
        if (!this.isToggle) {
            throw new IllegalArgumentException("This command is not toggle");
        }
        if (this.isToggleSelected != isToggleSelected) {
            this.isToggleSelected = isToggleSelected;
            this.weakPropertyChangeSupport.firePropertyChange("isToggleSelected", !this.isToggleSelected, this.isToggleSelected);
            this.fireStateChanged();
        }
    }

    public CommandToggleGroupModel getToggleGroupModel() {
        return this.toggleGroupModel;
    }

    public CommandActionPreview getActionPreview() {
        return this.actionPreview;
    }

    public void setActionPreview(CommandActionPreview actionPreview) {
        CommandActionPreview old = this.actionPreview;
        this.actionPreview = actionPreview;
        this.weakPropertyChangeSupport.firePropertyChange("actionPreview", old, this.actionPreview);
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.weakChangeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.weakChangeSupport.removeChangeListener(l);
    }

    private void fireStateChanged() {
        this.weakChangeSupport.fireStateChanged();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.weakPropertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.weakPropertyChangeSupport.removePropertyChangeListener(l);
    }

    public static abstract class BaseBuilder<T extends BaseCommand<MCM>, MCM extends BaseCommandMenuContentModel, B extends BaseBuilder<T, MCM, B>> {
        protected String text;
        protected String extraText;
        protected RadianceIcon.Factory iconFactory;
        protected CommandAction action;
        protected CommandActionPreview actionPreview;
        protected RichTooltip actionRichTooltip;
        protected MCM secondaryContentModel;
        protected SecondaryLifecycle secondaryLifecycle;
        protected RichTooltip secondaryRichTooltip;
        protected boolean isActionEnabled = true;
        protected boolean isSecondaryEnabled = true;
        protected boolean isToggle;
        protected boolean isToggleSelected;
        protected CommandToggleGroupModel toggleGroupModel;
        protected Object tag;

        protected void configureBaseCommand(BaseCommand<MCM> command) {
            ((BaseCommand)command).text = this.text;
            ((BaseCommand)command).iconFactory = this.iconFactory;
            ((BaseCommand)command).extraText = this.extraText;
            ((BaseCommand)command).action = this.action;
            ((BaseCommand)command).actionRichTooltip = this.actionRichTooltip;
            ((BaseCommand)command).secondaryContentModel = this.secondaryContentModel;
            ((BaseCommand)command).secondaryLifecycle = this.secondaryLifecycle;
            ((BaseCommand)command).secondaryRichTooltip = this.secondaryRichTooltip;
            ((BaseCommand)command).isActionEnabled = this.isActionEnabled;
            ((BaseCommand)command).isSecondaryEnabled = this.isSecondaryEnabled;
            ((BaseCommand)command).isToggle = this.isToggle;
            ((BaseCommand)command).isToggleSelected = this.isToggleSelected;
            ((BaseCommand)command).toggleGroupModel = this.toggleGroupModel;
            ((BaseCommand)command).actionPreview = this.actionPreview;
            if (((BaseCommand)command).toggleGroupModel != null) {
                ((BaseCommand)command).toggleGroupModel.add(command);
            }
            ((BaseCommand)command).tag = this.tag;
        }

        public abstract T build();

        public B setText(String text) {
            this.text = text;
            return (B)this;
        }

        public B setIconFactory(RadianceIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return (B)this;
        }

        public B setExtraText(String extraText) {
            this.extraText = extraText;
            return (B)this;
        }

        public B setAction(CommandAction action) {
            this.action = action;
            return (B)this;
        }

        public B setActionRichTooltip(RichTooltip actionRichTooltip) {
            this.actionRichTooltip = actionRichTooltip;
            return (B)this;
        }

        public B setSecondaryContentModel(MCM secondaryContentModel) {
            this.secondaryContentModel = secondaryContentModel;
            return (B)this;
        }

        public B setSecondaryLifecycle(SecondaryLifecycle secondaryLifecycle) {
            this.secondaryLifecycle = secondaryLifecycle;
            return (B)this;
        }

        public B setSecondaryRichTooltip(RichTooltip secondaryRichTooltip) {
            this.secondaryRichTooltip = secondaryRichTooltip;
            return (B)this;
        }

        public B setActionEnabled(boolean isActionEnabled) {
            this.isActionEnabled = isActionEnabled;
            return (B)this;
        }

        public B setSecondaryEnabled(boolean isSecondaryEnabled) {
            this.isSecondaryEnabled = isSecondaryEnabled;
            return (B)this;
        }

        public B setToggle() {
            this.isToggle = true;
            return (B)this;
        }

        public B setToggleSelected(boolean toggleSelected) {
            this.isToggle = true;
            this.isToggleSelected = toggleSelected;
            return (B)this;
        }

        public B inToggleGroup(CommandToggleGroupModel toggleGroup) {
            this.isToggle = true;
            this.toggleGroupModel = toggleGroup;
            return (B)this;
        }

        public B inToggleGroupAsSelected(CommandToggleGroupModel toggleGroup) {
            this.isToggle = true;
            this.isToggleSelected = true;
            this.toggleGroupModel = toggleGroup;
            return (B)this;
        }

        public B setActionPreview(CommandActionPreview actionPreview) {
            this.actionPreview = actionPreview;
            return (B)this;
        }

        public B setTag(Object tag) {
            this.tag = tag;
            return (B)this;
        }
    }

    public static interface SecondaryLifecycle {
        public void onBeforeActivateSecondary(JPopupPanel var1);

        public void onAfterActivateSecondary(JPopupPanel var1);

        public void onBeforeDeactivateSecondary(JPopupPanel var1);

        public void onAfterDeactivateSecondary(JPopupPanel var1);
    }

    public static interface CommandActionPreview
    extends EventListener {
        public void onCommandPreviewActivated(BaseCommand var1);

        public void onCommandPreviewCanceled(BaseCommand var1);
    }
}

