/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Map;
import org.pushingpixels.radiance.common.api.AsynchronousLoadListener;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;

public class IconDeckRadianceIcon<T>
implements RadianceIcon,
AsynchronousLoading {
    private RadianceIcon currentIcon;
    private final Map<T, ? extends RadianceIcon> iconDeck;

    public IconDeckRadianceIcon(Map<T, ? extends RadianceIcon> iconDeck) {
        if (iconDeck.isEmpty()) {
            throw new IllegalArgumentException("Icon deck is empty; must have at least one icon");
        }
        this.iconDeck = iconDeck;
        this.currentIcon = iconDeck.values().iterator().next();
    }

    public void setIcon(T key) {
        this.currentIcon = this.iconDeck.get(key);
    }

    public void setDimension(Dimension dim) {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            int currH = radianceIcon.getIconHeight();
            int currW = radianceIcon.getIconWidth();
            if (currH == dim.height && currW == dim.width) continue;
            radianceIcon.setDimension(dim);
        }
    }

    public boolean supportsColorFilter() {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            if (radianceIcon.supportsColorFilter()) continue;
            return false;
        }
        return true;
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            radianceIcon.setColorFilter(colorFilter);
        }
    }

    public int getIconHeight() {
        return this.currentIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.currentIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.currentIcon.paintIcon(c, g, x, y);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            if (!(radianceIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)radianceIcon).addAsynchronousLoadListener(l);
        }
    }

    public boolean isLoading() {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            if (!(radianceIcon instanceof AsynchronousLoading) || !((AsynchronousLoading)radianceIcon).isLoading()) continue;
            return true;
        }
        return false;
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (RadianceIcon radianceIcon : this.iconDeck.values()) {
            if (!(radianceIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)radianceIcon).removeAsynchronousLoadListener(l);
        }
    }
}

