/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pushingpixels.radiance.common.api.AsynchronousLoadListener;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;

public class DecoratedRadianceIcon
implements RadianceIcon,
AsynchronousLoading {
    private RadianceIcon delegate;
    private List<IconDecorator> decorators;

    public DecoratedRadianceIcon(RadianceIcon delegate, IconDecorator ... decorators) {
        this.delegate = delegate;
        this.decorators = new ArrayList<IconDecorator>();
        if (decorators != null) {
            this.decorators.addAll(Arrays.asList(decorators));
        }
    }

    public DecoratedRadianceIcon(RadianceIcon delegate) {
        this(delegate, new IconDecorator[]{null});
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.paintIcon(c, g, x, y);
        for (IconDecorator decorator : this.decorators) {
            decorator.paintIconDecoration(c, g, x, y, this.delegate.getIconWidth(), this.delegate.getIconHeight());
        }
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public boolean supportsColorFilter() {
        return this.delegate.supportsColorFilter();
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        this.delegate.setColorFilter(colorFilter);
    }

    public void addIconDecorator(IconDecorator decorator) {
        if (this.decorators.contains(decorator)) {
            return;
        }
        this.decorators.add(decorator);
    }

    public void removeIconDecorator(IconDecorator decorator) {
        this.decorators.remove(decorator);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        if (this.delegate instanceof AsynchronousLoading) {
            ((AsynchronousLoading)this.delegate).addAsynchronousLoadListener(l);
        }
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        if (this.delegate instanceof AsynchronousLoading) {
            ((AsynchronousLoading)this.delegate).removeAsynchronousLoadListener(l);
        }
    }

    public synchronized boolean isLoading() {
        if (this.delegate instanceof AsynchronousLoading && ((AsynchronousLoading)this.delegate).isLoading()) {
            return true;
        }
        for (IconDecorator decorator : this.decorators) {
            if (!(decorator instanceof AsynchronousLoading) || !((AsynchronousLoading)decorator).isLoading()) continue;
            return true;
        }
        return false;
    }

    public static RadianceIcon.Factory factory(RadianceIcon.Factory original, IconDecorator ... decorators) {
        return () -> new DecoratedRadianceIcon(original.createNewIcon(), decorators);
    }

    @FunctionalInterface
    public static interface IconDecorator {
        public void paintIconDecoration(Component var1, Graphics var2, int var3, int var4, int var5, int var6);
    }
}

