/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.common.api.model.DefaultTriStateButtonModel;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.RichTooltipManager;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.TriStateCheckBoxContentModel;
import org.pushingpixels.radiance.component.api.common.model.TriStateCheckboxPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceTriStateCheckBoxUI;

public class JTriStateCheckBox
extends JComponent
implements RichTooltipManager.WithRichTooltip {
    public static final String uiClassID = "TriStateCheckBoxUI";
    private Projection<JTriStateCheckBox, TriStateCheckBoxContentModel, TriStateCheckboxPresentationModel> projection;
    private TriStateCheckBoxContentModel contentModel;
    private TriStateCheckboxPresentationModel presentationModel;
    private TriStateButtonModel triStateButtonModel;

    public JTriStateCheckBox(Projection<JTriStateCheckBox, TriStateCheckBoxContentModel, TriStateCheckboxPresentationModel> projection) {
        this.projection = projection;
        this.contentModel = (TriStateCheckBoxContentModel)projection.getContentModel();
        this.presentationModel = (TriStateCheckboxPresentationModel)projection.getPresentationModel();
        this.triStateButtonModel = new DefaultTriStateButtonModel(this.contentModel.getSelectionCycler());
        this.triStateButtonModel.setEnabled(this.contentModel.isEnabled());
        this.triStateButtonModel.setSelectionState(this.contentModel.getSelectionState());
        RichTooltipManager.sharedInstance();
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceTriStateCheckBoxUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Projection<JTriStateCheckBox, TriStateCheckBoxContentModel, TriStateCheckboxPresentationModel> getProjection() {
        return this.projection;
    }

    public TriStateButtonModel getTriStateButtonModel() {
        return this.triStateButtonModel;
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.contentModel.getRichTooltip();
    }

    @Override
    public RichTooltipPresentationModel getRichTooltipPresentationModel(MouseEvent mouseEvent) {
        return this.presentationModel.getRichTooltipPresentationModel();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }
}

