/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.CommandActionEvent;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.PopupActionListener;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.RichTooltipManager;
import org.pushingpixels.radiance.component.api.common.RolloverActionListener;
import org.pushingpixels.radiance.component.api.common.model.ActionButtonModel;
import org.pushingpixels.radiance.component.api.common.model.ActionRepeatableButtonModel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.PopupButtonModel;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.BaseCommandButtonProjection;
import org.pushingpixels.radiance.component.internal.theming.common.ui.RadianceCommandButtonUI;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class JCommandButton
extends JComponent
implements RichTooltipManager.WithRichTooltip {
    public static final String uiClassID = "CommandButtonUI";
    private BaseCommandButtonProjection<? extends BaseCommand<?>, ? extends BaseCommandMenuContentModel, ? extends BaseCommandButtonPresentationModel<?, ?>, ? extends BaseCommandPopupMenuPresentationModel> projection;
    private BaseCommand command;
    private BaseCommandButtonPresentationModel commandPresentation;
    private ActionButtonModel actionModel;
    private CommandButtonPresentationState presentationState;
    private ActionHandler actionHandler;
    private PopupButtonModel popupModel;
    private PopupHandler popupHandler;

    public JCommandButton(BaseCommandButtonProjection<? extends BaseCommand<?>, ? extends BaseCommandMenuContentModel, ? extends BaseCommandButtonPresentationModel<?, ?>, ? extends BaseCommandPopupMenuPresentationModel> projection) {
        boolean hasAction;
        this.projection = projection;
        this.command = (BaseCommand)projection.getContentModel();
        this.commandPresentation = (BaseCommandButtonPresentationModel)projection.getPresentationModel();
        RadianceThemingCortex.ComponentScope.setIconFilterStrategies((JComponent)this, (RadianceThemingSlices.IconFilterStrategy)this.commandPresentation.getActiveIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)this.commandPresentation.getEnabledIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)this.commandPresentation.getDisabledIconFilterStrategy());
        boolean bl = hasAction = this.command.getAction() != null;
        if (hasAction) {
            this.addCommandListener(this.command.getAction());
        }
        if (!this.commandPresentation.isToDismissPopupsOnActivation()) {
            this.putClientProperty("radiance.component.internal.commandButton.ui.doNotDisposePopups", Boolean.TRUE);
        }
        this.setPresentationState(this.commandPresentation.getPresentationState());
        this.setFocusable(this.commandPresentation.isFocusable());
        this.actionHandler = new ActionHandler();
        this.setOpaque(false);
        ActionRepeatableButtonModel actionButtonModel = new ActionRepeatableButtonModel(this);
        actionButtonModel.setEnabled(this.command.isActionEnabled());
        actionButtonModel.setSelected(this.command.isToggleSelected());
        this.setActionModel(actionButtonModel);
        this.popupHandler = new PopupHandler();
        DefaultPopupButtonModel popupButtonModel = new DefaultPopupButtonModel(this);
        popupButtonModel.setEnabled(this.command.isSecondaryEnabled());
        this.setPopupModel(popupButtonModel);
        this.getActionModel().setFireActionOnPress(this.commandPresentation.getActionFireTrigger() == BaseCommandButtonPresentationModel.ActionFireTrigger.ON_PRESSED);
        if (this.command.getActionPreview() != null) {
            this.getActionModel().addChangeListener(new ChangeListener(){
                boolean wasRollover = false;

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean isRollover = JCommandButton.this.getActionModel().isRollover();
                    if (this.wasRollover && !isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewCanceled(JCommandButton.this.command);
                    }
                    if (!this.wasRollover && isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewActivated(JCommandButton.this.command);
                    }
                    this.wasRollover = isRollover;
                }
            });
        }
        RichTooltipManager.sharedInstance();
        this.updateUI();
        if (this.commandPresentation.getFont() != null) {
            this.setFont(this.commandPresentation.getFont());
        }
    }

    @Override
    public CommandButtonUI getUI() {
        return (CommandButtonUI)this.ui;
    }

    public BaseCommandButtonProjection<? extends BaseCommand<?>, ? extends BaseCommandMenuContentModel, ? extends BaseCommandButtonPresentationModel<?, ?>, ? extends BaseCommandPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    public BaseCommand<? extends BaseCommandMenuContentModel> getContentModel() {
        return (BaseCommand)this.projection.getContentModel();
    }

    public BaseCommandButtonPresentationModel<? extends BaseCommandPopupMenuPresentationModel, ? extends BaseCommandButtonPresentationModel<?, ?>> getPresentationModel() {
        return (BaseCommandButtonPresentationModel)this.projection.getPresentationModel();
    }

    public void setPresentationState(CommandButtonPresentationState state) {
        CommandButtonPresentationState old = this.presentationState;
        this.presentationState = state;
        this.firePropertyChange("presentationState", old, this.presentationState);
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public ActionButtonModel getActionModel() {
        return this.actionModel;
    }

    public void setActionModel(ActionButtonModel newModel) {
        ActionButtonModel oldModel = this.getActionModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.actionHandler);
            oldModel.removeActionListener(this.actionHandler);
        }
        this.actionModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.actionHandler);
            newModel.addActionListener(this.actionHandler);
        }
        this.firePropertyChange("actionModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addCommandListener(CommandAction l) {
        this.listenerList.add(CommandAction.class, l);
    }

    public void removeCommandListener(CommandAction l) {
        this.listenerList.remove(CommandAction.class, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(ce);
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        String actionCommand;
        int i;
        Object[] listeners = this.listenerList.getListenerList();
        CommandActionEvent e = null;
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandAction.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((CommandAction)listeners[i + 1]).commandActivated(e);
        }
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void doActionClick() {
        Dimension size = this.getSize();
        ActionButtonModel actionModel = this.getActionModel();
        actionModel.setArmed(true);
        actionModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        actionModel.setPressed(false);
        actionModel.setArmed(false);
    }

    @Override
    public void setToolTipText(String text) {
        throw new UnsupportedOperationException("Use rich tooltip APIs");
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceCommandButtonUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public PopupButtonModel getPopupModel() {
        return this.popupModel;
    }

    public void setPopupModel(PopupButtonModel newModel) {
        PopupButtonModel oldModel = this.getPopupModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.popupHandler);
            oldModel.removeActionListener(this.popupHandler);
        }
        this.popupModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.popupHandler);
            newModel.addActionListener(this.popupHandler);
        }
        this.firePropertyChange("popupModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.popupModel != null && !b && this.popupModel.isRollover()) {
            this.popupModel.setRollover(false);
        }
        if (this.actionModel != null && !b && this.actionModel.isRollover()) {
            this.actionModel.setRollover(false);
        }
        super.setEnabled(b);
        if (this.popupModel != null) {
            this.popupModel.setEnabled(b);
        }
        if (this.actionModel != null) {
            this.actionModel.setEnabled(b);
        }
    }

    protected void firePopupActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent event) {
        CommandButtonUI ui = this.getUI();
        if (ui.getLayoutInfo().actionClickArea.contains(event.getPoint())) {
            return this.command.getActionRichTooltip();
        }
        if (ui.getLayoutInfo().popupClickArea.contains(event.getPoint())) {
            return this.command.getSecondaryRichTooltip();
        }
        return null;
    }

    @Override
    public RichTooltipPresentationModel getRichTooltipPresentationModel(MouseEvent event) {
        CommandButtonUI ui = this.getUI();
        if (ui.getLayoutInfo().actionClickArea.contains(event.getPoint())) {
            return this.commandPresentation.getActionRichTooltipPresentationModel();
        }
        if (ui.getLayoutInfo().popupClickArea.contains(event.getPoint())) {
            return this.commandPresentation.getPopupRichTooltipPresentationModel();
        }
        return null;
    }

    public void doPopupClick() {
        Dimension size = this.getSize();
        PopupButtonModel popupModel = this.getPopupModel();
        popupModel.setArmed(true);
        popupModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        popupModel.setPressed(false);
        popupModel.setArmed(false);
        popupModel.setPopupShowing(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
    }

    public boolean isPopupVisible() {
        List<PopupPanelManager.PopupInfo> popupInfos = PopupPanelManager.defaultManager().getShownPath();
        for (PopupPanelManager.PopupInfo popupInfo : popupInfos) {
            if (popupInfo.getPopupOriginator() != this) continue;
            return true;
        }
        return false;
    }

    public void addRolloverActionListener(RolloverActionListener l) {
        this.listenerList.add(RolloverActionListener.class, l);
    }

    public void removeRolloverActionListener(RolloverActionListener l) {
        this.listenerList.remove(RolloverActionListener.class, l);
    }

    public void doActionRollover() {
        ActionEvent ae = new ActionEvent(this, 1001, this.getActionModel().getActionCommand());
        RolloverActionListener[] listeners = (RolloverActionListener[])this.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(ae);
        }
    }

    class PopupHandler
    implements PopupActionListener,
    ChangeListener {
        PopupHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.firePopupActionPerformed(event);
        }
    }

    class ActionHandler
    implements ActionListener,
    ChangeListener {
        ActionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.fireActionPerformed(event);
        }
    }

    private static class DefaultPopupButtonModel
    extends DefaultButtonModel
    implements PopupButtonModel {
        public static final int POPUP_SHOWING = 256;
        private JCommandButton commandButton;

        public DefaultPopupButtonModel(JCommandButton commandButton) {
            this.commandButton = commandButton;
        }

        @Override
        public void addPopupActionListener(PopupActionListener l) {
            this.listenerList.add(PopupActionListener.class, l);
        }

        @Override
        public void removePopupActionListener(PopupActionListener l) {
            this.listenerList.remove(PopupActionListener.class, l);
        }

        protected void firePopupActionPerformed(ActionEvent e) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PopupActionListener.class) continue;
                ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
            }
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.commandButton.getUI().setInnerFocusOnAction(false);
                this.firePopupActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
            this.fireStateChanged();
        }

        @Override
        public boolean isPopupShowing() {
            return (this.stateMask & 0x100) != 0;
        }

        @Override
        public void setPopupShowing(boolean b) {
            if (this.isPopupShowing() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 0x100) : (this.stateMask &= 0xFFFFFEFF);
            this.fireStateChanged();
        }
    }
}

