/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.util.Collection;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.utils.KeyTipManager;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class KeyTipRenderingUtilities {
    public static Dimension getPrefSize(FontMetrics fm, String keyTip) {
        int INSETS = 3;
        int prefWidth = fm.stringWidth(keyTip) + 2 * INSETS + 1;
        int prefHeight = fm.getHeight() + INSETS - 1;
        return new Dimension(prefWidth, prefHeight);
    }

    public static void renderKeyTip(Graphics g, Container c, Rectangle rect, String keyTip, boolean toPaintEnabled) {
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter((Component)c);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)c);
        ComponentState state = toPaintEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float alpha = RadianceColorSchemeUtilities.getAlpha((Component)c, (ComponentState)state);
        RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme((Component)c, (ComponentState)state);
        RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme((Component)c, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)state);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, (float)alpha, (Graphics)g));
        graphics.translate(rect.x, rect.y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)rect.width, (int)rect.height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float radius = (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius((int)RadianceSizeUtils.getComponentFontSize((Component)c));
            Shape contour = RadianceOutlineUtilities.getBaseOutline((float)scaledWidth, (float)scaledHeight, (float)radius, null, (float)1.0f);
            fillPainter.paintContourBackground((Graphics)graphics1X, (Component)c, (float)scaledWidth, (float)scaledHeight, contour, fillScheme);
            Shape contourInner = RadianceOutlineUtilities.getBaseOutline((float)scaledWidth, (float)scaledHeight, (float)radius, null, (float)2.0f);
            borderPainter.paintBorder((Graphics)graphics1X, (Component)c, (float)scaledWidth, (float)scaledHeight, contour, contourInner, borderScheme);
        });
        graphics.setColor(RadianceColorSchemeUtilities.getColorScheme((Component)c, (ComponentState)state).getForegroundColor());
        Font font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        font = font.deriveFont((float)font.getSize() + 1.0f);
        graphics.setFont(font);
        int strWidth = graphics.getFontMetrics().stringWidth(keyTip);
        LineMetrics lineMetrics = graphics.getFontMetrics().getLineMetrics(keyTip, graphics);
        int strHeight = (int)lineMetrics.getHeight();
        RadianceCommonCortex.installDesktopHints((Graphics2D)graphics, (Font)font);
        graphics.drawString(keyTip, (rect.width - strWidth) / 2, (rect.height + strHeight) / 2 - graphics.getFontMetrics().getDescent());
        graphics.dispose();
    }

    public static void renderButtonKeyTips(Graphics g, JCommandButton button, CommandButtonLayoutManager layoutManager) {
        Collection<KeyTipManager.KeyTipLink> currLinks = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
        if (currLinks == null) {
            return;
        }
        boolean found = false;
        for (KeyTipManager.KeyTipLink link : currLinks) {
            found = link.comp == button;
            if (!found) continue;
            break;
        }
        if (!found) {
            return;
        }
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = layoutManager.getLayoutInfo(button);
        String actionKeyTip = button.getActionKeyTip();
        if (layoutInfo.actionClickArea.width > 0 && actionKeyTip != null) {
            Point actionPrefCenter = button.getUI().getActionKeyTipAnchorCenterPoint();
            Dimension pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), actionKeyTip);
            KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle(actionPrefCenter.x - pref.width / 2, Math.min(actionPrefCenter.y - pref.height / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height - pref.height), pref.width, pref.height), actionKeyTip, button.getActionModel().isEnabled());
        }
        String popupKeyTip = button.getPopupKeyTip();
        if (layoutInfo.popupClickArea.width > 0 && popupKeyTip != null) {
            Point popupPrefCenter = button.getUI().getPopupKeyTipAnchorCenterPoint();
            Dimension pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), popupKeyTip);
            KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle(popupPrefCenter.x - pref.width / 2, Math.min(popupPrefCenter.y - pref.height / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height - pref.height), pref.width, pref.height), popupKeyTip, button.getPopupModel().isEnabled());
        }
    }
}

