/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.radiance.component.internal.ui.common.RadianceInternalButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class JRibbonApplicationMenuButton
extends JCommandButton
implements RadianceInternalButton {
    private static final CommandButtonPresentationState APP_MENU_BUTTON_STATE = new CommandButtonPresentationState("Ribbon Application Menu Button", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
            return new CommandButtonLayoutManager(){

                @Override
                public int getPreferredIconSize(JCommandButton commandButton) {
                    return 0;
                }

                @Override
                public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
                    CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
                    result.actionClickArea = new Rectangle(0, 0, 0, 0);
                    result.popupActionRect = new Rectangle(0, 0, 0, 0);
                    result.isTextInActionArea = false;
                    FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
                    int labelHeight = fm.getAscent() + fm.getDescent();
                    int availableWidth = commandButton.getWidth();
                    int textWidth = fm.stringWidth(commandButton.getText());
                    CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                    lineLayoutInfo.text = commandButton.getText();
                    lineLayoutInfo.textRect = new Rectangle();
                    result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                    result.textLayoutInfoList.add(lineLayoutInfo);
                    lineLayoutInfo.textRect.x = (availableWidth - textWidth) / 2;
                    lineLayoutInfo.textRect.y = (commandButton.getHeight() - labelHeight) / 2;
                    lineLayoutInfo.textRect.width = textWidth;
                    lineLayoutInfo.textRect.height = labelHeight;
                    result.popupClickArea = new Rectangle(0, 0, availableWidth, commandButton.getHeight());
                    return result;
                }

                @Override
                public Dimension getPreferredSize(JCommandButton commandButton) {
                    return new Dimension(40, 20);
                }

                @Override
                public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
                    return null;
                }

                @Override
                public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
                    return new Point(commandButton.getWidth() / 2, commandButton.getHeight());
                }
            };
        }
    };

    public JRibbonApplicationMenuButton(RibbonApplicationMenuCommandButtonProjection ribbonApplicationMenuCommandProjection) {
        super(ribbonApplicationMenuCommandProjection.reproject(CommandButtonPresentationModel.builder().setPresentationState(APP_MENU_BUTTON_STATE).setHorizontalAlignment(0).build()));
    }
}

