/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerMenuTileLevel1
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(JCommandButton commandButton) {
        return ComponentUtilities.getScaledSize(32, commandButton.getFont().getSize(), 2.0, 4);
    }

    @Override
    public Dimension getPreferredSize(JCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        JSeparator jsep = new JSeparator(1);
        int titleWidth = fm.stringWidth(commandButton.getText());
        int layoutHGap = 2 * ComponentUtilities.getHLayoutGap(commandButton);
        int layoutVGap = 2 * ComponentUtilities.getVLayoutGap(commandButton);
        int widthMed = this.getPreferredIconSize(commandButton) + 2 * layoutHGap + jsep.getPreferredSize().width + titleWidth + (ComponentUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 + 4 * layoutHGap + jsep.getPreferredSize().width : 0);
        return new Dimension(bx + widthMed, by + Math.max(this.getPreferredIconSize(commandButton), 2 * (fm.getAscent() + fm.getDescent()) + layoutVGap));
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.iconRect.x + layoutInfo.iconRect.width, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
        }
        return new Point(layoutInfo.iconRect.x, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.popupActionRect.x, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
        }
        return new Point(layoutInfo.popupActionRect.x + layoutInfo.popupActionRect.width, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
            result.isTextInActionArea = false;
        }
        JSeparator jsep = new JSeparator(1);
        int layoutHGap = 2 * ComponentUtilities.getHLayoutGap(commandButton);
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        RadianceIcon buttonIcon = commandButton.getIcon();
        if (ltr) {
            int x;
            result.iconRect.x = x = ins.left;
            result.iconRect.y = (height - buttonIcon.getIconHeight()) / 2;
            result.iconRect.width = buttonIcon.getIconWidth();
            result.iconRect.height = buttonIcon.getIconHeight();
            x += commandButton.getIcon().getIconWidth();
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = x + layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = x + layoutHGap;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = width - x - layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = commandButton.getText();
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.x = x += 2 * layoutHGap + jsep.getPreferredSize().width;
            lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            lineLayoutInfo.textRect.width = fm.stringWidth(commandButton.getText());
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            x += fm.stringWidth(commandButton.getText());
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = width - ins.right - labelHeight;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = labelHeight + ins.right;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = width - ins.right - labelHeight;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (ComponentUtilities.hasPopupAction(commandButton)) {
                result.popupActionRect.x = width - ins.right - labelHeight * 3 / 4;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
            }
        } else {
            int x = commandButton.getWidth() - ins.right;
            result.iconRect.x = x - buttonIcon.getIconWidth();
            result.iconRect.y = (height - buttonIcon.getIconHeight()) / 2;
            result.iconRect.width = buttonIcon.getIconWidth();
            result.iconRect.height = buttonIcon.getIconHeight();
            x -= commandButton.getIcon().getIconWidth();
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = x + layoutHGap;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - x - layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = x + layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = commandButton.getText();
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.width = fm.stringWidth(commandButton.getText());
            lineLayoutInfo.textRect.x = (x -= 2 * layoutHGap + jsep.getPreferredSize().width) - lineLayoutInfo.textRect.width;
            lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = labelHeight + ins.left;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = ins.left + labelHeight;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = labelHeight + ins.left;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (ComponentUtilities.hasPopupAction(commandButton)) {
                result.popupActionRect.x = ins.left + labelHeight / 4;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
            }
        }
        return result;
    }
}

