/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;

public class SequentialFocusTraversalPolicy
extends FocusTraversalPolicy {
    private List<Component> componentSequence = new ArrayList<Component>();

    public SequentialFocusTraversalPolicy(List<? extends Component> componentSequence) {
        this.componentSequence.addAll(componentSequence);
    }

    @Override
    public Component getFirstComponent(Container container) {
        for (int index = 0; index < this.componentSequence.size(); ++index) {
            Component curr = this.componentSequence.get(index);
            if (!curr.isEnabled() || !curr.isFocusable() || !curr.isVisible()) continue;
            return curr;
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container container) {
        for (int index = this.componentSequence.size() - 1; index >= 0; --index) {
            Component curr = this.componentSequence.get(index);
            if (!curr.isEnabled() || !curr.isFocusable() || !curr.isVisible()) continue;
            return curr;
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        int startIndex = this.componentSequence.indexOf(component) + 1;
        if (startIndex == this.componentSequence.size()) {
            return null;
        }
        for (int index = startIndex; index < this.componentSequence.size(); ++index) {
            Component curr = this.componentSequence.get(index);
            if (!curr.isEnabled() || !curr.isFocusable() || !curr.isVisible()) continue;
            return curr;
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        int startIndex = this.componentSequence.indexOf(component) - 1;
        if (startIndex == -1) {
            return null;
        }
        for (int index = startIndex; index >= 0; --index) {
            Component curr = this.componentSequence.get(index);
            if (!curr.isEnabled() || !curr.isFocusable() || !curr.isVisible()) continue;
            return curr;
        }
        return null;
    }
}

