/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public abstract class BasicRibbonTaskToggleButtonUI
extends BasicCommandButtonUI {
    private PopupPanelManager.PopupListener popupListener;

    @Override
    protected void installDefaults() {
        Border border;
        super.installDefaults();
        Font f = this.commandButton.getFont();
        if (f == null || f instanceof UIResource) {
            this.commandButton.setFont(RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
        }
        if ((border = this.commandButton.getBorder()) == null || border instanceof UIResource) {
            BorderUIResource.EmptyBorderUIResource toInstall = new BorderUIResource.EmptyBorderUIResource(1, 12, 1, 12);
            this.commandButton.setBorder(toInstall);
        }
        this.commandButton.setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            private boolean isTaskSelected() {
                JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, BasicRibbonTaskToggleButtonUI.this.commandButton);
                if (ribbon == null) {
                    return false;
                }
                return ribbon.getSelectedTask() == ((JRibbonTaskToggleButton)BasicRibbonTaskToggleButtonUI.this.commandButton).getRibbonTask();
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
    }

    @Override
    protected void uninstallListeners() {
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        super.uninstallListeners();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JRibbonTaskToggleButton b = (JRibbonTaskToggleButton)c;
        RadianceIcon icon = b.getIcon();
        String text = "Www";
        Font font = b.getFont();
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)b), (Font)font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, (Icon)icon, 0, b.getHorizontalAlignment(), 0, 0, viewR, iconR, textR, text == null ? 0 : 6);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += 4;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }
}

