/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerSmall
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(JCommandButton commandButton) {
        return ComponentUtilities.getCommandButtonSmallIconSize(commandButton.getFont().getSize());
    }

    @Override
    public Dimension getPreferredSize(JCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int layoutHGap = ComponentUtilities.getHLayoutGap(commandButton);
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasPopupIcon = ComponentUtilities.hasPopupAction(commandButton);
        int prefIconSize = hasIcon ? this.getPreferredIconSize(commandButton) : 0;
        int width = borderInsets.left;
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        if (hasPopupIcon) {
            width += 2 * layoutHGap;
            width += 1 + fm.getHeight() / 2;
            width += 2 * layoutHGap;
        }
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        if (hasIcon && buttonKind.hasAction() && buttonKind.hasPopup()) {
            width += new JSeparator((int)1).getPreferredSize().width;
        }
        width += borderInsets.right;
        return new Dimension(width -= 2 * layoutHGap, by + Math.max(prefIconSize, fm.getAscent() + fm.getDescent()));
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width, (height + layoutInfo.actionClickArea.height) / 2);
        }
        return new Point(layoutInfo.actionClickArea.x, (height + layoutInfo.actionClickArea.height) / 2);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width, (height + layoutInfo.popupClickArea.height) / 2);
        }
        return new Point(layoutInfo.popupClickArea.x, (height + layoutInfo.popupClickArea.height) / 2);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        RadianceIcon buttonIcon;
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int prefWidth = this.getPreferredSize((JCommandButton)commandButton).width;
        int shiftX = 0;
        if (width > prefWidth) {
            switch (commandButton.getHorizontalAlignment()) {
                case 10: {
                    break;
                }
                case 0: {
                    shiftX = (width - prefWidth) / 2;
                    break;
                }
                case 11: {
                    shiftX = width - prefWidth;
                }
            }
        }
        boolean hasIcon = (buttonIcon = commandButton.getIcon()) != null;
        boolean hasPopupIcon = ComponentUtilities.hasPopupAction(commandButton);
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        int layoutHGap = ComponentUtilities.getHLayoutGap(commandButton);
        if (ltr) {
            int x = ins.left + shiftX - layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = x += layoutHGap;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x += iconWidth + layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.x = x += 2 * layoutHGap;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
                x += result.popupActionRect.width;
                x += 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: 
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.iconRect.x + result.iconRect.width + layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        } else {
            int x = width - ins.right - shiftX + layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = (x -= layoutHGap) - iconWidth;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x -= iconWidth + layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.x = (x -= 2 * layoutHGap) - result.popupActionRect.width;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.height = labelHeight + 2;
                x -= result.popupActionRect.width;
                x -= 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: 
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.iconRect.x - layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        }
        return result;
    }
}

