/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerBig
implements CommandButtonLayoutManager {
    private JCommandButton commandButton;
    protected String titlePart1;
    protected String titlePart2;

    public CommandButtonLayoutManagerBig(JCommandButton commandButton) {
        this.commandButton = commandButton;
        this.updateTitleStrings();
    }

    @Override
    public int getPreferredIconSize(JCommandButton commandButton) {
        return ComponentUtilities.getScaledSize(32, commandButton.getFont().getSize(), 2.0, 4);
    }

    protected int getCurrentIconWidth(JCommandButton commandButton) {
        return commandButton.getIcon() != null ? this.getPreferredIconSize(commandButton) : 0;
    }

    protected int getCurrentIconHeight(JCommandButton commandButton) {
        return commandButton.getIcon() != null ? this.getPreferredIconSize(commandButton) : 0;
    }

    @Override
    public Dimension getPreferredSize(JCommandButton commandButton) {
        Insets borderInsets = commandButton == null ? new Insets(0, 0, 0, 0) : commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        JSeparator jsep = new JSeparator(0);
        int layoutHGap = ComponentUtilities.getHLayoutGap(commandButton);
        int layoutVGap = ComponentUtilities.getVLayoutGap(commandButton);
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasText = this.titlePart1 != null;
        boolean hasPopupIcon = ComponentUtilities.hasPopupAction(commandButton);
        int title1Width = this.titlePart1 == null ? 0 : fm.stringWidth(this.titlePart1);
        int title2Width = this.titlePart2 == null ? 0 : fm.stringWidth(this.titlePart2);
        int width = Math.max(this.getCurrentIconWidth(commandButton), Math.max(title1Width, title2Width + 4 * layoutHGap + jsep.getPreferredSize().height + (ComponentUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 : 0)));
        int height = borderInsets.top;
        if (hasIcon) {
            height += layoutVGap;
            height += this.getCurrentIconHeight(commandButton);
            height += layoutVGap;
        }
        if (hasText) {
            height += layoutVGap;
            height += 2 * (fm.getAscent() + fm.getDescent());
            height += layoutVGap;
        }
        if (!hasText && hasPopupIcon) {
            height += layoutVGap;
            height += fm.getHeight();
            height += layoutVGap;
        }
        JCommandButton.CommandButtonKind buttonKind = this.commandButton.getCommandButtonKind();
        if (hasIcon && buttonKind.hasAction() && buttonKind.hasPopup()) {
            height += new JSeparator((int)0).getPreferredSize().height;
        }
        height += borderInsets.bottom;
        return new Dimension(bx + width, height -= 2 * layoutVGap);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName()) || "font".equals(evt.getPropertyName())) {
            this.updateTitleStrings();
        }
    }

    private void updateTitleStrings() {
        String title;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)this.commandButton), (Font)this.commandButton.getFont());
        String string = title = this.commandButton == null ? null : this.commandButton.getText();
        if (title != null) {
            StringTokenizer tokenizer = new StringTokenizer(title, " _-", true);
            if (tokenizer.countTokens() <= 1) {
                this.titlePart1 = title;
                this.titlePart2 = null;
            } else {
                int actionIconWidth = ComponentUtilities.hasPopupAction(this.commandButton) ? 0 : 2 * ComponentUtilities.getHLayoutGap(this.commandButton) + (fm.getAscent() + fm.getDescent()) / 2;
                int currMaxLength = fm.stringWidth(this.commandButton.getText()) + actionIconWidth;
                StringBuilder currLeading = new StringBuilder();
                while (tokenizer.hasMoreTokens()) {
                    int len2;
                    currLeading.append(tokenizer.nextToken());
                    String part1 = currLeading.toString();
                    String part2 = title.substring(currLeading.length());
                    int len1 = fm.stringWidth(part1);
                    int len = Math.max(len1, len2 = fm.stringWidth(part2) + actionIconWidth);
                    if (currMaxLength <= len) continue;
                    currMaxLength = len;
                    this.titlePart1 = part1;
                    this.titlePart2 = part2;
                }
            }
        } else {
            this.titlePart1 = null;
            this.titlePart2 = null;
        }
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int x = ins.left;
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        RadianceIcon buttonIcon = commandButton.getIcon();
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasText = this.titlePart1 != null;
        boolean hasPopupIcon = ComponentUtilities.hasPopupAction(commandButton);
        int layoutHGap = ComponentUtilities.getHLayoutGap(commandButton);
        int layoutVGap = ComponentUtilities.getVLayoutGap(commandButton);
        int prefHeight = this.getPreferredSize((JCommandButton)commandButton).height;
        int shiftY = 0;
        if (height > prefHeight) {
            shiftY = (height - prefHeight) / 2;
        }
        int y = ins.top + shiftY - layoutVGap;
        if (hasIcon) {
            int iconHeight = buttonIcon.getIconHeight();
            int iconWidth = buttonIcon.getIconWidth();
            result.iconRect.x = (width - iconWidth) / 2;
            result.iconRect.y = y += layoutVGap;
            result.iconRect.width = iconWidth;
            result.iconRect.height = iconHeight;
            y += iconHeight + layoutVGap;
        }
        if (hasIcon && buttonKind.hasAction() && buttonKind.hasPopup()) {
            result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL;
            result.separatorArea = new Rectangle(0, 0, 0, 0);
            result.separatorArea.x = 0;
            result.separatorArea.y = y;
            result.separatorArea.width = width;
            result.separatorArea.height = new JSeparator((int)0).getPreferredSize().height;
            y += result.separatorArea.height;
        }
        int lastTextLineWidth = 0;
        if (hasText) {
            int extraWidth;
            y += layoutVGap;
            lastTextLineWidth = this.titlePart1 != null ? fm.stringWidth(this.titlePart1) : 0;
            CommandButtonLayoutManager.TextLayoutInfo line1LayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            line1LayoutInfo.text = this.titlePart1;
            line1LayoutInfo.textRect = new Rectangle();
            line1LayoutInfo.textRect.x = ins.left + (width - lastTextLineWidth - ins.left - ins.right) / 2;
            line1LayoutInfo.textRect.y = y;
            line1LayoutInfo.textRect.width = lastTextLineWidth;
            line1LayoutInfo.textRect.height = labelHeight;
            if (this.titlePart1 != null) {
                y += labelHeight;
            }
            lastTextLineWidth = this.titlePart2 != null ? fm.stringWidth(this.titlePart2) : 0;
            int n = extraWidth = hasPopupIcon ? 4 * layoutHGap + labelHeight / 2 : 0;
            if (ltr) {
                x = ins.left + (width - lastTextLineWidth - extraWidth - ins.left - ins.right) / 2;
            }
            if (!ltr) {
                x = width - ins.right - lastTextLineWidth - (width - lastTextLineWidth - extraWidth - ins.left - ins.right) / 2;
            }
            CommandButtonLayoutManager.TextLayoutInfo line2LayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            line2LayoutInfo.text = this.titlePart2;
            line2LayoutInfo.textRect = new Rectangle();
            line2LayoutInfo.textRect.x = x;
            line2LayoutInfo.textRect.y = y;
            line2LayoutInfo.textRect.width = lastTextLineWidth;
            line2LayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(line1LayoutInfo);
            result.textLayoutInfoList.add(line2LayoutInfo);
        }
        if (hasPopupIcon) {
            if (lastTextLineWidth > 0) {
                if (ltr) {
                    x += 2 * layoutHGap;
                    x += lastTextLineWidth;
                } else {
                    x -= 2 * layoutHGap;
                    x -= labelHeight / 2;
                }
            } else {
                x = (width - 1 - labelHeight / 2) / 2;
            }
            result.popupActionRect.x = x;
            result.popupActionRect.y = y - 1;
            result.popupActionRect.width = 1 + labelHeight / 2;
            result.popupActionRect.height = labelHeight + 2;
        }
        switch (buttonKind) {
            case ACTION_ONLY: {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width;
                result.actionClickArea.height = height;
                result.isTextInActionArea = true;
                break;
            }
            case POPUP_ONLY: {
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = width;
                result.popupClickArea.height = height;
                result.isTextInActionArea = false;
                break;
            }
            case ACTION_AND_POPUP_MAIN_ACTION: 
            case ACTION_AND_POPUP_MAIN_POPUP: {
                if (hasIcon) {
                    int yBorderBetweenActionAndPopupAreas = result.separatorArea.y;
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = yBorderBetweenActionAndPopupAreas;
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = yBorderBetweenActionAndPopupAreas;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height - yBorderBetweenActionAndPopupAreas;
                } else {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                }
                result.isTextInActionArea = false;
            }
        }
        return result;
    }
}

