/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.RichTooltipPresentationModel;
import org.pushingpixels.radiance.component.internal.ui.common.JRichTooltipPanel;
import org.pushingpixels.radiance.component.internal.ui.common.RichTooltipPanelUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceBorder;

public abstract class BasicRichTooltipPanelUI
extends RichTooltipPanelUI {
    protected JRichTooltipPanel richTooltipPanel;
    private List<JLabel> titleLabels = new ArrayList<JLabel>();
    private List<JLabel> descriptionLabels = new ArrayList<JLabel>();
    private JLabel mainImageLabel;
    private JSeparator footerSeparator;
    private JLabel footerImageLabel;
    private List<JLabel> footerLabels = new ArrayList<JLabel>();

    @Override
    public void installUI(JComponent c) {
        this.richTooltipPanel = (JRichTooltipPanel)c;
        super.installUI(this.richTooltipPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.richTooltipPanel.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.richTooltipPanel);
    }

    protected void installDefaults() {
        Border b = this.richTooltipPanel.getBorder();
        if ((b == null || b instanceof UIResource) && this.richTooltipPanel.getTooltipPresentationModel() != null) {
            this.richTooltipPanel.setBorder((Border)new RadianceBorder(this.richTooltipPanel.getTooltipPresentationModel().getContentPadding()));
        }
        LookAndFeel.installProperty(this.richTooltipPanel, "opaque", Boolean.TRUE);
        Font f = this.richTooltipPanel.getFont();
        if (f == null || f instanceof UIResource) {
            this.richTooltipPanel.setFont(RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
        }
    }

    protected void installListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.richTooltipPanel);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallComponents() {
        this.removeExistingComponents();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paintBackground(g);
        this.paint(g, c);
    }

    protected abstract void paintBackground(Graphics var1);

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    private LayoutManager createLayoutManager() {
        return new RichTooltipPanelLayout();
    }

    private int getDescriptionTextWidth() {
        return ComponentUtilities.getScaledSize(200, this.richTooltipPanel.getFont().getSize(), 40.0, 4);
    }

    private int getLayoutGap() {
        return 4;
    }

    private void removeExistingComponents() {
        for (JLabel label : this.titleLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.mainImageLabel != null) {
            this.richTooltipPanel.remove(this.mainImageLabel);
        }
        for (JLabel label : this.descriptionLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.footerSeparator != null) {
            this.richTooltipPanel.remove(this.footerSeparator);
        }
        if (this.footerImageLabel != null) {
            this.richTooltipPanel.remove(this.footerImageLabel);
        }
        for (JLabel label : this.footerLabels) {
            this.richTooltipPanel.remove(label);
        }
    }

    private class RichTooltipPanelLayout
    implements LayoutManager {
        private RichTooltipPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            TextLayout tl;
            Insets ins = parent.getInsets();
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
            Font titleFont = font.deriveFont(1);
            int descTextWidth = BasicRichTooltipPanelUI.this.getDescriptionTextWidth();
            int width = ins.left + 2 * gap + descTextWidth + ins.right;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            RichTooltipPresentationModel tooltipPresentationModel = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipPresentationModel();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            if (tooltipInfo.getMainIcon() != null) {
                width += tooltipPresentationModel.getMainIconSize();
            }
            int fontHeight = parent.getFontMetrics(font).getHeight();
            int height = ins.top;
            int titleTextHeight = 0;
            AttributedString titleAttributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAttributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAttributedDescription.getIterator(), frc);
            int maxTitleLineWidth = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                titleTextHeight += fontHeight;
                int lineWidth = (int)Math.ceil(tl.getBounds().getWidth());
                maxTitleLineWidth = Math.max(maxTitleLineWidth, lineWidth);
            }
            height += titleTextHeight;
            int descriptionTextHeight = 0;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString descAttributedDescription = new AttributedString(descText);
                descAttributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer descLineBreakMeasurer = new LineBreakMeasurer(descAttributedDescription.getIterator(), frc);
                while ((tl2 = descLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                    descriptionTextHeight += fontHeight;
                }
                descriptionTextHeight += fontHeight;
            }
            if (!tooltipInfo.getDescriptionSections().isEmpty()) {
                descriptionTextHeight -= fontHeight;
                descriptionTextHeight += gap;
            }
            height = tooltipInfo.getMainIcon() != null ? (height += Math.max(descriptionTextHeight, tooltipPresentationModel.getMainIconSize())) : (height += descriptionTextHeight);
            if (tooltipInfo.getFooterIcon() != null || tooltipInfo.getFooterSections().size() > 0) {
                height += gap;
                height += new JSeparator((int)0).getPreferredSize().height;
                height += gap;
                int footerTextHeight = 0;
                int availableWidth = descTextWidth;
                if (tooltipInfo.getFooterIcon() != null) {
                    availableWidth -= tooltipPresentationModel.getFooterIconSize();
                }
                if (tooltipInfo.getMainIcon() != null) {
                    availableWidth += tooltipPresentationModel.getMainIconSize();
                }
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString footerAttributedDescription = new AttributedString(footerText);
                    footerAttributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer footerLineBreakMeasurer = new LineBreakMeasurer(footerAttributedDescription.getIterator(), frc);
                    while ((tl3 = footerLineBreakMeasurer.nextLayout(availableWidth)) != null) {
                        footerTextHeight += fontHeight;
                    }
                    footerTextHeight += fontHeight;
                }
                height = tooltipInfo.getFooterIcon() != null ? (height += Math.max(footerTextHeight, tooltipPresentationModel.getFooterIconSize())) : (height += (footerTextHeight -= fontHeight));
            }
            height += ins.bottom;
            if (tooltipInfo.getDescriptionSections().isEmpty() && tooltipInfo.getMainIcon() == null && tooltipInfo.getFooterSections().isEmpty() && tooltipInfo.getFooterIcon() == null) {
                width = maxTitleLineWidth + 1 + ins.left + ins.right;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            TextLayout tl;
            if (parent.getWidth() == 1 || parent.getHeight() == 1) {
                return;
            }
            BasicRichTooltipPanelUI.this.removeExistingComponents();
            FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
            Insets ins = BasicRichTooltipPanelUI.this.richTooltipPanel.getInsets();
            int y = ins.top;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            RichTooltipPresentationModel tooltipPresentationModel = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipPresentationModel();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            int fontHeight = parent.getFontMetrics(font).getHeight();
            Font titleFont = font.deriveFont(1);
            boolean ltr = BasicRichTooltipPanelUI.this.richTooltipPanel.getComponentOrientation().isLeftToRight();
            int titleLabelWidth = parent.getWidth() - ins.left - ins.right;
            AttributedString titleAtributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAtributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAtributedDescription.getIterator(), frc);
            int titleCurrOffset = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(titleLabelWidth)) != null) {
                int charCount = tl.getCharacterCount();
                String line = tooltipInfo.getTitle().substring(titleCurrOffset, titleCurrOffset + charCount);
                JLabel titleLabel = new JLabel(line);
                titleLabel.setFont(titleFont);
                BasicRichTooltipPanelUI.this.titleLabels.add(titleLabel);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(titleLabel);
                int currLabelWidth = titleLabel.getPreferredSize().width;
                if (ltr) {
                    titleLabel.setBounds(ins.left, y, currLabelWidth, fontHeight);
                } else {
                    titleLabel.setBounds(parent.getWidth() - ins.right - currLabelWidth, y, currLabelWidth, fontHeight);
                }
                y += titleLabel.getHeight();
                titleCurrOffset += charCount;
            }
            y += gap;
            int x = ltr ? ins.left : parent.getWidth() - ins.right;
            RadianceIcon mainIcon = tooltipInfo.getMainIcon();
            if (mainIcon != null) {
                mainIcon.setDimension(new Dimension(tooltipPresentationModel.getMainIconSize(), tooltipPresentationModel.getMainIconSize()));
                BasicRichTooltipPanelUI.this.mainImageLabel = new JLabel((Icon)mainIcon);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.mainImageLabel);
                int mainImageWidth = ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).mainImageLabel.getPreferredSize().width;
                if (ltr) {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x, y, mainImageWidth, ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).mainImageLabel.getPreferredSize().height);
                    x += mainImageWidth;
                } else {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x - mainImageWidth, y, mainImageWidth, ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).mainImageLabel.getPreferredSize().height);
                    x -= mainImageWidth;
                }
            }
            x = ltr ? (x += 2 * gap) : (x -= 2 * gap);
            int descLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString attributedDescription = new AttributedString(descText);
                attributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                int currOffset = 0;
                while ((tl2 = lineBreakMeasurer.nextLayout(descLabelWidth)) != null) {
                    int charCount = tl2.getCharacterCount();
                    String line = descText.substring(currOffset, currOffset + charCount);
                    JLabel descLabel = new JLabel(line);
                    BasicRichTooltipPanelUI.this.descriptionLabels.add(descLabel);
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(descLabel);
                    int currDescWidth = descLabel.getPreferredSize().width;
                    if (ltr) {
                        descLabel.setBounds(x, y, currDescWidth, fontHeight);
                    } else {
                        descLabel.setBounds(x - currDescWidth, y, currDescWidth, fontHeight);
                    }
                    y += descLabel.getHeight();
                    currOffset += charCount;
                }
                y += fontHeight;
            }
            y -= fontHeight;
            if (BasicRichTooltipPanelUI.this.mainImageLabel != null) {
                y = Math.max(y, BasicRichTooltipPanelUI.this.mainImageLabel.getY() + BasicRichTooltipPanelUI.this.mainImageLabel.getHeight());
            }
            if (tooltipInfo.getFooterIcon() != null || tooltipInfo.getFooterSections().size() > 0) {
                BasicRichTooltipPanelUI.this.footerSeparator = new JSeparator(0);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerSeparator);
                BasicRichTooltipPanelUI.this.footerSeparator.setBounds(ins.left, y += gap, parent.getWidth() - ins.left - ins.right, ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).footerSeparator.getPreferredSize().height);
                y += BasicRichTooltipPanelUI.this.footerSeparator.getHeight() + gap;
                int n = x = ltr ? ins.left : parent.getWidth() - ins.right;
                if (tooltipInfo.getFooterIcon() != null) {
                    tooltipInfo.getFooterIcon().setDimension(new Dimension(tooltipPresentationModel.getFooterIconSize(), tooltipPresentationModel.getFooterIconSize()));
                    BasicRichTooltipPanelUI.this.footerImageLabel = new JLabel((Icon)tooltipInfo.getFooterIcon());
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerImageLabel);
                    int footerImageWidth = ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).footerImageLabel.getPreferredSize().width;
                    if (ltr) {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x, y, footerImageWidth, ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).footerImageLabel.getPreferredSize().height);
                        x += footerImageWidth + 2 * gap;
                    } else {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x - footerImageWidth, y, footerImageWidth, ((BasicRichTooltipPanelUI)BasicRichTooltipPanelUI.this).footerImageLabel.getPreferredSize().height);
                        x -= footerImageWidth + 2 * gap;
                    }
                }
                int footerLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString attributedDescription = new AttributedString(footerText);
                    attributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                    int currOffset = 0;
                    while ((tl3 = lineBreakMeasurer.nextLayout(footerLabelWidth)) != null) {
                        int charCount = tl3.getCharacterCount();
                        String line = footerText.substring(currOffset, currOffset + charCount);
                        JLabel footerLabel = new JLabel(line);
                        BasicRichTooltipPanelUI.this.footerLabels.add(footerLabel);
                        BasicRichTooltipPanelUI.this.richTooltipPanel.add(footerLabel);
                        int currLabelWidth = footerLabel.getPreferredSize().width;
                        if (ltr) {
                            footerLabel.setBounds(x, y, currLabelWidth, fontHeight);
                        } else {
                            footerLabel.setBounds(x - currLabelWidth, y, currLabelWidth, fontHeight);
                        }
                        y += footerLabel.getHeight();
                        currOffset += charCount;
                    }
                    y += fontHeight;
                }
                y -= fontHeight;
            }
        }
    }
}

