/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JCommandButtonPanel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelColumnFillSpec;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelLayoutSpec;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelRowFillSpec;
import org.pushingpixels.radiance.component.internal.ui.common.CommandButtonPanelUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public abstract class BasicCommandButtonPanelUI
extends CommandButtonPanelUI {
    public static final String SKIP_BACKGROUND_FILL = "radiance.component.internal.commandButtonPanel.ui.skipBackgroundFill";
    protected JCommandButtonPanel buttonPanel;
    protected JLabel[] groupLabels;
    private Rectangle[] groupRects;
    private ChangeListener contentModelChangeListener;
    private ChangeListener presentationModelChangeListener;
    private CommandButtonPanelLayout layoutManager;
    protected static final Insets GROUP_INSETS = new Insets(4, 4, 4, 4);

    @Override
    public void installUI(JComponent c) {
        this.buttonPanel = (JCommandButtonPanel)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installDefaults() {
        this.updateLayoutManager();
        Font currFont = this.buttonPanel.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            FontUIResource controlFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
            this.buttonPanel.setFont(controlFont.deriveFont(1, controlFont.getSize() + 1));
        }
    }

    protected void installComponents() {
        this.recomputeGroupHeaders();
    }

    protected void installListeners() {
        this.presentationModelChangeListener = event -> SwingUtilities.invokeLater(() -> {
            if (this.buttonPanel != null) {
                this.recomputeGroupHeaders();
                int groupCount = this.groupLabels != null ? this.groupLabels.length : 0;
                CommandPanelPresentationModel presentationModel = (CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel();
                for (int i = 0; i < groupCount; ++i) {
                    for (JCommandButton button : this.buttonPanel.getGroupButtons(i)) {
                        button.setIconDimension(presentationModel.getCommandIconDimension());
                        button.setContentPadding(presentationModel.getCommandContentPadding());
                        button.setPresentationState(presentationModel.getCommandPresentationState());
                        button.setHGapScaleFactor(presentationModel.getCommandHorizontalGapScaleFactor());
                        button.setVGapScaleFactor(presentationModel.getCommandVerticalGapScaleFactor());
                        button.setBackgroundAppearanceStrategy(presentationModel.getBackgroundAppearanceStrategy());
                        RadianceThemingCortex.ComponentScope.setIconFilterStrategies((JComponent)button, (RadianceThemingSlices.IconFilterStrategy)presentationModel.getActiveIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)presentationModel.getEnabledIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)presentationModel.getDisabledIconFilterStrategy());
                    }
                }
                this.updateLayoutManager();
                this.buttonPanel.revalidate();
                this.buttonPanel.doLayout();
            }
        });
        ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).addChangeListener(this.presentationModelChangeListener);
        this.contentModelChangeListener = changeEvent -> SwingUtilities.invokeLater(() -> {
            if (this.buttonPanel != null) {
                this.recomputeGroupHeaders();
                this.buttonPanel.revalidate();
                this.buttonPanel.doLayout();
            }
        });
        ((CommandPanelContentModel)this.buttonPanel.getProjection().getContentModel()).addChangeListener(this.contentModelChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.buttonPanel = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        if (this.groupLabels != null) {
            for (JLabel groupLabel : this.groupLabels) {
                this.buttonPanel.remove(groupLabel);
            }
        }
    }

    protected void uninstallListeners() {
        ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).removeChangeListener(this.presentationModelChangeListener);
        this.presentationModelChangeListener = null;
        ((CommandPanelContentModel)this.buttonPanel.getProjection().getContentModel()).removeChangeListener(this.contentModelChangeListener);
        this.contentModelChangeListener = null;
    }

    private void updateLayoutManager() {
        CommandPanelPresentationModel panelPresentationModel = (CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel();
        this.layoutManager = panelPresentationModel != null && panelPresentationModel.getLayoutSpec() instanceof PanelLayoutSpec.ColumnFill ? new ColumnFillLayout() : new RowFillLayout();
        this.buttonPanel.setLayout(this.layoutManager);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean skipBackgroundFill = Boolean.TRUE.equals(this.buttonPanel.getClientProperty(SKIP_BACKGROUND_FILL));
        if (!skipBackgroundFill) {
            Color bg = this.buttonPanel.getBackground();
            g.setColor(bg);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        int groupCount = this.groupLabels != null ? this.groupLabels.length : 0;
        Insets contentInsets = ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).getContentPadding();
        for (int i = 0; i < groupCount; ++i) {
            Rectangle groupRect = this.groupRects[i];
            if (groupRect == null) continue;
            if (!skipBackgroundFill) {
                this.paintGroupBackground(g, i, groupRect.x, groupRect.y, groupRect.width, groupRect.height);
            }
            if (!this.groupLabels[i].isVisible()) continue;
            Rectangle groupTitleBackground = this.groupLabels[i].getBounds();
            this.paintGroupTitleBackground(g, i, groupRect.x, groupTitleBackground.y - contentInsets.top, groupRect.width, groupTitleBackground.height + contentInsets.top + ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).getContentGap());
        }
    }

    protected abstract void paintGroupBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void paintGroupTitleBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract int getGroupTitleHeight(int var1);

    private void recomputeGroupHeaders() {
        if (this.groupLabels != null) {
            for (JLabel groupLabel : this.groupLabels) {
                this.buttonPanel.remove(groupLabel);
            }
        }
        int groupCount = this.buttonPanel.getGroupCount();
        this.groupLabels = new JLabel[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            this.groupLabels[i] = new JLabel(this.buttonPanel.getGroupTitleAt(i));
            this.groupLabels[i].setComponentOrientation(this.buttonPanel.getComponentOrientation());
            this.buttonPanel.add(this.groupLabels[i]);
            this.groupLabels[i].setVisible(((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).isToShowGroupLabels());
        }
    }

    public int getPreferredHeight(int buttonVisibleRows, int titleVisibleRows) {
        Insets bInsets = this.buttonPanel.getInsets();
        Insets contentPadding = ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).getContentPadding();
        int maxButtonHeight = 0;
        int groupCount = this.buttonPanel.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            for (JCommandButton button : this.buttonPanel.getGroupButtons(i)) {
                maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
            }
        }
        int gap = ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).getContentGap();
        int totalHeight = bInsets.top + bInsets.bottom;
        totalHeight += buttonVisibleRows * maxButtonHeight;
        totalHeight += (buttonVisibleRows - 1) * gap;
        totalHeight += titleVisibleRows * this.getGroupTitleHeight(0);
        return totalHeight += (titleVisibleRows - 1) * (contentPadding.top + contentPadding.bottom);
    }

    private JCommandButton findFirstFocusableRight(int row, int column) {
        for (int currColumn = column + 1; currColumn < this.layoutManager.commandButtonGridColumnCount; ++currColumn) {
            JCommandButton currButton = this.layoutManager.commandButtonGrid[row][currColumn];
            if (currButton == null || !currButton.isFocusable()) continue;
            return currButton;
        }
        return null;
    }

    private JCommandButton findLastFocusableLeft(int row, int column) {
        for (int currColumn = column - 1; currColumn >= 0; --currColumn) {
            JCommandButton currButton = this.layoutManager.commandButtonGrid[row][currColumn];
            if (currButton == null || !currButton.isFocusable()) continue;
            return currButton;
        }
        return null;
    }

    private JCommandButton findLastFocusableUp(int row, int column) {
        for (int currRow = row - 1; currRow >= 0; --currRow) {
            JCommandButton currButton = this.layoutManager.commandButtonGrid[currRow][column];
            if (currButton == null || !currButton.isFocusable()) continue;
            return currButton;
        }
        return null;
    }

    private JCommandButton findFirstFocusableDown(int row, int column) {
        for (int currRow = row + 1; currRow < this.layoutManager.commandButtonGridRowCount; ++currRow) {
            JCommandButton currButton = this.layoutManager.commandButtonGrid[currRow][column];
            if (currButton == null || !currButton.isFocusable()) continue;
            return currButton;
        }
        return null;
    }

    @Override
    public boolean focusFirst() {
        JCommandButton first = this.findFirstFocusableRight(0, -1);
        if (first != null) {
            first.requestFocus();
            this.buttonPanel.scrollRectToVisible(first.getBounds());
            return true;
        }
        return false;
    }

    @Override
    public boolean focusLast() {
        JCommandButton last = this.findLastFocusableLeft(this.layoutManager.commandButtonGridRowCount - 1, this.layoutManager.commandButtonGridColumnCount);
        if (last != null) {
            last.requestFocus();
            this.buttonPanel.scrollRectToVisible(last.getBounds());
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFocus() {
        for (int row = 0; row < this.layoutManager.commandButtonGridRowCount; ++row) {
            for (int column = 0; column < this.layoutManager.commandButtonGridColumnCount; ++column) {
                JCommandButton button = this.layoutManager.commandButtonGrid[row][column];
                if (button == null || !button.hasFocus()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean focusMove(FocusMoveDirection focusMoveDirection) {
        int focusedRow = -1;
        int focusedColumn = -1;
        for (int row = 0; row < this.layoutManager.commandButtonGridRowCount; ++row) {
            for (int column = 0; column < this.layoutManager.commandButtonGridColumnCount; ++column) {
                JCommandButton button = this.layoutManager.commandButtonGrid[row][column];
                if (button == null || !button.hasFocus()) continue;
                focusedRow = row;
                focusedColumn = column;
            }
        }
        if (focusedRow < 0) {
            return false;
        }
        switch (focusMoveDirection) {
            case DOWN: {
                JCommandButton nextDown = this.findFirstFocusableDown(focusedRow, focusedColumn);
                if (nextDown != null && nextDown.isFocusable()) {
                    nextDown.requestFocus();
                    this.buttonPanel.scrollRectToVisible(nextDown.getBounds());
                    return true;
                }
                return false;
            }
            case UP: {
                JCommandButton nextUp = this.findLastFocusableUp(focusedRow, focusedColumn);
                if (nextUp != null && nextUp.isFocusable()) {
                    nextUp.requestFocus();
                    this.buttonPanel.scrollRectToVisible(nextUp.getBounds());
                    return true;
                }
                return false;
            }
            case RIGHT: {
                JCommandButton nextRight = this.findFirstFocusableRight(focusedRow, focusedColumn);
                if (nextRight != null && nextRight.isFocusable()) {
                    nextRight.requestFocus();
                    this.buttonPanel.scrollRectToVisible(nextRight.getBounds());
                    return true;
                }
                return false;
            }
            case LEFT: {
                JCommandButton nextLeft = this.findLastFocusableLeft(focusedRow, focusedColumn);
                if (nextLeft != null && nextLeft.isFocusable()) {
                    nextLeft.requestFocus();
                    this.buttonPanel.scrollRectToVisible(nextLeft.getBounds());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean focusUp() {
        return this.focusMove(FocusMoveDirection.UP);
    }

    @Override
    public boolean focusDown() {
        return this.focusMove(FocusMoveDirection.DOWN);
    }

    @Override
    public boolean focusRight() {
        return this.focusMove(FocusMoveDirection.RIGHT);
    }

    @Override
    public boolean focusLeft() {
        return this.focusMove(FocusMoveDirection.LEFT);
    }

    static /* synthetic */ Rectangle[] access$102(BasicCommandButtonPanelUI x0, Rectangle[] x1) {
        x0.groupRects = x1;
        return x1;
    }

    private static enum FocusMoveDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    protected class ColumnFillLayout
    extends CommandButtonPanelLayout {
        protected ColumnFillLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currColumnIndex;
            int x;
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            Insets bInsets = parent.getInsets();
            Insets contentPadding = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentPadding();
            int top = bInsets.top;
            int bottom = bInsets.bottom;
            boolean ltr = panel.getComponentOrientation().isLeftToRight();
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (JCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            BasicCommandButtonPanelUI.access$102(BasicCommandButtonPanelUI.this, new Rectangle[groupCount]);
            int gap = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentGap();
            int maxHeight = parent.getHeight() - bInsets.top - bInsets.bottom - contentPadding.top - contentPadding.bottom;
            CommandPanelPresentationModel panelPresentationModel = (CommandPanelPresentationModel)panel.getProjection().getPresentationModel();
            PanelLayoutSpec.ColumnFill panelLayoutSpec = (PanelLayoutSpec.ColumnFill)panelPresentationModel.getLayoutSpec();
            PanelColumnFillSpec panelColumnFillSpec = panelLayoutSpec.getColumnFillSpec();
            int maxButtonRowsToUse = panelColumnFillSpec instanceof PanelColumnFillSpec.Fixed ? ((PanelColumnFillSpec.Fixed)panelColumnFillSpec).getRowCount() : maxHeight / (((PanelColumnFillSpec.Adaptive)panelColumnFillSpec).getMinRowHeight() + gap);
            int totalColumnCount = 0;
            for (int i = 0; i < groupCount; ++i) {
                int buttonColumns = maxButtonRowsToUse == 0 ? 0 : (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonRowsToUse);
                totalColumnCount += buttonColumns;
            }
            this.setCommandButtonGridSize(maxButtonRowsToUse, totalColumnCount);
            if (totalColumnCount == 0) {
                return;
            }
            if (ltr) {
                x = bInsets.left + contentPadding.left;
                currColumnIndex = 0;
                for (int i = 0; i < groupCount; ++i) {
                    int leftGroupX = x;
                    x += contentPadding.left;
                    int currY = top + contentPadding.top;
                    int buttonColumns = maxButtonRowsToUse == 0 ? 0 : (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonRowsToUse);
                    int actualButtonHeight = buttonColumns > 1 ? (maxHeight - (maxButtonRowsToUse - 1) * gap) / maxButtonRowsToUse : maxButtonHeight;
                    int currRowIndex = 0;
                    for (JCommandButton button : panel.getGroupButtons(i)) {
                        int endY = currY + actualButtonHeight;
                        if (endY > parent.getHeight() - bottom - contentPadding.bottom) {
                            currY = top + contentPadding.top;
                            currRowIndex = 0;
                            ++currColumnIndex;
                            x += maxButtonWidth;
                            x += gap;
                        }
                        button.setBounds(x, currY, maxButtonWidth, actualButtonHeight);
                        this.commandButtonGrid[currRowIndex][currColumnIndex] = button;
                        ++currRowIndex;
                        currY += actualButtonHeight;
                        currY += gap;
                    }
                    ++currColumnIndex;
                    int rightGroupX = x += maxButtonWidth + contentPadding.bottom;
                    ((BasicCommandButtonPanelUI)BasicCommandButtonPanelUI.this).groupRects[i] = new Rectangle(leftGroupX, top, rightGroupX - leftGroupX, parent.getHeight() - top - bottom);
                }
            } else {
                x = panel.getWidth() - bInsets.right - contentPadding.right;
                currColumnIndex = this.commandButtonGridColumnCount - 1;
                for (int i = 0; i < groupCount; ++i) {
                    int rightGroupX = x;
                    x -= contentPadding.left;
                    int currY = top + contentPadding.top;
                    int buttonColumns = maxButtonRowsToUse == 0 ? 0 : (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonRowsToUse);
                    int actualButtonHeight = buttonColumns > 1 ? (maxHeight - (maxButtonRowsToUse - 1) * gap) / maxButtonRowsToUse : maxButtonHeight;
                    int currRowIndex = 0;
                    for (JCommandButton button : panel.getGroupButtons(i)) {
                        int endY = currY + actualButtonHeight;
                        if (endY > parent.getHeight() - bottom - contentPadding.bottom) {
                            currY = top + contentPadding.top;
                            currRowIndex = 0;
                            --currColumnIndex;
                            x -= maxButtonWidth;
                            x -= gap;
                        }
                        button.setBounds(x - maxButtonWidth, currY, maxButtonWidth, actualButtonHeight);
                        this.commandButtonGrid[currRowIndex][currColumnIndex] = button;
                        ++currRowIndex;
                        currY += actualButtonHeight;
                        currY += gap;
                    }
                    --currColumnIndex;
                    int leftGroupX = x -= maxButtonWidth + contentPadding.bottom;
                    ((BasicCommandButtonPanelUI)BasicCommandButtonPanelUI.this).groupRects[i] = new Rectangle(leftGroupX, top, rightGroupX - leftGroupX, parent.getHeight() - top - bottom);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(20, 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            boolean usePanelHeight;
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            Insets bInsets = parent.getInsets();
            Insets contentPadding = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentPadding();
            int insetsHeight = bInsets.top + contentPadding.top + bInsets.bottom + contentPadding.bottom;
            int availableHeight = panel.getHeight();
            availableHeight -= insetsHeight;
            int gap = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentGap();
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = panel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (JCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            CommandPanelPresentationModel panelPresentationModel = (CommandPanelPresentationModel)panel.getProjection().getPresentationModel();
            PanelLayoutSpec.ColumnFill panelLayoutSpec = (PanelLayoutSpec.ColumnFill)panelPresentationModel.getLayoutSpec();
            PanelColumnFillSpec panelColumnFillSpec = panelLayoutSpec.getColumnFillSpec();
            int maxButtonRowsToUse = panelColumnFillSpec instanceof PanelColumnFillSpec.Fixed ? ((PanelColumnFillSpec.Fixed)panelColumnFillSpec).getRowCount() : availableHeight / (((PanelColumnFillSpec.Adaptive)panelColumnFillSpec).getMinRowHeight() + gap);
            boolean bl = usePanelHeight = maxButtonRowsToUse <= 0;
            if (usePanelHeight) {
                maxButtonRowsToUse = (availableHeight + gap) / (maxButtonHeight + gap);
            }
            int width = bInsets.left + bInsets.right;
            for (int i = 0; i < groupCount; ++i) {
                width += contentPadding.left + contentPadding.right;
                int buttonColumns = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonRowsToUse);
                width += buttonColumns * maxButtonWidth + (buttonColumns - 1) * gap;
            }
            int prefHeight = usePanelHeight ? availableHeight : maxButtonRowsToUse * maxButtonHeight + (maxButtonRowsToUse - 1) * gap + bInsets.top + bInsets.bottom + contentPadding.top + contentPadding.bottom;
            return new Dimension(Math.max(10, width), Math.max(10, prefHeight));
        }
    }

    protected class RowFillLayout
    extends CommandButtonPanelLayout {
        protected RowFillLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getWidth() <= 0 || parent.getHeight() <= 0) {
                return;
            }
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            Insets bInsets = panel.getInsets();
            Insets contentPadding = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentPadding();
            int left = bInsets.left;
            int right = bInsets.right;
            int y = bInsets.top;
            boolean ltr = panel.getComponentOrientation().isLeftToRight();
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = BasicCommandButtonPanelUI.this.groupLabels != null ? BasicCommandButtonPanelUI.this.groupLabels.length : 0;
            for (int i = 0; i < groupCount; ++i) {
                for (JCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            BasicCommandButtonPanelUI.access$102(BasicCommandButtonPanelUI.this, new Rectangle[groupCount]);
            int gap = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentGap();
            int maxWidth = parent.getWidth() - bInsets.left - bInsets.right - contentPadding.left - contentPadding.right;
            int buttonsInRow = maxButtonWidth == 0 ? 0 : (maxWidth + gap) / (maxButtonWidth + gap);
            CommandPanelPresentationModel panelPresentationModel = (CommandPanelPresentationModel)panel.getProjection().getPresentationModel();
            PanelLayoutSpec.RowFill panelLayoutSpec = (PanelLayoutSpec.RowFill)panelPresentationModel.getLayoutSpec();
            PanelRowFillSpec panelRowFillSpec = panelLayoutSpec.getRowFillSpec();
            int maxButtonColumnsToUse = panelRowFillSpec instanceof PanelRowFillSpec.Fixed ? ((PanelRowFillSpec.Fixed)panelRowFillSpec).getColumnCount() : maxWidth / (((PanelRowFillSpec.Adaptive)panelRowFillSpec).getMinColumnWidth() + gap);
            if (maxButtonColumnsToUse > 0) {
                buttonsInRow = Math.min(buttonsInRow, maxButtonColumnsToUse);
            }
            buttonsInRow = Math.max(buttonsInRow, 1);
            int totalRowCount = 0;
            for (int i = 0; i < groupCount; ++i) {
                int buttonRows = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)buttonsInRow);
                totalRowCount += buttonRows;
            }
            this.setCommandButtonGridSize(totalRowCount, buttonsInRow);
            if (totalRowCount == 0) {
                return;
            }
            int currRowIndex = 0;
            for (int i = 0; i < groupCount; ++i) {
                int currColumnIndex;
                int currX;
                int actualButtonWidth;
                int topGroupY = y;
                y += contentPadding.top;
                JLabel groupLabel = BasicCommandButtonPanelUI.this.groupLabels[i];
                if (((CommandPanelPresentationModel)BasicCommandButtonPanelUI.this.buttonPanel.getProjection().getPresentationModel()).isToShowGroupLabels()) {
                    int labelWidth = groupLabel.getPreferredSize().width;
                    int labelHeight = BasicCommandButtonPanelUI.this.getGroupTitleHeight(i);
                    if (groupLabel.getComponentOrientation().isLeftToRight()) {
                        groupLabel.setBounds(left + contentPadding.left, y, labelWidth, labelHeight);
                    } else {
                        groupLabel.setBounds(parent.getWidth() - right - contentPadding.right - labelWidth, y, labelWidth, labelHeight);
                    }
                    y += labelHeight + gap;
                }
                int buttonRows = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)buttonsInRow);
                if (maxButtonColumnsToUse > 0) {
                    buttonsInRow = Math.min(buttonsInRow, maxButtonColumnsToUse);
                }
                int n = actualButtonWidth = buttonRows > 1 ? (maxWidth - (buttonsInRow - 1) * gap) / buttonsInRow : maxButtonWidth;
                if (maxButtonColumnsToUse == 1) {
                    actualButtonWidth = maxWidth;
                }
                if (ltr) {
                    currX = left + contentPadding.left;
                    currColumnIndex = 0;
                    for (JCommandButton button : panel.getGroupButtons(i)) {
                        int endX = currX + actualButtonWidth;
                        if (endX > parent.getWidth() - right - contentPadding.right) {
                            ++currRowIndex;
                            currColumnIndex = 0;
                            currX = left + contentPadding.left;
                            y += maxButtonHeight;
                            y += gap;
                        }
                        button.setBounds(currX, y, actualButtonWidth, maxButtonHeight);
                        this.commandButtonGrid[currRowIndex][currColumnIndex] = button;
                        ++currColumnIndex;
                        currX += actualButtonWidth;
                        currX += gap;
                    }
                } else {
                    currX = parent.getWidth() - right - contentPadding.right;
                    currColumnIndex = buttonsInRow - 1;
                    for (JCommandButton button : panel.getGroupButtons(i)) {
                        int startX = currX - actualButtonWidth;
                        if (startX < left + contentPadding.left) {
                            ++currRowIndex;
                            currColumnIndex = buttonsInRow - 1;
                            currX = parent.getWidth() - right - contentPadding.right;
                            y += maxButtonHeight;
                            y += gap;
                        }
                        button.setBounds(currX - actualButtonWidth, y, actualButtonWidth, maxButtonHeight);
                        this.commandButtonGrid[currRowIndex][currColumnIndex] = button;
                        --currColumnIndex;
                        currX -= actualButtonWidth;
                        currX -= gap;
                    }
                }
                ++currRowIndex;
                int bottomGroupY = y += maxButtonHeight + contentPadding.bottom;
                ((BasicCommandButtonPanelUI)BasicCommandButtonPanelUI.this).groupRects[i] = new Rectangle(left, topGroupY, parent.getWidth() - left - right, bottomGroupY - topGroupY);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(20, 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            boolean usePanelWidth;
            JCommandButtonPanel panel = (JCommandButtonPanel)parent;
            Insets bInsets = parent.getInsets();
            Insets contentPadding = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentPadding();
            int insetsWidth = bInsets.left + contentPadding.left + bInsets.right + contentPadding.right;
            int availableWidth = panel.getWidth();
            availableWidth -= insetsWidth;
            int gap = ((CommandPanelPresentationModel)panel.getProjection().getPresentationModel()).getContentGap();
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = BasicCommandButtonPanelUI.this.groupLabels != null ? BasicCommandButtonPanelUI.this.groupLabels.length : 0;
            for (int i = 0; i < groupCount; ++i) {
                for (JCommandButton button : panel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            CommandPanelPresentationModel panelPresentationModel = (CommandPanelPresentationModel)panel.getProjection().getPresentationModel();
            PanelLayoutSpec.RowFill panelLayoutSpec = (PanelLayoutSpec.RowFill)panelPresentationModel.getLayoutSpec();
            PanelRowFillSpec panelRowFillSpec = panelLayoutSpec.getRowFillSpec();
            int maxButtonColumnsToUse = panelRowFillSpec instanceof PanelRowFillSpec.Fixed ? ((PanelRowFillSpec.Fixed)panelRowFillSpec).getColumnCount() : availableWidth / (((PanelRowFillSpec.Adaptive)panelRowFillSpec).getMinColumnWidth() + gap);
            boolean bl = usePanelWidth = maxButtonColumnsToUse <= 0;
            if (usePanelWidth) {
                maxButtonColumnsToUse = (availableWidth + gap) / (maxButtonWidth + gap);
                maxButtonColumnsToUse = Math.max(1, maxButtonColumnsToUse);
            }
            int height = bInsets.top + bInsets.bottom;
            for (int i = 0; i < groupCount; ++i) {
                if (BasicCommandButtonPanelUI.this.groupLabels[i].isVisible()) {
                    height += BasicCommandButtonPanelUI.this.getGroupTitleHeight(i) + gap;
                }
                height += contentPadding.top + contentPadding.bottom;
                int buttonRows = (int)Math.ceil((double)panel.getGroupButtons(i).size() / (double)maxButtonColumnsToUse);
                height += buttonRows * maxButtonHeight + (buttonRows - 1) * gap;
            }
            int prefWidth = usePanelWidth ? availableWidth : maxButtonColumnsToUse * maxButtonWidth + (maxButtonColumnsToUse - 1) * gap + bInsets.left + bInsets.right + contentPadding.left + contentPadding.right;
            return new Dimension(Math.max(10, prefWidth), Math.max(10, height));
        }
    }

    private static abstract class CommandButtonPanelLayout
    implements LayoutManager {
        protected int commandButtonGridRowCount = -1;
        protected int commandButtonGridColumnCount = -1;
        protected JCommandButton[][] commandButtonGrid;

        private CommandButtonPanelLayout() {
        }

        protected void setCommandButtonGridSize(int rowCount, int columnCount) {
            if (this.commandButtonGrid == null || this.commandButtonGridRowCount != rowCount || this.commandButtonGridColumnCount != columnCount) {
                this.commandButtonGridRowCount = rowCount;
                this.commandButtonGridColumnCount = columnCount;
                this.commandButtonGrid = new JCommandButton[this.commandButtonGridRowCount][this.commandButtonGridColumnCount];
            }
        }
    }
}

