/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.bcb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarContentModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbBarPresentationModel;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbItem;
import org.pushingpixels.radiance.component.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.radiance.component.api.bcb.JBreadcrumbBar;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCircularProgress;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.api.common.icon.EmptyRadianceIcon;
import org.pushingpixels.radiance.component.api.common.model.CircularProgressContentModel;
import org.pushingpixels.radiance.component.api.common.model.CircularProgressPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.PopupButtonModel;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CircularProgressProjection;
import org.pushingpixels.radiance.component.internal.ui.bcb.BreadcrumbBarUI;
import org.pushingpixels.radiance.component.internal.ui.bcb.BreadcrumbItemChoices;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public abstract class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    private JBreadcrumbBar<Object> breadcrumbBar;
    private JCircularProgress circularProgress;
    private JPanel mainPanel;
    private JScrollablePanel<JPanel> scrollerPanel;
    private ComponentListener componentListener;
    private JCommandButton forSizing;
    private LinkedList<Object> modelStack;
    private LinkedList<JCommandButton> buttonStack;
    private LinkedList<Command> commandStack;
    private BreadcrumbPathListener<Object> pathListener;
    private AtomicInteger atomicCounter;
    private Timer loadingTimer;
    private boolean isShowingProgress;
    private SwingWorker<Void, Object> pathChangeWorker;

    @Override
    public void installUI(JComponent c) {
        this.breadcrumbBar = (JBreadcrumbBar)c;
        this.modelStack = new LinkedList();
        this.buttonStack = new LinkedList();
        this.commandStack = new LinkedList();
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        c.setLayout(this.createLayoutManager());
        if (this.breadcrumbBar.getContentModel().getItemCount() > 0) {
            this.startLoadingTimer();
            if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                this.pathChangeWorker.cancel(true);
            }
            this.initAndRunPathChangeWorker(0);
        } else if (this.breadcrumbBar.getContentProvider() != null) {
            SwingWorker<List<BreadcrumbItem<Object>>, Void> worker = new SwingWorker<List<BreadcrumbItem<Object>>, Void>(){

                @Override
                protected List<BreadcrumbItem<Object>> doInBackground() throws Exception {
                    BasicBreadcrumbBarUI.this.startLoadingTimer();
                    return BasicBreadcrumbBarUI.this.breadcrumbBar.getContentProvider().getPathChoices(null);
                }

                @Override
                protected void done() {
                    try {
                        BasicBreadcrumbBarUI.this.stopLoadingTimer();
                        BasicBreadcrumbBarUI.this.pushChoices(new BreadcrumbItemChoices<Object>(null, (List)this.get()));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(System.err);
                    }
                }
            };
            worker.execute();
        }
        this.forSizing = (JCommandButton)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText("Text")).setIconFactory(EmptyRadianceIcon.factory())).setAction(commandActionEvent -> {})).build().project(CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).build()).buildComponent();
        int preferredHeight = this.forSizing.getPreferredSize().height;
        this.circularProgress.setBorder(new EmptyBorder((preferredHeight - 12) / 2, 10, (preferredHeight - 12) / 2, 10));
        this.circularProgress.setPreferredSize(new Dimension(32, preferredHeight));
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((JBreadcrumbBar)c);
        this.uninstallComponents((JBreadcrumbBar)c);
        this.uninstallDefaults((JBreadcrumbBar)c);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(JBreadcrumbBar<?> bar) {
        Font currFont = bar.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            bar.setFont(RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
        }
    }

    protected void installComponents(JBreadcrumbBar<?> bar) {
        FlowLayout mainPanelLayout = new FlowLayout(0, 0, 0);
        mainPanelLayout.setAlignOnBaseline(true);
        this.mainPanel = new JPanel(mainPanelLayout);
        this.mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new JScrollablePanel<JPanel>(this.mainPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.circularProgress = (JCircularProgress)new CircularProgressProjection(CircularProgressContentModel.builder().build(), CircularProgressPresentationModel.builder().setSize(12).build()).buildComponent();
        bar.add(this.scrollerPanel, "Center");
    }

    protected void installListeners(JBreadcrumbBar<?> bar) {
        this.atomicCounter = new AtomicInteger(0);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        bar.addComponentListener(this.componentListener);
        this.pathListener = event -> {
            this.startLoadingTimer();
            if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                this.pathChangeWorker.cancel(true);
            }
            this.initAndRunPathChangeWorker(event.getIndexOfFirstChange());
        };
        this.breadcrumbBar.getContentModel().addPathListener(this.pathListener);
    }

    private void initAndRunPathChangeWorker(final int indexOfFirstChange) {
        this.pathChangeWorker = new SwingWorker<Void, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                List items;
                BasicBreadcrumbBarUI.this.atomicCounter.incrementAndGet();
                BasicBreadcrumbBarUI basicBreadcrumbBarUI = BasicBreadcrumbBarUI.this;
                synchronized (basicBreadcrumbBarUI) {
                    if (indexOfFirstChange == 0) {
                        BasicBreadcrumbBarUI.this.modelStack.clear();
                    } else {
                        int toLeave = indexOfFirstChange * 2 + 1;
                        while (BasicBreadcrumbBarUI.this.modelStack.size() > toLeave) {
                            BasicBreadcrumbBarUI.this.modelStack.removeLast();
                        }
                    }
                }
                SwingUtilities.invokeLater(BasicBreadcrumbBarUI.this::updateComponents);
                if (indexOfFirstChange == 0) {
                    List rootChoices = BasicBreadcrumbBarUI.this.breadcrumbBar.getContentProvider().getPathChoices(null);
                    BreadcrumbItemChoices bic = new BreadcrumbItemChoices(null, rootChoices);
                    if (!this.isCancelled()) {
                        this.publish(bic);
                    }
                }
                if ((items = BasicBreadcrumbBarUI.this.breadcrumbBar.getContentModel().getItems()) != null) {
                    for (int itemIndex = indexOfFirstChange; itemIndex < items.size() && !this.isCancelled(); ++itemIndex) {
                        BreadcrumbItem item = items.get(itemIndex);
                        this.publish(item);
                        ArrayList subPath = new ArrayList();
                        for (int j = 0; j <= itemIndex; ++j) {
                            subPath.add(items.get(j));
                        }
                        BreadcrumbItemChoices bic = new BreadcrumbItemChoices(item, BasicBreadcrumbBarUI.this.breadcrumbBar.getContentProvider().getPathChoices(subPath));
                        if (bic.getChoices() == null || bic.getChoices().size() <= 0) continue;
                        this.publish(bic);
                    }
                }
                return null;
            }

            @Override
            protected void process(List<Object> chunks) {
                if (chunks != null) {
                    for (Object chunk : chunks) {
                        if (this.isCancelled() || BasicBreadcrumbBarUI.this.atomicCounter.get() > 1) break;
                        if (chunk instanceof BreadcrumbItemChoices) {
                            BasicBreadcrumbBarUI.this.pushChoices((BreadcrumbItemChoices)chunk, false);
                        }
                        if (!(chunk instanceof BreadcrumbItem)) continue;
                        BasicBreadcrumbBarUI.this.pushChoice((BreadcrumbItem)chunk);
                    }
                }
                BasicBreadcrumbBarUI.this.updateComponents();
            }

            @Override
            protected void done() {
                BasicBreadcrumbBarUI.this.atomicCounter.decrementAndGet();
                BasicBreadcrumbBarUI.this.stopLoadingTimer();
            }
        };
        this.pathChangeWorker.execute();
    }

    protected void uninstallDefaults(JBreadcrumbBar<?> bar) {
    }

    protected void uninstallComponents(JBreadcrumbBar<?> bar) {
        this.stopLoadingTimer();
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        this.commandStack.clear();
        bar.remove(this.scrollerPanel);
    }

    protected void uninstallListeners(JBreadcrumbBar<?> bar) {
        bar.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.breadcrumbBar.getContentModel().removePathListener(this.pathListener);
        this.pathListener = null;
    }

    private synchronized void startLoadingTimer() {
        if (this.loadingTimer == null) {
            this.loadingTimer = new Timer(100, actionEvent -> {
                this.loadingTimer.stop();
                this.circularProgress.setVisible(false);
                this.mainPanel.remove(this.circularProgress);
                this.circularProgress.setVisible(true);
                this.isShowingProgress = true;
                this.mainPanel.add(this.circularProgress);
                this.mainPanel.revalidate();
                this.mainPanel.repaint();
            });
        }
        if (this.loadingTimer.isRunning()) {
            this.loadingTimer.stop();
        }
        this.loadingTimer.start();
    }

    private synchronized void stopLoadingTimer() {
        if (this.loadingTimer != null && this.loadingTimer.isRunning()) {
            this.loadingTimer.stop();
        }
        this.isShowingProgress = false;
        this.mainPanel.remove(this.circularProgress);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    protected synchronized void updateComponents() {
        if (!this.breadcrumbBar.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        this.commandStack.clear();
        BreadcrumbBarPresentationModel breadcrumbBarPresentationModel = this.breadcrumbBar.getPresentationModel();
        CommandButtonPresentationModel commandPresentation = CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.MEDIUM).setIconFilterStrategies(breadcrumbBarPresentationModel.getActiveIconFilterStrategy(), breadcrumbBarPresentationModel.getEnabledIconFilterStrategy(), breadcrumbBarPresentationModel.getDisabledIconFilterStrategy()).setPopupPlacementStrategy((RadianceThemingSlices.PopupPlacementStrategy)RadianceThemingSlices.PopupPlacementStrategy.Endward.VALIGN_TOP).setHorizontalGapScaleFactor(0.75).setPopupMenuPresentationModel(CommandPopupMenuPresentationModel.builder().setMaxVisibleMenuCommands(10).setMenuIconFilterStrategies(breadcrumbBarPresentationModel.getActiveIconFilterStrategy(), breadcrumbBarPresentationModel.getEnabledIconFilterStrategy(), breadcrumbBarPresentationModel.getDisabledIconFilterStrategy()).build()).build();
        for (int i = 0; i < this.modelStack.size(); ++i) {
            BreadcrumbItemChoices lastBic;
            List choices;
            JCommandButton button;
            Command command;
            Object element = this.modelStack.get(i);
            if (element instanceof BreadcrumbItemChoices) {
                BreadcrumbItemChoices bic = (BreadcrumbItemChoices)element;
                if (this.buttonStack.isEmpty()) {
                    command = ((Command.Builder)Command.builder().setSecondaryContentModel(new CommandMenuContentModel(new CommandGroup(new Command[0])))).build();
                    button = (JCommandButton)command.project(commandPresentation).buildComponent();
                    button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                    this.configureBreadcrumbButton(button);
                    this.configurePopupAction(command, bic);
                    this.configurePopupRollover(button);
                    this.buttonStack.add(button);
                    this.commandStack.add(command);
                    continue;
                }
                JCommandButton button2 = this.buttonStack.getLast();
                Command command2 = this.commandStack.getLast();
                button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                this.configurePopupAction(command2, bic);
                this.configurePopupRollover(button2);
                continue;
            }
            if (!(element instanceof BreadcrumbItem)) continue;
            BreadcrumbItem bi = (BreadcrumbItem)element;
            command = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(bi.getDisplayName())).setIconFactory(bi.getIconFactory())).setSecondaryContentModel(new CommandMenuContentModel(new CommandGroup(new Command[0])))).build();
            button = (JCommandButton)command.project(commandPresentation).buildComponent();
            this.configureBreadcrumbButton(button);
            this.configureMainAction(command, bi);
            if (i > 0 && (choices = (lastBic = (BreadcrumbItemChoices)this.modelStack.get(i - 1)).getChoices()) != null) {
                for (int j = 0; j < choices.size(); ++j) {
                    if (!bi.getDisplayName().equals(choices.get(j).getDisplayName())) continue;
                    lastBic.setSelectedIndex(j);
                    break;
                }
            }
            this.buttonStack.addLast(button);
            this.commandStack.addLast(command);
        }
        for (JCommandButton jcb : this.buttonStack) {
            this.mainPanel.add(jcb);
        }
        if (this.isShowingProgress) {
            this.mainPanel.add(this.circularProgress);
        }
        this.scrollerPanel.revalidate();
        this.scrollerPanel.repaint();
        SwingUtilities.invokeLater(() -> {
            this.scrollerPanel.scrollToIfNecessary(this.mainPanel.getPreferredSize().width, 0);
            this.scrollerPanel.repaint();
        });
    }

    private void configureMainAction(Command command, BreadcrumbItem<Object> bi) {
        command.setAction(commandActionEvent -> SwingUtilities.invokeLater(() -> {
            BreadcrumbBarContentModel<Object> barContentModel = this.breadcrumbBar.getContentModel();
            int itemIndex = barContentModel.indexOf(bi);
            int toLeave = itemIndex < 0 ? 0 : itemIndex + 1;
            barContentModel.setCumulative(true);
            while (barContentModel.getItemCount() > toLeave) {
                barContentModel.removeLast();
            }
            barContentModel.setCumulative(false);
        }));
    }

    private void configurePopupAction(Command command, BreadcrumbItemChoices<Object> bic) {
        ArrayList<Command> menuCommands = new ArrayList<Command>();
        List<BreadcrumbItem<Object>> items = bic.getChoices();
        int i = 0;
        while (i < items.size()) {
            BreadcrumbItem<Object> bi = items.get(i);
            Command.Builder commandBuilder = Command.builder();
            commandBuilder.setText(bi.getDisplayName());
            commandBuilder.setIconFactory(bi.getIconFactory());
            int biIndex = i++;
            commandBuilder.setAction(commandActionEvent -> SwingUtilities.invokeLater(() -> {
                int toLeave;
                BreadcrumbBarContentModel<Object> barContentModel = this.breadcrumbBar.getContentModel();
                barContentModel.setCumulative(true);
                int itemIndex = barContentModel.indexOf(bic.getAncestor());
                int n = toLeave = bic.getAncestor() == null || itemIndex < 0 ? 0 : itemIndex + 1;
                while (barContentModel.getItemCount() > toLeave) {
                    barContentModel.removeLast();
                }
                barContentModel.addLast(bi);
                bic.setSelectedIndex(biIndex);
                barContentModel.setCumulative(false);
            }));
            Command menuCommand = commandBuilder.build();
            menuCommands.add(menuCommand);
        }
        CommandMenuContentModel popupMenuContentModel = new CommandMenuContentModel(new CommandGroup(menuCommands));
        if (bic.getSelectedIndex() >= 0) {
            popupMenuContentModel.setHighlightedCommand((Command)menuCommands.get(bic.getSelectedIndex()));
        }
        CommandMenuContentModel commandPopupMenuContentModel = command.getSecondaryContentModel();
        commandPopupMenuContentModel.removeAllCommandGroups();
        commandPopupMenuContentModel.addCommandGroup(new CommandGroup(menuCommands));
    }

    private void configurePopupRollover(final JCommandButton button) {
        button.getPopupModel().addChangeListener(new ChangeListener(){
            boolean rollover;
            {
                this.rollover = button.getPopupModel().isRollover();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(() -> {
                    boolean isRollover = button.getPopupModel().isRollover();
                    if (isRollover == this.rollover) {
                        return;
                    }
                    if (isRollover) {
                        for (JCommandButton bcbButton : BasicBreadcrumbBarUI.this.buttonStack) {
                            if (bcbButton == button || !bcbButton.getPopupModel().isPopupShowing()) continue;
                            BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(button2.getBounds().x, button.getWidth());
                            button.doPopupClick();
                        }
                    }
                    this.rollover = isRollover;
                });
            }
        });
    }

    private void configureBreadcrumbButton(JCommandButton button) {
        button.getPopupModel().addChangeListener(changeEvent -> {
            PopupButtonModel model = button.getPopupModel();
            boolean displayDownwards = model.isRollover() || model.isPopupShowing();
            RadianceThemingSlices.PopupPlacementStrategy.Downward popupPlacementStrategy = displayDownwards ? RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_START : RadianceThemingSlices.PopupPlacementStrategy.Endward.VALIGN_TOP;
            button.setPopupPlacementStrategy((RadianceThemingSlices.PopupPlacementStrategy)popupPlacementStrategy);
        });
    }

    protected Object pushChoices(BreadcrumbItemChoices<Object> bic) {
        return this.pushChoices(bic, true);
    }

    protected synchronized Object pushChoices(BreadcrumbItemChoices<Object> bic, boolean toUpdateUI) {
        if (bic == null) {
            return null;
        }
        if (this.modelStack.size() % 2 == 1) {
            this.modelStack.pop();
        }
        this.modelStack.addLast(bic);
        if (toUpdateUI) {
            this.updateComponents();
        }
        return bic;
    }

    protected synchronized Object pushChoice(BreadcrumbItem bi) {
        assert (bi != null);
        if (!this.modelStack.isEmpty() && this.modelStack.size() % 2 == 0) {
            this.modelStack.pop();
        }
        this.modelStack.addLast(bi);
        return bi;
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = ((BasicBreadcrumbBarUI)BasicBreadcrumbBarUI.this).forSizing.getPreferredSize().height;
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int buttonHeight = ((BasicBreadcrumbBarUI)BasicBreadcrumbBarUI.this).forSizing.getPreferredSize().height;
            return new Dimension(10, buttonHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(0, 0, width, height);
        }
    }
}

