/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.internal.theming.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.radiance.component.internal.theming.utils.RibbonTaskToggleButtonBackgroundDelegate;
import org.pushingpixels.radiance.component.internal.ui.ribbon.BasicRibbonTaskToggleButtonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;

public class RadianceRibbonTaskToggleButtonUI
extends BasicRibbonTaskToggleButtonUI
implements TransitionAwareUI {
    private CommandButtonVisualStateTracker radianceVisualStateTracker;
    private PropertyChangeListener radiancePropertyChangeListener;
    private RibbonTaskToggleButtonBackgroundDelegate delegate = new RibbonTaskToggleButtonBackgroundDelegate();

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceRibbonTaskToggleButtonUI();
    }

    private RadianceRibbonTaskToggleButtonUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.commandButton.setOpaque(false);
        this.commandButton.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 12, 0, 12);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }
        });
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.commandButton, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor((JComponent)this.commandButton, (double)0.25);
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.commandButton);
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallComponents() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.commandButton);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceVisualStateTracker = new CommandButtonVisualStateTracker();
        this.radianceVisualStateTracker.installListeners(this.commandButton);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("contextualGroupHueColor".equals(propertyChangeEvent.getPropertyName())) {
                Color newValue = (Color)propertyChangeEvent.getNewValue();
                this.commandButton.setBackground(newValue);
            }
        };
        this.commandButton.addPropertyChangeListener(this.radiancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.radianceVisualStateTracker.uninstallListeners(this.commandButton);
        this.radianceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        Graphics2D g2d = (Graphics2D)g.create();
        this.delegate.updateTaskToggleButtonBackground(g2d, (JRibbonTaskToggleButton)this.commandButton);
        this.paintTextAndFocus(g2d);
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    private void paintTextAndFocus(Graphics g) {
        int strWidth;
        FontMetrics fm = g.getFontMetrics();
        String toPaint = this.commandButton.getText();
        int fullInsets = this.commandButton.getInsets().left;
        int pw = this.getPreferredSize((JComponent)this.commandButton).width;
        int mw = this.getMinimumSize((JComponent)this.commandButton).width;
        int w = this.commandButton.getWidth();
        int h = this.commandButton.getHeight();
        int insets = fullInsets - (pw - w) * (fullInsets - 2) / (pw - mw);
        Rectangle textRect = new Rectangle(insets, 1 + (h - fm.getHeight()) / 2, w - 2 * insets, fm.getHeight());
        while (toPaint.length() != 0 && (strWidth = fm.stringWidth(toPaint)) > textRect.width) {
            toPaint = toPaint.substring(0, toPaint.length() - 1);
        }
        int finalStrWidth = fm.stringWidth(toPaint);
        if (finalStrWidth < textRect.width) {
            int delta = textRect.width - finalStrWidth;
            textRect.x += delta / 2;
            textRect.width -= delta;
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.radianceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        float buttonAlpha = RadianceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)currState);
        Color fgColor = RadianceRibbonTaskToggleButtonUI.getForegroundColor(this.commandButton, modelStateInfo);
        if (buttonAlpha < 1.0f) {
            Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
            fgColor = RadianceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
        }
        RadianceTextUtilities.paintText((Graphics)g, (Rectangle)textRect, (String)toPaint, (int)-1, (Font)this.commandButton.getFont(), (Color)fgColor, null);
        Color focusColor = RadianceColorUtilities.getAlphaColor((Color)fgColor, (int)192);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)g2d, (int)0, (int)0, (int)this.commandButton.getWidth(), (int)this.commandButton.getWidth(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float radius = (float)scaleFactor * RibbonTaskToggleButtonBackgroundDelegate.getTaskToggleButtonCornerRadius((JRibbonTaskToggleButton)this.commandButton);
            float focusRingPadding = (float)scaleFactor * RadianceSizeUtils.getFocusRingPadding((Component)this.commandButton, (int)RadianceSizeUtils.getComponentFontSize((Component)this.commandButton));
            Shape contour = RadianceOutlineUtilities.getBaseOutline((float)scaledWidth, (float)scaledHeight, (float)radius, EnumSet.of(RadianceThemingSlices.Side.BOTTOM), (float)focusRingPadding);
            RadianceCoreUtilities.paintFocus((Graphics)graphics1X, (Component)this.commandButton, (Component)this.commandButton, (TransitionAwareUI)this, (double)scaleFactor, (Shape)contour, (Rectangle)textRect, (Color)focusColor, (float)1.0f, (float)0.0f);
        });
        g2d.dispose();
    }

    private static Color getForegroundColor(JCommandButton button, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currStateIgnoreSelection = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)true);
        ComponentState currState = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)false);
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        RadianceColorScheme buttonFillScheme = RadianceColorSchemeUtilities.getColorScheme((Component)button, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.FILL, (ComponentState)currStateIgnoreSelection);
        RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)button);
        RadianceThemingSlices.DecorationAreaType parentDecorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType((Component)button.getParent());
        RadianceColorScheme parentFillScheme = skin.getBackgroundColorScheme(parentDecorationAreaType);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            RadianceColorScheme schemeForCurrState = currState == ComponentState.ENABLED ? parentFillScheme : buttonFillScheme;
            return schemeForCurrState.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            boolean correspondsToParentFill = activeState == ComponentState.ENABLED && !button.getActionModel().isSelected();
            RadianceColorScheme activeColorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)button, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.FILL, (ComponentState)activeState);
            Color activeForeground = correspondsToParentFill ? parentFillScheme.getForegroundColor() : activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCommandButton button = (JCommandButton)c;
        JButton forSizing = new JButton(button.getText(), (Icon)button.getIcon());
        Dimension result = forSizing.getUI().getPreferredSize(forSizing);
        Insets borderInsets = button.getBorder().getBorderInsets(button);
        result.width += borderInsets.left + borderInsets.right;
        result.height += borderInsets.top + borderInsets.bottom;
        return result;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.radianceVisualStateTracker.getActionStateTransitionTracker();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }
}

