/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.internal.theming.common.BladeTransitionAwareRadianceIcon;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.component.internal.ui.common.RadianceInternalButton;
import org.pushingpixels.radiance.component.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadianceRibbonBandUI
extends BasicRibbonBandUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceRibbonBandUI();
    }

    private RadianceRibbonBandUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.ribbonBand, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
        Insets insets = RadianceSizeUtils.getDefaultBorderInsets((int)RadianceSizeUtils.getComponentFontSize((Component)this.ribbonBand));
        this.ribbonBand.setBorder(new EmptyBorder(0, insets.left, 0, insets.right));
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbonBand);
        super.uninstallDefaults();
    }

    @Override
    protected void paintBandTrailingSeparator(Graphics graphics, Rectangle toFill) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        if (this.ribbonBand.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            g2d.translate(toFill.width - 2, 0);
        }
        SeparatorPainterUtils.paintSeparator((Component)this.ribbonBand, (Graphics)g2d, (int)0, (int)toFill.height, (int)1, (boolean)true, (int)5);
        g2d.dispose();
    }

    @Override
    protected void paintBandTitle(Graphics graphics, Rectangle titleRectangle, String title) {
        if (titleRectangle.width <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        FontUIResource controlFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        g2d.setFont(controlFont.deriveFont(controlFont.getSize2D() - 1.0f));
        FontMetrics fm = graphics.getFontMetrics();
        int currLength = (int)fm.getStringBounds(title, g2d).getWidth();
        Object titleToPaint = title;
        while (currLength > titleRectangle.width) {
            title = title.substring(0, title.length() - 1);
            titleToPaint = title + "...";
            currLength = (int)fm.getStringBounds((String)titleToPaint, g2d).getWidth();
        }
        RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.ribbonBand);
        Color bgFillColor = RadianceCoreUtilities.getBackgroundFill((RadianceSkin)skin, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
        RadianceColorScheme bgColorScheme = skin.getBackgroundColorScheme(RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
        Color fgColor = bgColorScheme.getForegroundColor();
        fgColor = RadianceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)0.95f);
        g2d.setColor(fgColor);
        int deltaX = (titleRectangle.width - currLength) / 2;
        int deltaY = (titleRectangle.height - fm.getAscent() - fm.getDescent()) / 2;
        Rectangle smallTitleRectangle = new Rectangle(titleRectangle.x + deltaX, titleRectangle.y + deltaY, titleRectangle.width - 2 * deltaX, titleRectangle.height - 2 * deltaY);
        RadianceTextUtilities.paintText((Graphics)g2d, (Rectangle)smallTitleRectangle, (String)titleToPaint, (int)-1, (Font)g2d.getFont(), (Color)g2d.getColor(), (Rectangle)g2d.getClipBounds());
        g2d.dispose();
    }

    @Override
    public int getBandTitleHeight() {
        return 1 + RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)this.ribbonBand), (int)17, (int)1, (int)1, (boolean)false);
    }

    @Override
    protected JCommandButton createExpandButton() {
        CommandButtonProjection<Command> expandCommandProjection = new CommandButtonProjection<Command>(this.expandCommand, CommandButtonPresentationModel.builder().setActionKeyTip(this.ribbonBand.getExpandButtonKeyTip()).build());
        expandCommandProjection.setComponentSupplier(projection -> x$0 -> new RibbonBandExpandButton((Projection)x$0));
        expandCommandProjection.setComponentCustomizer(button -> {
            RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)button, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
            RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.ribbonBand);
            button.setIcon(this.getExpandButtonIcon(skin, (JCommandButton)button));
            RadianceThemingCortex.ComponentScope.setButtonStraightSides((JComponent)button, EnumSet.allOf(RadianceThemingSlices.Side.class));
        });
        return (JCommandButton)expandCommandProjection.buildComponent();
    }

    @Override
    protected Command createExpandCommand() {
        return ((Command.Builder)((Command.Builder)Command.builder().setAction(this.ribbonBand.getExpandCommandListener())).setActionRichTooltip(this.ribbonBand.getExpandButtonRichTooltip())).build();
    }

    private RadianceIcon getExpandButtonIcon(RadianceSkin skin, JCommandButton button) {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        BladeTransitionAwareRadianceIcon arrowIcon = new BladeTransitionAwareRadianceIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (g, scheme, width, height) -> {
            Color bgFillColor = RadianceCoreUtilities.getBackgroundFill((RadianceSkin)skin, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.CONTROL_PANE);
            BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.ribbonBand.getComponentOrientation().isLeftToRight() ? 3 : 7), (RadianceColorScheme)RadianceColorSchemeUtilities.getShiftedScheme((RadianceColorScheme)scheme, (Color)bgFillColor, (double)0.0, (Color)bgFillColor, (double)0.3f));
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        return arrowIcon;
    }

    @Override
    protected void syncExpandButtonIcon() {
        RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.ribbonBand);
        this.expandCommand.setIconFactory(() -> this.getExpandButtonIcon(skin, this.expandButton));
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.ribbonBand.getFont());
        GhostPaintingUtils.paintGhostImages((Component)c, (Graphics)g2d);
        BackgroundPaintingUtils.update((Graphics)g2d, (JComponent)c, (boolean)false);
        this.paint(g2d, c);
        g2d.dispose();
    }

    @org.pushingpixels.radiance.theming.internal.utils.RadianceInternalButton
    private static class RibbonBandExpandButton
    extends JCommandButton
    implements RadianceInternalButton {
        private RibbonBandExpandButton(Projection<JCommandButton, Command, CommandButtonPresentationModel> projection) {
            super(projection);
            this.setBorder(new EmptyBorder(3, 2, 3, 2));
        }
    }
}

