/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.component.api.common.JTriStateCheckBox;
import org.pushingpixels.radiance.component.api.common.model.TriStateCheckBoxContentModel;
import org.pushingpixels.radiance.component.internal.ui.common.BasicTriStateCheckBoxUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;

public class RadianceTriStateCheckBoxUI
extends BasicTriStateCheckBoxUI {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableMarkColorScheme = new BladeColorScheme();

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceTriStateCheckBoxUI((JTriStateCheckBox)comp);
    }

    private RadianceTriStateCheckBoxUI(JTriStateCheckBox triStateCheckBox) {
        super(triStateCheckBox);
    }

    @Override
    protected void updateIcon() {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)this.triStateCheckBox);
        final int checkMarkSize = RadianceSizeUtils.getCheckBoxMarkSize((int)fontSize);
        this.radianceIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                StateTransitionTracker.ModelStateInfo modelStateInfo = RadianceTriStateCheckBoxUI.this.stateTransitionTracker.getModelStateInfo();
                RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter((Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox);
                RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox);
                ComponentState currState = modelStateInfo.getCurrModelState();
                float visibility = RadianceTriStateCheckBoxUI.this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION, RadianceThemingSlices.ComponentStateFacet.MIX);
                float selectedStrength = RadianceTriStateCheckBoxUI.this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
                float mixStrength = RadianceTriStateCheckBoxUI.this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.MIX);
                float checkmarkFlatness = 0.0f;
                if (selectedStrength > 0.0f && mixStrength > 0.0f) {
                    checkmarkFlatness = mixStrength;
                }
                if (selectedStrength == 0.0f && mixStrength > 0.0f) {
                    checkmarkFlatness = 1.0f;
                }
                if (selectedStrength > 0.0f && mixStrength == 0.0f) {
                    checkmarkFlatness = 0.0f;
                }
                boolean isCheckMarkFadingOut = !currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION);
                float alpha = RadianceColorSchemeUtilities.getAlpha((Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox, (ComponentState)currState);
                BladeUtils.populateColorScheme((BladeColorScheme)RadianceTriStateCheckBoxUI.this.mutableFillColorScheme, (Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, (boolean)false);
                BladeUtils.populateColorScheme((BladeColorScheme)RadianceTriStateCheckBoxUI.this.mutableBorderColorScheme, (Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, (boolean)false);
                BladeUtils.populateColorScheme((BladeColorScheme)RadianceTriStateCheckBoxUI.this.mutableMarkColorScheme, (Component)RadianceTriStateCheckBoxUI.this.triStateCheckBox, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK, (boolean)false);
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.translate(x, y);
                BladeIconUtils.drawCheckBox((Graphics2D)graphics, (JComponent)RadianceTriStateCheckBoxUI.this.triStateCheckBox, (RadianceFillPainter)fillPainter, (RadianceBorderPainter)borderPainter, (int)checkMarkSize, (ComponentState)currState, (RadianceColorScheme)RadianceTriStateCheckBoxUI.this.mutableFillColorScheme, (RadianceColorScheme)RadianceTriStateCheckBoxUI.this.mutableMarkColorScheme, (RadianceColorScheme)RadianceTriStateCheckBoxUI.this.mutableBorderColorScheme, (float)visibility, (float)checkmarkFlatness, (boolean)isCheckMarkFadingOut, (float)alpha);
                graphics.dispose();
            }

            @Override
            public int getIconWidth() {
                return checkMarkSize;
            }

            @Override
            public int getIconHeight() {
                return checkMarkSize;
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JTriStateCheckBox b = (JTriStateCheckBox)c;
        if (RadianceCoreUtilities.isOpaque((JComponent)c)) {
            BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = b.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        String buttonText = ((TriStateCheckBoxContentModel)this.triStateCheckBox.getProjection().getContentModel()).getText();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, buttonText, this.radianceIcon, 0, 0, 0, 11, this.viewRect, this.iconRect, this.textRect, buttonText == null ? 0 : this.iconTextGap);
        Graphics2D g2d = (Graphics2D)g.create();
        if (text != null && !text.equals("")) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.textRect);
            } else {
                float buttonAlpha = RadianceColorSchemeUtilities.getAlpha((Component)b, (ComponentState)ComponentState.getState((TriStateButtonModel)b.getTriStateButtonModel(), (boolean)false));
                RadianceTextUtilities.paintText((Graphics)g, (JComponent)b, (Rectangle)this.textRect, (String)text, (int)-1, (StateTransitionTracker.ModelStateInfo)this.stateTransitionTracker.getModelStateInfo(), (float)buttonAlpha);
            }
        }
        if (this.radianceIcon != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            this.radianceIcon.paintIcon(c, g2d, this.iconRect.x, this.iconRect.y);
        }
        float focusRingPadding = RadianceSizeUtils.getFocusRingPadding((Component)b, (int)RadianceSizeUtils.getComponentFontSize((Component)b)) / 2.0f;
        Graphics2D graphicsFocus = (Graphics2D)g2d.create();
        graphicsFocus.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphicsFocus, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> RadianceCoreUtilities.paintFocus((Graphics)graphics1X, (Component)b, (Component)b, (TransitionAwareUI)this, (double)scaleFactor, null, (Rectangle)this.textRect, (float)1.0f, (float)((float)scaleFactor * focusRingPadding)));
        graphicsFocus.dispose();
        g2d.dispose();
    }
}

