/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.bcb.JBreadcrumbBar;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.RolloverActionListener;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.JCommandPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonFrame;
import org.pushingpixels.radiance.component.internal.theming.common.BladeTransitionAwareRadianceIcon;
import org.pushingpixels.radiance.component.internal.theming.common.GlowingRadianceIcon;
import org.pushingpixels.radiance.component.internal.theming.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.radiance.component.internal.theming.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.radiance.component.internal.theming.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.radiance.component.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.component.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.shaper.ClassicButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverControlListener;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostingListener;

public class RadianceCommandButtonUI
extends BasicCommandButtonUI
implements ActionPopupTransitionAwareUI {
    private PropertyChangeListener radiancePropertyListener;
    private GhostingListener radianceModelChangeListener;
    private CommandButtonVisualStateTracker radianceVisualStateTracker;
    private ButtonModel overallRolloverModel = new DefaultButtonModel();
    private RolloverControlListener radianceOverallRolloverListener;
    private MouseListener rolloverMenuMouseListener;
    private StateTransitionTracker overallStateTransitionTracker;
    private CommandButtonBackgroundDelegate commandButtonBackgroundDelegate;
    private GlowingRadianceIcon glowingIcon;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceCommandButtonUI((JCommandButton)comp);
    }

    RadianceCommandButtonUI(JCommandButton button) {
        this.overallRolloverModel.setArmed(false);
        this.overallRolloverModel.setSelected(false);
        this.overallRolloverModel.setPressed(false);
        this.overallRolloverModel.setRollover(false);
        this.overallRolloverModel.setEnabled(button.isEnabled());
        this.overallStateTransitionTracker = new StateTransitionTracker((JComponent)button, this.overallRolloverModel);
        this.radianceVisualStateTracker = new CommandButtonVisualStateTracker();
        this.commandButtonBackgroundDelegate = new CommandButtonBackgroundDelegate();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        RadianceThemingCortex.ComponentScope.setButtonShaper((JComponent)this.commandButton, (RadianceButtonShaper)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceVisualStateTracker.installListeners(this.commandButton);
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("actionModel".equals(propertyChangeEvent.getPropertyName())) {
                if (this.radianceModelChangeListener != null) {
                    this.radianceModelChangeListener.unregisterListeners();
                }
                this.radianceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
                this.radianceModelChangeListener.registerListeners();
            }
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                this.trackGlowingIcon();
            }
        };
        this.commandButton.addPropertyChangeListener(this.radiancePropertyListener);
        this.radianceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.radianceModelChangeListener.registerListeners();
        this.radianceOverallRolloverListener = new RolloverControlListener((TransitionAwareUI)this, this.overallRolloverModel);
        this.commandButton.addMouseListener((MouseListener)this.radianceOverallRolloverListener);
        this.commandButton.addMouseMotionListener((MouseMotionListener)this.radianceOverallRolloverListener);
        this.overallStateTransitionTracker.registerModelListeners();
        this.rolloverMenuMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (RadianceCommandButtonUI.this.commandButton.isEnabled() && ((CommandButtonPresentationModel)RadianceCommandButtonUI.this.commandButton.getProjection().getPresentationModel()).isMenu()) {
                    int modifiers = 0;
                    AWTEvent currentEvent = EventQueue.getCurrentEvent();
                    if (currentEvent instanceof InputEvent) {
                        modifiers = ((InputEvent)currentEvent).getModifiersEx();
                    } else if (currentEvent instanceof ActionEvent) {
                        modifiers = ((ActionEvent)currentEvent).getModifiers();
                    }
                    RadianceCommandButtonUI.this.fireRolloverActionPerformed(new ActionEvent(this, 1001, RadianceCommandButtonUI.this.commandButton.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                    List<PopupPanelManager.PopupInfo> popupInfoList = PopupPanelManager.defaultManager().getShownPath();
                    int popupInfoListSize = popupInfoList.size();
                    if (popupInfoListSize >= 1 && popupInfoList.get(popupInfoListSize - 1).getPopupPanel() instanceof JRibbonFrame.GlobalPopupMenuPanel && popupInfoList.get(popupInfoListSize - 1).getPopupOriginator() == RadianceCommandButtonUI.this.commandButton) {
                        return;
                    }
                    RadianceCommandButtonUI.this.processPopupAction();
                }
            }
        };
        this.commandButton.addMouseListener(this.rolloverMenuMouseListener);
        this.trackGlowingIcon();
    }

    @Override
    protected void uninstallListeners() {
        this.radianceVisualStateTracker.uninstallListeners(this.commandButton);
        this.radianceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.radianceModelChangeListener.unregisterListeners();
        this.radianceModelChangeListener = null;
        this.commandButton.removeMouseListener((MouseListener)this.radianceOverallRolloverListener);
        this.commandButton.removeMouseMotionListener((MouseMotionListener)this.radianceOverallRolloverListener);
        this.radianceOverallRolloverListener = null;
        this.overallStateTransitionTracker.unregisterModelListeners();
        this.commandButton.removeMouseListener(this.rolloverMenuMouseListener);
        this.rolloverMenuMouseListener = null;
        super.uninstallListeners();
    }

    public void fireRolloverActionPerformed(ActionEvent e) {
        RolloverActionListener[] listeners = (RolloverActionListener[])this.commandButton.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(e);
        }
    }

    private void trackGlowingIcon() {
        RadianceIcon currIcon = this.commandButton.getIcon();
        if (currIcon instanceof GlowingRadianceIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        boolean isPopupOnly = this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY;
        StateTransitionTracker tracker = isPopupOnly ? this.radianceVisualStateTracker.getPopupStateTransitionTracker() : this.radianceVisualStateTracker.getActionStateTransitionTracker();
        this.glowingIcon = new GlowingRadianceIcon(currIcon, tracker.getIconGlowTracker());
    }

    private void paintButtonBackground(Graphics graphics) {
        if (RadianceCoreUtilities.isComponentNeverPainted((Component)this.commandButton)) {
            return;
        }
        Rectangle actionArea = this.getLayoutInfo().actionClickArea;
        Rectangle popupArea = this.getLayoutInfo().popupClickArea;
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.commandButtonBackgroundDelegate.updateBackground(g2d, this.commandButton, this.getActionTransitionTracker(), actionArea, this.getPopupTransitionTracker(), popupArea);
        g2d.dispose();
    }

    private void paintButtonIconRegular(Graphics g, Rectangle iconRect, Color textColor) {
        RadianceIcon icon = this.commandButton.getIcon();
        if (iconRect == null || icon == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)this.commandButton, (Icon)icon, (Rectangle)iconRect);
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.commandButton, (Graphics)g));
        StateTransitionTracker tracker = this.radianceVisualStateTracker.getActionStateTransitionTracker();
        ButtonModel model = this.commandButton.getActionModel();
        if (this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            tracker = this.radianceVisualStateTracker.getPopupStateTransitionTracker();
            model = this.commandButton.getPopupModel();
        }
        this.commandButtonBackgroundDelegate.paintCommandButtonIcon(g2d, iconRect, this.commandButton, (Icon)icon, this.glowingIcon, model, tracker, textColor);
        g2d.dispose();
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect, Color textColor) {
        boolean isSelectedMenu;
        boolean bl = isSelectedMenu = this.commandButton.getActionModel().isSelected() && ((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu();
        if (isSelectedMenu) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.translate(iconRect.x, iconRect.y);
            RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)iconRect.width, (int)iconRect.height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
                Rectangle2D.Float extended = new Rectangle2D.Float(-1.0f, -1.0f, (float)scaledWidth + 2.0f, (float)scaledHeight + 2.0f);
                ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
                RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
                RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter((Component)this.commandButton);
                fillPainter.paintContourBackground((Graphics)graphics1X, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, fillScheme);
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
                RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)this.commandButton);
                borderPainter.paintBorder((Graphics)graphics1X, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, null, borderScheme);
            });
            graphics.dispose();
        }
        this.paintButtonIconRegular(g, iconRect, textColor);
        RadianceIcon iconToPaint = this.commandButton.getIcon();
        if (isSelectedMenu && iconToPaint == null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            g2d.setColor(fillScheme.getForegroundColor());
            int iw = iconRect.width;
            int ih = iconRect.height;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.2f * (float)iw, 0.5f * (float)ih);
            path.lineTo(0.42f * (float)iw, 0.8f * (float)ih);
            path.lineTo(0.8f * (float)iw, 0.2f * (float)ih);
            g2d.translate(iconRect.x, iconRect.y);
            BasicStroke stroke = new BasicStroke(0.12f * (float)iw, 1, 1);
            g2d.setStroke(stroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    private void paintButtonHorizontalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(0, separatorArea.y);
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (RadianceColorScheme)colorScheme, (int)this.commandButton.getWidth(), (int)1, (int)0, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    private void paintButtonVerticalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(separatorArea.x, 0);
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (RadianceColorScheme)colorScheme, (int)1, (int)this.commandButton.getHeight(), (int)1, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    @Override
    protected boolean isPaintingBackground() {
        if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu() && (this.commandButton.getActionModel().isRollover() || this.commandButton.getBackgroundAppearanceStrategy() != RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER)) {
            return true;
        }
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.commandButton.hasFocus() || this.overallStateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected boolean isPaintingSeparators() {
        if (super.isPaintingSeparators()) {
            return true;
        }
        boolean hasIcon = this.commandButton.getIcon() != null;
        return this.commandButton.hasFocus() || hasIcon && this.overallStateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected RadianceIcon createPopupActionIcon() {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)this.commandButton);
        int arrowIconHeight = (int)RadianceSizeUtils.getArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)RadianceSizeUtils.getArrowIconWidth((int)fontSize);
        return new BladeTransitionAwareRadianceIcon(this.commandButton, this::getPopupTransitionTracker, (g, scheme, width, height) -> {
            RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy = this.commandButton.getPopupPlacementStrategy();
            int direction = popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.Downward ? 5 : (this.commandButton.getComponentOrientation().isLeftToRight() ? 3 : 7);
            BladeArrowIconUtils.drawArrow((Graphics2D)g, (float)width, (float)height, (float)(RadianceSizeUtils.getArrowStrokeWidth((int)fontSize) - 0.5f), (int)direction, (RadianceColorScheme)scheme);
        }, new Dimension(arrowIconWidth, arrowIconHeight));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean useActionAreaForFg;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.commandButton.getFont());
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d);
        }
        StateTransitionTracker transitionTrackerForFg = (useActionAreaForFg = this.layoutInfo.isTextInActionArea) ? this.getActionTransitionTracker() : this.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfoForFg = transitionTrackerForFg.getModelStateInfo();
        ComponentState currStateForFg = modelStateInfoForFg.getCurrModelState();
        Color fgColor = this.getForegroundColor(modelStateInfoForFg);
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                RadianceTextUtilities.paintText((Graphics)g2d, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            RadianceColorScheme disabledColorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            Color disabledFgColor = disabledColorScheme.getForegroundColor();
            float buttonAlpha = RadianceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = RadianceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (currStateForFg.isDisabled()) {
                disabledFgColor = RadianceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)RadianceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            disabledFgColor = RadianceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)fgColor, (double)0.5);
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                RadianceTextUtilities.paintText((Graphics)g2d, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect, this.getForegroundColor(this.getActionTransitionTracker().getModelStateInfo()));
        }
        if (this.layoutInfo.popupActionRect.getWidth() > 0.0) {
            this.paintPopupActionIcon(g2d, this.layoutInfo.popupActionRect);
        }
        if (this.isPaintingSeparators() && this.layoutInfo.separatorArea != null) {
            if (this.layoutInfo.separatorOrientation == CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL) {
                this.paintButtonHorizontalSeparator(g2d, this.layoutInfo.separatorArea);
            } else {
                this.paintButtonVerticalSeparator(g2d, this.layoutInfo.separatorArea);
            }
        }
        Graphics2D focusGraphics = (Graphics2D)g2d.create();
        focusGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)focusGraphics, (int)0, (int)0, (int)this.commandButton.getWidth(), (int)this.commandButton.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float focusRingPadding = (float)scaleFactor * RadianceSizeUtils.getFocusRingPadding((Component)this.commandButton, (int)RadianceSizeUtils.getComponentFontSize((Component)this.commandButton));
            Rectangle innerFocusArea = this.isInnerFocusOnAction ? this.layoutInfo.actionClickArea : this.layoutInfo.popupClickArea;
            Rectangle2D.Float insetFocusArea = new Rectangle2D.Float((float)scaleFactor * (float)innerFocusArea.x + focusRingPadding, (float)scaleFactor * (float)innerFocusArea.y + focusRingPadding, (float)scaleFactor * (float)innerFocusArea.width - 2.0f * focusRingPadding, (float)scaleFactor * (float)innerFocusArea.height - 2.0f * focusRingPadding);
            RadianceCoreUtilities.paintFocus((Graphics)graphics1X, (Component)this.commandButton, (Component)this.commandButton, (TransitionAwareUI)this, (double)scaleFactor, (Shape)insetFocusArea, (Rectangle)innerFocusArea, (float)1.0f, (float)0.0f);
        });
        g2d.dispose();
        g2d.dispose();
    }

    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = RadianceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu()) {
                fgColor = RadianceCommandButtonUI.getMenuButtonForegroundColor(this.commandButton, modelStateInfo);
                if (buttonAlpha < 1.0f) {
                    Color bgFillColor = RadianceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                    fgColor = RadianceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
                }
            } else {
                fgColor = RadianceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfo, (float)buttonAlpha);
            }
        }
        return fgColor;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        this.paint(g2d, c);
        if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu()) {
            KeyTipRenderingUtilities.renderButtonKeyTips(g, this.commandButton, this.layoutManager);
        }
        g2d.dispose();
    }

    private void paintPopupActionIcon(Graphics g, Rectangle popupActionRect) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.popupActionIcon.paintIcon((Component)this.commandButton, (Graphics)g2d, popupActionRect.x + (popupActionRect.width - this.popupActionIcon.getIconWidth()) / 2, popupActionRect.y + (popupActionRect.height - this.popupActionIcon.getIconHeight()) / 2);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCommandButton button = (JCommandButton)c;
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getPresentationState() == CommandButtonPresentationState.MEDIUM && SwingUtilities.getAncestorOfClass(JRibbon.class, button) == null && SwingUtilities.getAncestorOfClass(JBreadcrumbBar.class, button) == null && SwingUtilities.getAncestorOfClass(JCommandPopupMenuPanel.class, button) == null) {
            JButton forSizing = new JButton(button.getText(), (Icon)button.getIcon());
            Dimension result = shaper.getPreferredSize((AbstractButton)forSizing, superPref);
            if (ComponentUtilities.hasPopupAction(button)) {
                result.width = superPref.width;
            }
            return result;
        }
        return superPref;
    }

    private float getSeparatorAlpha() {
        ComponentState actionAreaState = this.getActionTransitionTracker().getModelStateInfo().getCurrModelState();
        if (!actionAreaState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION) && !actionAreaState.isDisabled()) {
            float actionRolloverCycle = this.getActionTransitionTracker().getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
            float popupRolloverCycle = this.getPopupTransitionTracker().getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
            return Math.min(1.0f, actionRolloverCycle + popupRolloverCycle);
        }
        return 1.0f;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.overallStateTransitionTracker;
    }

    public boolean isInside(MouseEvent me) {
        boolean inAction = this.layoutInfo.actionClickArea != null && this.layoutInfo.actionClickArea.contains(me.getPoint());
        boolean inPopup = this.layoutInfo.popupClickArea != null && this.layoutInfo.popupClickArea.contains(me.getPoint());
        return inAction || inPopup;
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.radianceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.radianceVisualStateTracker.getPopupStateTransitionTracker();
    }

    private static Color getMenuButtonForegroundColor(JCommandButton menuButton, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        RadianceThemingSlices.ColorSchemeAssociationKind currAssocKind = RadianceThemingSlices.ColorSchemeAssociationKind.FILL;
        if (currState.isActive() && !currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER)) {
            currAssocKind = RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT;
        }
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)menuButton, (RadianceThemingSlices.ColorSchemeAssociationKind)currAssocKind, (ComponentState)currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            RadianceThemingSlices.ColorSchemeAssociationKind assocKind = RadianceThemingSlices.ColorSchemeAssociationKind.FILL;
            if (activeState.isActive() && !activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER)) {
                assocKind = RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT;
            }
            RadianceColorScheme activeColorScheme = RadianceColorSchemeUtilities.getColorScheme((Component)menuButton, (RadianceThemingSlices.ColorSchemeAssociationKind)assocKind, (ComponentState)activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }
}

