/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.tristate;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.component.api.common.JTriStateCheckBox;

public abstract class BasicTriStateListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener {
    protected JTriStateCheckBox button;

    public BasicTriStateListener(JTriStateCheckBox button) {
        this.button = button;
    }

    public void installKeyboardActions() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("pressed", new TriStateAction("pressed"));
        actionMap.put("released", new TriStateAction("released"));
        SwingUtilities.replaceUIActionMap(this.button, actionMap);
        InputMap km = (InputMap)UIManager.get("CheckBox.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.button, 0, km);
    }

    public void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.button, 2, null);
        SwingUtilities.replaceUIInputMap(this.button, 0, null);
        SwingUtilities.replaceUIActionMap(this.button, null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
        b.invalidate();
        b.revalidate();
        b.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
        TriStateButtonModel model = b.getTriStateButtonModel();
        model.setPressed(false);
        b.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTriStateCheckBox b;
        if (SwingUtilities.isLeftMouseButton(e) && (b = (JTriStateCheckBox)e.getSource()).contains(e.getX(), e.getY())) {
            TriStateButtonModel model = b.getTriStateButtonModel();
            if (!model.isEnabled()) {
                return;
            }
            model.setPressed(true);
            if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                b.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
            TriStateButtonModel model = b.getTriStateButtonModel();
            model.setPressed(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
        TriStateButtonModel model = b.getTriStateButtonModel();
        if (!SwingUtilities.isLeftMouseButton(e)) {
            model.setRollover(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
        TriStateButtonModel model = b.getTriStateButtonModel();
        model.setRollover(false);
    }

    private static class TriStateAction
    implements Action {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private String name;

        private TriStateAction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTriStateCheckBox b = (JTriStateCheckBox)e.getSource();
            String key = this.getName();
            if (Objects.equals(key, PRESS)) {
                TriStateButtonModel model = b.getTriStateButtonModel();
                model.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            } else if (Objects.equals(key, RELEASE)) {
                TriStateButtonModel model = b.getTriStateButtonModel();
                model.setPressed(false);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public Object getValue(String key) {
            if (Objects.equals(key, "Name")) {
                return this.name;
            }
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

