/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon.synapse;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.pushingpixels.radiance.component.api.common.projection.Projection;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentPresentationModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.RibbonCheckBoxContentModel;

public class JRibbonCheckBox
extends JCheckBox {
    public JRibbonCheckBox(Projection<JRibbonCheckBox, RibbonCheckBoxContentModel, ComponentPresentationModel> projection) {
        super(((RibbonCheckBoxContentModel)projection.getContentModel()).getText());
        final RibbonCheckBoxContentModel contentModel = (RibbonCheckBoxContentModel)projection.getContentModel();
        this.setSelected(contentModel.isSelected());
        this.setEnabled(contentModel.isEnabled());
        this.addActionListener(actionEvent -> {
            if (contentModel.getActionListener() != null) {
                contentModel.getActionListener().actionPerformed(actionEvent);
            }
        });
        this.addItemListener(new ItemListener(){
            boolean isSelected;
            {
                this.isSelected = contentModel.isSelected();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean newSelected;
                boolean bl = newSelected = e.getStateChange() == 1;
                if (this.isSelected != newSelected) {
                    this.isSelected = newSelected;
                    contentModel.setSelected(newSelected);
                    if (contentModel.getItemListener() != null) {
                        contentModel.getItemListener().itemStateChanged(e);
                    }
                }
            }
        });
        contentModel.addPropertyChangeListener(propertyChangeEvent -> {
            if ("selected".equals(propertyChangeEvent.getPropertyName())) {
                this.setSelected(contentModel.isSelected());
            }
        });
    }
}

