/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon;

import java.util.Collections;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.CommandAction;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.radiance.component.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.radiance.component.internal.ui.ribbon.CommandButtonLayoutManagerBigFixed;
import org.pushingpixels.radiance.component.internal.ui.ribbon.CommandButtonLayoutManagerBigFixedLandscape;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonGallery;

public class JRibbonBand
extends AbstractRibbonBand {
    public static final CommandButtonPresentationState BIG_FIXED_LANDSCAPE = new CommandButtonPresentationState("Big Fixed Landscape", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton button) {
            return new CommandButtonLayoutManagerBigFixedLandscape();
        }
    };
    public static final CommandButtonPresentationState BIG_FIXED = new CommandButtonPresentationState("Big Fixed", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(JCommandButton button) {
            return new CommandButtonLayoutManagerBigFixed();
        }
    };

    public JRibbonBand(String title, RadianceIcon.Factory iconFactory) {
        this(title, iconFactory, null);
    }

    public JRibbonBand(String title, RadianceIcon.Factory iconFactory, CommandAction expandCommandListener) {
        super(title, iconFactory, expandCommandListener, new JBandControlPanel());
        this.resizePolicies = Collections.unmodifiableList(CoreRibbonResizePolicies.getCorePoliciesPermissive(this));
        this.updateUI();
    }

    public JCommandButton addRibbonCommand(CommandButtonProjection<? extends Command> projection, PresentationPriority priority) {
        JCommandButton commandButton = (JCommandButton)projection.buildComponent();
        ((JBandControlPanel)this.getControlPanel()).addCommandButton(commandButton, priority);
        return commandButton;
    }

    public void addRibbonGallery(RibbonGalleryProjection galleryProjection, PresentationPriority priority) {
        JRibbonGallery gallery = new JRibbonGallery(galleryProjection);
        ((JBandControlPanel)this.getControlPanel()).addRibbonGallery(gallery, priority);
    }

    public void addRibbonComponent(ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection) {
        JRibbonComponent ribbonComponent = new JRibbonComponent(projection);
        ((JBandControlPanel)this.getControlPanel()).addRibbonComponent(ribbonComponent);
    }

    public int startGroup() {
        return ((JBandControlPanel)this.getControlPanel()).startGroup();
    }

    public int startGroup(String groupTitle) {
        return ((JBandControlPanel)this.getControlPanel()).startGroup(groupTitle);
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        ((JBandControlPanel)this.getControlPanel()).setGroupTitle(groupIndex, groupTitle);
    }

    @Override
    public AbstractRibbonBand cloneBand() {
        JRibbonBand result = new JRibbonBand(this.getTitle(), this.getIconFactory(), this.getExpandCommandListener());
        result.applyComponentOrientation(this.getComponentOrientation());
        return result;
    }

    public static enum PresentationPriority {
        TOP,
        MEDIUM,
        LOW;

    }
}

