/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.projection;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JComponent;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.model.PresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.BlackboxProjection;

public abstract class Projection<T extends JComponent, C extends ContentModel, P extends PresentationModel>
extends BlackboxProjection<C, P> {
    private ComponentSupplier<T, C, P> componentSupplier;
    private ComponentCustomizer<T> componentCustomizer;
    private Map<Command, ComponentCustomizer<JCommandButton>> commandComponentCustomizers;
    private Map<Command, ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>> commandComponentSuppliers;

    protected Projection(C contentModel, P presentationModel, ComponentSupplier<T, C, P> componentSupplier) {
        super(contentModel, presentationModel);
        this.componentSupplier = componentSupplier;
        this.commandComponentCustomizers = new HashMap<Command, ComponentCustomizer<JCommandButton>>();
        this.commandComponentSuppliers = new HashMap<Command, ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>>();
    }

    public void setComponentSupplier(ComponentSupplier<T, C, P> componentSupplier) {
        if (componentSupplier == null) {
            throw new IllegalArgumentException("Cannot pass null component creator");
        }
        this.componentSupplier = componentSupplier;
    }

    public void setComponentCustomizer(ComponentCustomizer<T> componentCustomizer) {
        this.componentCustomizer = componentCustomizer;
    }

    public void setCommandComponentCustomizers(Map<Command, ComponentCustomizer<JCommandButton>> commandComponentCustomizers) {
        this.commandComponentCustomizers = commandComponentCustomizers;
    }

    public void setCommandComponentSuppliers(Map<Command, ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>> commandComponentSuppliers) {
        this.commandComponentSuppliers = commandComponentSuppliers;
    }

    public final ComponentSupplier<T, C, P> getComponentSupplier() {
        return this.componentSupplier;
    }

    public final ComponentCustomizer<T> getComponentCustomizer() {
        return this.componentCustomizer;
    }

    public final Map<Command, ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>> getCommandComponentSuppliers() {
        return this.commandComponentSuppliers;
    }

    public final Map<Command, ComponentCustomizer<JCommandButton>> getCommandComponentCustomizers() {
        return this.commandComponentCustomizers;
    }

    public T buildComponent() {
        JComponent result = (JComponent)this.getComponentSupplier().getComponentSupplier(this).apply(this);
        this.configureComponent(result);
        if (this.getComponentCustomizer() != null) {
            this.getComponentCustomizer().customizeComponent(result);
        }
        return (T)result;
    }

    protected abstract void configureComponent(T var1);

    @FunctionalInterface
    public static interface ComponentCustomizer<TC extends JComponent> {
        public void customizeComponent(TC var1);
    }

    @FunctionalInterface
    public static interface ComponentSupplier<TC extends JComponent, CC extends ContentModel, PC extends PresentationModel> {
        public Function<Projection<TC, CC, PC>, TC> getComponentSupplier(Projection<TC, CC, PC> var1);
    }
}

