/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.common.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeEvent;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeListener;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionCycler;
import org.pushingpixels.radiance.component.api.common.RichTooltip;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;

public class TriStateCheckBoxContentModel
implements ContentModel {
    public static TriStateSelectionCycler DEFAULT_CYCLER = currState -> {
        switch (currState) {
            case ON: {
                return TriStateButtonModel.SelectionState.OFF;
            }
            case MIXED: {
                return TriStateButtonModel.SelectionState.ON;
            }
        }
        return TriStateButtonModel.SelectionState.MIXED;
    };
    public static TriStateSelectionCycler ALTERNATIVE_CYCLER = currState -> {
        switch (currState) {
            case ON: {
                return TriStateButtonModel.SelectionState.MIXED;
            }
            case MIXED: {
                return TriStateButtonModel.SelectionState.OFF;
            }
        }
        return TriStateButtonModel.SelectionState.ON;
    };
    private boolean isEnabled;
    private RichTooltip richTooltip;
    private TriStateSelectionCycler selectionCycler;
    private TriStateSelectionChangeListener selectionChangeListener;
    private String text;
    private TriStateButtonModel.SelectionState selectionState;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private TriStateCheckBoxContentModel() {
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            String old = this.text;
            this.text = text;
            this.pcs.firePropertyChange("text", old, this.text);
        }
    }

    public TriStateButtonModel.SelectionState getSelectionState() {
        return this.selectionState;
    }

    public void setSelectionState(TriStateButtonModel.SelectionState selectionState) {
        if (this.selectionState != selectionState) {
            TriStateButtonModel.SelectionState oldState = this.selectionState;
            this.selectionState = selectionState;
            this.pcs.firePropertyChange("selectionState", oldState, this.selectionState);
        }
    }

    public TriStateSelectionCycler getSelectionCycler() {
        return this.selectionCycler;
    }

    public void setSelectionCycler(TriStateSelectionCycler selectionCycler) {
        if (selectionCycler == null) {
            throw new IllegalArgumentException("Cannot pass null cycler");
        }
        if (this.selectionCycler != selectionCycler) {
            TriStateSelectionCycler oldSelectionCycler = this.selectionCycler;
            this.selectionCycler = selectionCycler;
            this.pcs.firePropertyChange("selectionCycler", oldSelectionCycler, this.selectionCycler);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public TriStateSelectionChangeListener getSelectionChangeListener() {
        return this.selectionChangeListener;
    }

    public static class Builder {
        private boolean isEnabled = true;
        private RichTooltip richTooltip;
        private String text;
        private TriStateButtonModel.SelectionState selectionState;
        private TriStateSelectionCycler selectionCycler = DEFAULT_CYCLER;
        private TriStateSelectionChangeListener selectionChangeListener;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setSelectionState(TriStateButtonModel.SelectionState selectionState) {
            this.selectionState = selectionState;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public Builder setSelectionCycler(TriStateSelectionCycler selectionCycler) {
            if (selectionCycler == null) {
                throw new IllegalArgumentException("Cannot pass null cycler");
            }
            this.selectionCycler = selectionCycler;
            return this;
        }

        public Builder setSelectionChangeListener(TriStateSelectionChangeListener selectionChangeListener) {
            this.selectionChangeListener = selectionChangeListener;
            return this;
        }

        public TriStateCheckBoxContentModel build() {
            TriStateCheckBoxContentModel model = new TriStateCheckBoxContentModel();
            model.text = this.text;
            model.selectionState = this.selectionState;
            if (this.selectionChangeListener != null) {
                model.selectionChangeListener = new TriStateSelectionChangeListener(){
                    private TriStateButtonModel.SelectionState lastSelectionState;
                    {
                        this.lastSelectionState = selectionState;
                    }

                    public void itemTriStateSelectionChanged(TriStateSelectionChangeEvent e) {
                        TriStateButtonModel.SelectionState newState = e.getSelectionStateChange();
                        if (this.lastSelectionState == newState) {
                            return;
                        }
                        selectionChangeListener.itemTriStateSelectionChanged(e);
                        this.lastSelectionState = newState;
                    }
                };
            }
            model.selectionCycler = this.selectionCycler;
            model.isEnabled = this.isEnabled;
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

